#ifndef process_HH
#define process_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "process.hh": specific PROCESSing functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: process.desc,v $
 * Revision 1.2  1993/09/20  11:20:27  lotos
 * fix spelling of errors/warnings
 *
 * Revision 1.1  1993/03/18  11:14:24  lotos
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

/* semantics error printing function */

void	SEMwarn (int idn, TNODE *nodep, char *msg, ...);

/* semantics warning printing function */

void	SEMmiss (int idn, TNODE *nodep, char *msg, ...);

/* semantics information printing function */

void	SEMinfo (char *msg, ...);

/* semantics error clearing function */

#define SEMclear()	(ragerrors= 0)

/* semantics error counting function */

#define SEMcnt()	ragerrors

/* builds the specification */

int	build_spec ();

/* initializes a rule */

void	init_rule ();

/* builds the template */

int	build_tplt ();

/* prints the specification */

void	print_spec ();

/* draws the template */

void	draw_tplt ();

/* applies a rule to the specification */

void	apply_rule ();

/* applies the template to the specification */

int	apply_tplt ();

/* processes the whole specification */

int	proc_spec ();

/* saves the specification */

void	save_spec ();

#endif
