/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: idle.h,v $
 * Revision 1.11  1993/05/28  10:41:43  lotos
 * opcion -c tiene niveles
 *
 * Revision 1.10  1993/03/24  17:51:24  lotos
 * remove options -u and -s, that go into glad
 *
 * Revision 1.9  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.8  1992/12/02  10:55:08  lotos
 * option -s, modified
 *
 * Revision 1.7  1992/10/14  17:41:11  lotos
 * make local debugging facilities dependent on definition of NDEBUG
 *
 * Revision 1.6  1992/09/12  10:32:49  lotos
 * fix DESARROLLO
 *
 * Revision 1.5  1992/09/02  15:43:14  lotos
 * new option to remove externa annotations
 * new option to print and label the equations
 * new debugging options: save modified CAST
 * overall debugging and improvements
 *
 * Revision 1.4  92/01/14  15:24:46  lotos
 * distribution issues
 * 
 * Revision 1.3  91/11/20  13:01:59  lotos
 * ATable is read from a separate file
 * 
 * Revision 1.2  91/07/09  20:25:50  lotos
 * use nodes.h directly
 * 
 * Revision 1.1  91/02/06  20:04:48  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "idle.h": cabecera de "idle".

***********************************************************************/

#ifndef IDLE_H
#define IDLE_H

#ifndef NDEBUG
#  define DESARROLLO
#endif

#include "nodes.h"
#include "grc.h"
#include "pecast.h"
#include "errores.h"


typedef struct
{ unsigned InsCom;	/* Se insertan comentarios. */
  int EtiqReg;		/* Se etiquetan las reglas. */
  unsigned TamSang;	/* Tamano del nivel de sangrado. */
  char *FichTab;	/* Fichero de las tablas de la especificacion. */
  char *FichAST;	/* Fichero para almacenar el AST. */
} EstOpcProg;	/* Estructura para almacenar opciones del programa. */

extern char *NomProg;		/* Nombre del programa. */
extern EstOpcProg OpcProg;	/* Opciones del programa. */

/* Evita las quejas del "lint" sobre alineamiento de punteros. */
#ifndef lint
#  define ALIN(p)	(p)
#else
#  define ALIN(p)	((int)&*(p))
#endif

/* Asigna memoria para elementos de un tipo de datos. */
#define AsigMem(Tipo, NumElem) \
	  ((Tipo *) emalloc((unsigned) (sizeof(Tipo) * (NumElem))))

/* Libera memoria asignada previamente. */
#define LibMem(PuntVar) \
	  (efree((void *) ALIN(PuntVar)))

void *emalloc();
void efree();

#endif
