/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: lisec.c,v $
 * Revision 1.5  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.4  1992/10/14  17:43:38  lotos
 * forget about ophuscation
 *
 * Revision 1.3  1992/01/14  15:25:17  lotos
 * distribution issues
 *
 * Revision 1.2  92/01/13  19:24:45  lotos
 * adaptec to ophuscate
 * 
 * Revision 1.1  91/02/06  20:15:27  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: lisec.c,v 1.5 1993/01/18 18:12:15 lotos Exp $";
#endif

/***********************************************************************

     "lisec.o": modulo de gestion de listas circulares de ecuaciones.

***********************************************************************/

#include <stdio.h>
#include "idle.h"
#include "lisec.h"


/*
     Cualquier  operacion sobre  una lista,  que involucre a un elemento
(esto es,  una ecuacion) o posicion  de dicha lista,  se realizara sobre
el(la) siguiente al origen.
     La supresion de un  elemento (esto es,  una ecuacion) de una lista,
no conlleva  ningun cambio de  origen;  a lo sumo, que  la lista se con-
vierta en nula.  Sin embargo, cuando se produce una agregacion, el nuevo
elemento pasa a ser el origen.
*/


void InicLisEc(LisObj, EcInic)
/* Inicia la construccion de una lista de ecuaciones. */
EstLisEc *LisObj;	/* Lista objeto. */
EstManEc *EcInic;	/* Ecuacion inicial. */
{
  aborta_si(LisEcIncorr(LisObj) ||
	    LisObj->EcOrig != NULL)
  if (EcInic == NULL)
    EcInic= AsigMem(EstManEc, 1);
  EcInic->SigEc= EcInic;
  LisObj->EcOrig= EcInic;
}

void AgrEcLis(LisObj, EcAgr)
/* Agrega una ecuacion a una lista de ecuaciones. */
EstLisEc *LisObj;	/* Lista objeto. */
EstManEc *EcAgr;	/* Ecuacion a agregar. */
{ EstManEc *PrimEc;	/* Primera ecuacion. */

  aborta_si(LisEcIncorr(LisObj) ||
	    LisObj->EcOrig == NULL)
  if (EcAgr == NULL)
    EcAgr= AsigMem(EstManEc, 1);
  PrimEc= LisObj->EcOrig;
  EcAgr->SigEc= PrimEc->SigEc;
  LisObj->EcOrig= PrimEc->SigEc= EcAgr;
}

void SuprEcLis(LisObj)
/* Suprime una ecuacion de una lista de ecuaciones. */
EstLisEc *LisObj;	/* Lista objeto. */
{ EstManEc *PrimEc;	/* Primera ecuacion. */
  EstManEc *EcSupr;	/* Ecuacion a suprimir. */

  aborta_si(LisEcIncorr(LisObj) ||
	    LisObj->EcOrig == NULL)
  PrimEc= LisObj->EcOrig;
  EcSupr= PrimEc->SigEc;
  if (EcSupr == PrimEc)
  { /* Solo hay una ecuacion en la lista. */
    LibMem(EcSupr);
    LisObj->EcOrig= NULL;
  }
  else
  { /* Hay mas de una ecuacion en la lista. */
    PrimEc->SigEc= EcSupr->SigEc;
    LibMem(EcSupr);
  }
}

void SuprLisEc(LisObj)
/* Suprime una lista de ecuaciones. */
EstLisEc *LisObj;	/* Lista objeto. */
{
  aborta_si(LisEcIncorr(LisObj) ||
	    LisObj->EcOrig == NULL)
  do
    SuprEcLis(LisObj);
  while (LisObj->EcOrig != NULL);
}
