/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: matec.h,v $
 * Revision 1.3  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.2  1992/01/14  15:24:57  lotos
 * distribution issues
 *
 * Revision 1.1  91/02/06  20:10:06  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "matec.h": cabecera de "matec.o".

***********************************************************************/

#ifndef MATEC_H
#define MATEC_H

#include "lisec.h"


typedef struct ArgEc
{ struct ArgEc *SigEc;
  struct ArgEc *SigArg;
  TNODE *NodoArg;
} EstArgEc;	/* Estructura para manejar argumentos de ecuaciones. */

typedef struct
{ EstArgEc *ArgEcOrig;
  EstManEc *EcOrig;
} EstEcxArg;	/* Estructura matricial de ecuaciones por argumentos. */

/* Indica si una matriz de ecs. por args. es incorrecta. */
#define MatEcxArgIncorr(MatObj)			\
	 ((MatObj) == NULL ||			\
	  (MatObj)->EcOrig == NULL &&		\
	  (MatObj)->ArgEcOrig != NULL ||	\
	  (MatObj)->EcOrig != NULL &&		\
	  (MatObj)->ArgEcOrig == NULL)

void InicMatEcxArg();
/* Inicia la construccion de una matriz de ecs. por args. */

void AgrArgMat();
/* Agrega un argumento a una matriz de ecs. por args. */

void SuprArgMat();
/* Suprime un argumento de una matriz de ecs. por args. */

void AgrEcMat();
/* Agrega una ecuacion a una matriz de ecs. por args. */

void SuprEcMat();
/* Suprime una ecuacion de una matriz de ecs. por args. */

void SuprMatEcxArg();
/* Suprime una matriz de ecs. por args. */

void MueveEcMat();
/* Mueve una ecuacion de una a otra matriz de ecs. por args. */

void CopiaEcMat();
/* Copia una ecuacion de una a otra matriz de ecs. por args. */

#endif
