/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: patrones.c,v $
 * Revision 1.5  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.4  1992/10/14  17:43:41  lotos
 * forget about ophuscation
 *
 * Revision 1.3  1992/01/14  15:25:18  lotos
 * distribution issues
 *
 * Revision 1.2  92/01/13  19:24:47  lotos
 * adaptec to ophuscate
 * 
 * Revision 1.1  91/02/06  20:15:35  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: patrones.c,v 1.5 1993/01/18 18:12:15 lotos Exp $";
#endif

/***********************************************************************

     "patrones.o": modulo de gestion de patrones.

***********************************************************************/

#include <stdio.h>
#include "idle.h"
#include "patrones.h"


/*
     Un patron se compone de una pila de cero o mas elementos.  Por tan-
to, las operaciones que se realicen sobre uno de dichos elementos, afec-
taran unicamente al que este en lo alto de la pila.
*/


static EstElemPat *ElemLibres= NULL;	/* Lista de elementos libres. */


void InicPat(PatObj)
/* Inicializa un patron. */
EstPat *PatObj; 	/* Patron objeto. */
{
  aborta_si(PatObj == NULL)
  PatObj->UltElem= NULL;
  PatObj->NumElem= 0;
}

void AgrElemPat(PatObj, ElemAgr)
/* Agrega un elemento a un patron. */
EstPat *PatObj;		/* Patron objeto. */
EstElemPat *ElemAgr;	/* Elemento a agregar. */
{
  aborta_si(PatIncorr(PatObj))
  if (ElemAgr == NULL)
  { if (ElemLibres == NULL)
      ElemAgr= AsigMem(EstElemPat, 1);
    else
    { ElemAgr= ElemLibres;
      ElemLibres= ElemAgr->Ant;
    }
    ElemAgr->Tipo= Nulo;
    ElemAgr->Ref= NULL;
  }
  ElemAgr->Ant= PatObj->UltElem;
  PatObj->UltElem= ElemAgr;
  ++PatObj->NumElem;
}

void SuprElemPat(PatObj)
/* Suprime un elemento de un patron. */
EstPat *PatObj;		/* Patron objeto. */
{ EstElemPat *ElemSupr;	/* Elemento a suprimir. */

  aborta_si(PatIncorr(PatObj) ||
	    PatObj->NumElem == 0)
  ElemSupr= PatObj->UltElem;
  PatObj->UltElem= ElemSupr->Ant;
  --PatObj->NumElem;
  aborta_si(ElemSupr->Ref == NULL ||
	    ElemSupr->Tipo == Nulo)
  ElemSupr->Tipo= Nulo;
  ElemSupr->Ref= NULL;
  ElemSupr->Ant= ElemLibres;
  ElemLibres= ElemSupr;
}

void SuprPat(PatObj)
/* Suprime un patron. */
EstPat *PatObj;		/* Patron objeto. */
{
  aborta_si(PatIncorr(PatObj) ||
	    PatObj->NumElem == 0)
  do
    SuprElemPat(PatObj);
  while (PatObj->NumElem != 0);
}
