/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: tabop.h,v $
 * Revision 1.3  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.2  1992/01/14  15:24:55  lotos
 * distribution issues
 *
 * Revision 1.1  91/02/06  20:09:50  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "tabop.h": cabecera de "tabop.o".

***********************************************************************/

#ifndef TABOP_H
#define TABOP_H

#include "lisec.h"
#include "matec.h"


typedef struct
{ struct ManOp *Princ;
  struct ManOp *Fin;
} EstTramoOp;	/* Estructura de un tramo (sublista) de operaciones. */

typedef struct ManOp
{ int Num;
  char *Id;
  TNODE *Nodo;
  int Tipo;
  union
  { EstTramoOp TramoOp;
    EstLisEc LisEc;
    EstEcxArg MatEc;
  } u;
  struct ManOp *Sig;
} EstManOp;	/* Estructura para el manejo de operaciones. */

/* Tipos de entradas en la tabla. */
#define Clase		1
#define OpSinArg	2
#define OpConArg	3

typedef struct
{ EstManOp **Elem;
  int Max;
  int MaxId;
  int Estado;
  TNODE *Espec;
  EstManOp *LisCl;
  EstManOp *LisOp;
  EstManEc *LisEc;
} EstTabOp;	/* Estructura para manejar una tabla de operaciones. */

extern EstTabOp _TabOp;		/* Tabla de operaciones. */

void InicTabOp();
/* Inicializa la tabla de operaciones. */

void ComplTabOp();
/* Completa la tabla de operaciones. */

/* Devuelve el nodo raiz de la especificacion. */
TNODE *_RaizEspec();
#ifdef DESARROLLO
#  define RaizEspec()	(_RaizEspec())
#else
#  define RaizEspec()	(_TabOp.Espec)
#endif

/* Devuelve el ultimo identificador de la tabla. */
/* (Su numero de identificacion unico).          */
int _UltIdTab();
#ifdef DESARROLLO
#  define UltIdTab()	(_UltIdTab())
#else
#  define UltIdTab()	(_TabOp.MaxId)
#endif

/* Registra un nuevo identificador en la tabla. */
void _RegIdTab();
#ifdef DESARROLLO
#  define RegIdTab()	(_RegIdTab())
#else
#  define RegIdTab()	(++_TabOp.MaxId)
#endif

/* Devuelve una operacion de la tabla. */
EstManOp *_OpTab();
#ifdef DESARROLLO
#  define OpTab(Pos)	(_OpTab(Pos))
#else
#  define OpTab(Pos)	(_TabOp.Elem[Pos])
#endif

/* Devuelve la primera operacion de la tabla. */
EstManOp *_PrimOpTab();
#ifdef DESARROLLO
#  define PrimOpTab()	(_PrimOpTab())
#else
#  define PrimOpTab()	(_TabOp.LisOp)
#endif

/* Devuelve una clase de la tabla. */
EstManOp *_ClTab();
#ifdef DESARROLLO
#  define ClTab(Pos)	(_ClTab(Pos))
#else
#  define ClTab(Pos)	(_TabOp.Elem[Pos])
#endif

/* Devuelve la primera clase de la tabla. */
EstManOp *_PrimClTab();
#ifdef DESARROLLO
#  define PrimClTab()	(_PrimClTab())
#else
#  define PrimClTab()	(_TabOp.LisCl)
#endif

/* Devuelve la primera ecuacion de la tabla. */
EstManEc *_PrimEcTab();
#ifdef DESARROLLO
#  define PrimEcTab()	(_PrimEcTab())
#else
#  define PrimEcTab()	(_TabOp.LisEc)
#endif

#endif
