/**************************************************************
 *       draw.c - LBM Interpreter Drawing Functions
 **************************************************************/
/***********************************************
 (C) Copyright 1993-1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: draw.c,v $
 * Revision 1.3  1994/10/17  16:40:36  lotos
 * cosmetics
 *
 * Revision 1.2  1993/12/22  17:20:25  lotos
 * Changed a number of names in the interface
 * Added function  to work with instances of processes and their gates
 * CLOSING BASIC LOTOS VERSION OF LIBRARY!
 *
 * Revision 1.1  1993/10/16  10:52:26  lotos
 * Initial revision
 *
 **********************************************
 $Id: draw.c,v 1.3 1994/10/17 16:40:36 lotos Exp $
 **********************************************/

#include "swbus.h"

/* KJT 20/01/23: added function prototypes */
PUBLIC void fdraw_sset_off (FILE *fp, spe S, soffert *soffs, boolean rewrite);
PRIVATE void fdrawktnode (FILE  *fpfp, spe   S, krnlt kt, int class);

PUBLIC void
fdraw_gatelist (fp, S, gl)
  FILE    *fp;
  spe     S;
  gtelist gl;
{
  for ( ; gl != NULL; gl = INTtail (gl)) {
    (void)fprintf (fp, "%s", l2s (S, INThead (gl)));
    if (INTtail (gl) != NULL)
      (void)fprintf (fp, ", ");
  }
}

PUBLIC void
draw_gatelist (S, gl)
  spe     S;
  gtelist gl;
{
  fdraw_gatelist (stdout, S, gl);
}

PUBLIC void
fdraw_varlist (fp, S, vl)
  FILE    *fp;
  spe     S;
  varlist vl;
{
  for ( ; vl != NULL; vl = INTtail (vl)) {
    (void)fprintf (fp, "%s", l2s (S, INThead (vl)));
    if (INTtail (vl) != NULL)
      (void)fprintf (fp, ", ");
  }
}

PUBLIC void
draw_varlist (S, vl)
  spe     S;
  varlist vl;
{
  fdraw_varlist (stdout, S, vl);
}

PUBLIC void
fdraw_cond (fp, cnd, rewrite)
  FILE    *fp;
  cond    cnd;
  boolean rewrite;
{
  kdatum val1;
  kdatum val2;

  assert (cnd != NULL);

  if (rewrite) {
    val1 = kd_rw_node (kd_copy (cnd->val1));
    val2 = kd_rw_node (kd_copy (cnd->val2));
    if (UNDEF == ldiequal (kd_copy (val1), kd_copy (val2))) {
      (void)fprintf (fp, "[%s = ", kd_draw (val1));
      (void)fprintf (fp, "%s] ",  kd_draw (val2));
    }
  }
  else {
    (void)fprintf (fp, "[%s = ", kd_draw (kd_copy (cnd->val1)));
    (void)fprintf (fp, "%s] ", kd_draw (kd_copy (cnd->val2)));
  }
}

PUBLIC void
draw_cond (S, cnd, rewrite)
  spe     S;
  cond    cnd;
  boolean rewrite;
{
  fdraw_cond (stdout, cnd, rewrite);
}

PUBLIC void
fdraw_CNDlist (fp, cl, rewrite)
  FILE    *fp;
  CNDlist cl;
  boolean rewrite;
{
  for ( ; cl != NULL; cl = cl-> next)
    fdraw_cond (fp, cl->c, rewrite);
}

PUBLIC void
draw_CNDlist (cl, rewrite)
  CNDlist cl;
  boolean rewrite;
{
  fdraw_CNDlist (stdout, cl, rewrite);
}

PRIVATE void
fdraw_prdlist (fp, soff, rewrite)
  FILE    *fp;
  soffert *soff;
  boolean rewrite;
{
  varlist setvl;

  if (rewrite)
    setvl = rewrite_soffert (soff);

  fdraw_CNDlist (fp, soff->prdl, rewrite);

  if (rewrite)
    unrewrite_soffert (setvl);
}

PRIVATE void
fdraw_exper (fp, S, e)
  FILE  *fp;
  spe   S;
  exper e;
{
  switch (e->type) {
  case NOTYPE : /* It may the case a ? x : bool || a ? y : bool */
  case INTERR :
    (void)fprintf (fp, "? : %s ", l2s (S, e->sort));
    break;
  case EXCLAM :
    (void)fprintf (fp, "! ");
    (void)fprintf (fp, "%s ", kd_draw (e->val));
    break;
    default :
      fatal_error ("wrong type drawing experiment", __FILE__, __LINE__);
  }
}

PRIVATE void
draw_exper (S, e)
  spe   S;
  exper e;
{
  fdraw_exper (stdout, S, e);
}

PRIVATE void
fdraw_exper_list (fp, S, max, expl)
  FILE  *fp;
  spe   S;
  int   max;
  exper *expl;
{
  int i;

  for (i = 0; i < max; i++)
    fdraw_exper (fp, S, expl[i]);
}

PRIVATE void
draw_exper_list (S, max, expl)
  spe   S;
  int   max;
  exper *expl;
{
  fdraw_exper_list (stdout, S, max, expl);
}

PUBLIC void
fdraw_soff (fp, S, soff, rewrite)
  FILE    *fp;
  spe     S;
  soffert *soff;
  boolean rewrite;
{
  switch (soff->g) {
  case LNOGATE :
    (void)fprintf (fp, "NO GATE, MAYBE UNSTABLE\n");
    break;
  case LEXITG :
    (void)fprintf (fp, "EXIT ");
    if (soff->nexp > 0) {
      (void)fprintf (fp, "(");
      fdraw_exper_list (fp, S, soff->nexp, soff->expl);
      (void)fprintf (fp, ")");
    }
    break;
  case LINTERG :
    (void)fprintf (fp, "i ");
    break;
  default :
    if (soff->ready)
      (void)fprintf (fp, "i (* ");
    (void)fprintf (fp, "%s ", l2s (S, soff->g));
    fdraw_exper_list (fp, S, soff->nexp, soff->expl);
    fdraw_prdlist (fp, soff, rewrite);
    if (soff->ready)
      (void)fprintf (fp, "*) ");
  }
}

PUBLIC void
draw_soff (S, soff, rewrite)
  spe     S;
  soffert *soff;
  boolean rewrite;
{
  fdraw_soff (stdout, S, soff, rewrite);
}

PUBLIC void
fdraw_sset_off (fp, S, soffs, rewrite)
  FILE    *fp;
  spe     S;
  soffert *soffs;
  boolean rewrite;
{
  int i = 1;

  for (; soffs != NULL; soffs = soffs->next, i++) {
    (void)fprintf (fp, "%d) ", i);
    fdraw_soff (fp, S, soffs, rewrite);
    (void)fprintf (fp, "\n");
  }
}

PUBLIC void
draw_sset_off (S, soffs, rewrite)
  spe     S;
  soffert *soffs;
  boolean rewrite;
{
  fdraw_sset_off (stdout, S, soffs, rewrite);
}

PUBLIC void
fdraw_off (fp, S, off, rewrite)
  FILE    *fp;
  spe     S;
  offert  off;
  boolean rewrite;
{
  soffert *soff;

  soff = search_soffert (S, off);

  fdraw_soff (fp, S, soff, rewrite);
}

PUBLIC void
draw_off (S, off, rewrite)
  spe     S;
  offert  off;
  boolean rewrite;
{
  fdraw_off (stdout, S, off, rewrite);
}

PUBLIC void
fdraw_set_off (fp, S, offs, rewrite)
  FILE    *fp;
  spe     S;
  set_off offs;
  boolean rewrite;
{
  int i;

  assert (S != NULL);
  assert (offs != NULL);

  for (i = 1 ; offs != NULL; offs = rest_set_off (offs), i++) {
    (void)fprintf (fp, "%d) ", i);
    fdraw_soff (fp, S, search_soffert (S, first_off (offs)), rewrite);
    (void)fprintf (fp, "\n");
  }
}

PUBLIC void
draw_set_off (S, offs, rewrite)
  spe     S;
  set_off offs;
  boolean rewrite;
{
  fdraw_set_off (stdout, S, offs, rewrite);
}

PUBLIC void
fdraw_spe (fp, S)
  FILE *fp;
  spe  S;
{
  (void)fprintf (fp, "Name: %s\n", S->name);
  (void)fprintf (fp, "\tLBM\n"); save_tree (fp, S->lbmroot);
  (void)fprintf (fp, "\tBUTlist not printed\n");
  (void)fprintf (fp, "\talroot\n"); save_tree (fp, S->alroot);
  (void)fprintf (fp, "\tATable not printed\n");
  (void)fprintf (fp, "\tSymbolTable not printed\n");
  (void)fprintf (fp, "\tNumber of BUTs: %d\n", S->lastBUTnumber);
  (void)fprintf (fp, "\tgrnl not printed\n");
  (void)fprintf (fp, "\tKernel Tree:\n"); fdraw_kt (fp, S, S->kt);
  (void)fprintf (fp, "\tDo Process Hierarchy: %d\n", S->doph);
  if (S->doph) {
    (void)fprintf (fp, "\tProcess Hierarchy:\n");
    fdraw_hierarchy (fp, S, S->ph);
  }
  if (S->soffs != NULL) {
    (void)fprintf (fp, "\tCurrent offers:\n");
    fdraw_sset_off (fp, S, S->soffs, FALSE);
  }
}

PUBLIC void
draw_spe (S)
  spe S;
{
  fdraw_spe (stdout, S);
}

