/**************************************************************
 *       offerset.c - LBM Interpreter Offer Set Handling
 **************************************************************/
/***********************************************
 (C) Copyright 1993-1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: offerset.c,v $
 * Revision 1.2  1994/10/17  16:41:17  lotos
 * cosmetics
 *
 * Revision 1.1  1993/10/16  10:53:03  lotos
 * Initial revision
 *
 **********************************************
 $Id: offerset.c,v 1.2 1994/10/17 16:41:17 lotos Exp $
 **********************************************/

#include "swbus.h"

/**** FUNCTIONS FOR INTERNAL USE ONLY ****/

PUBLIC soffert*
cons_sset_off (sof, soffs)
  soffert *sof;
  soffert *soffs;
{
  assert (sof != NULL);

  sof->next = soffs;
  return sof;
}

PUBLIC soffert*
cp_sset_off (soffs)
  soffert *soffs;
{
  soffert *new = NULL, *aux;

  for (aux = soffs ; aux != NULL; aux = aux->next)
    new = cons_sset_off (cp_soffert (aux), new);
  return new;
}

/**** LIBRARY EXPORTED FUNCTIONS ****/

PUBLIC offert
one_off (S, offs)
  spe     S;
  set_off offs;
{
  int k;

  assert (offs != NULL);
  assert (S != NULL);

  if (S->cfg.rndm == NULL)
    return first_off (offs);
  else
    k = (int)(S->cfg.rndm () % card_set_off (offs)) + 1;

  return getnoff (k, offs);
}

PUBLIC set_off
del_off (of, offs)
  offert  of;
  set_off offs;
{
  set_off ptr, this = offs;

  if (offs != NULL) {
    if (INThead (offs) == of)
      offs = INTtail (offs);
    else
      for (ptr = offs; ptr != NULL; ptr = INTtail (ptr))
	if (INThead (INTtail (ptr)) == of) {
	  this = INTtail (ptr);
	  INTtail (ptr) = INTtail (INTtail (ptr));
	  break;
	}
    INThead (this) = -1;
    INTtail (this) = NULL;
    fIL ((CLR_TYPE)this);
    this = NULL;
  }
  return offs;
}

/* Matches two offerts from the SAME specification
 */
PUBLIC boolean
match_offerts (S1, of1, S2, of2)
  spe    S1;
  offert of1;
  spe    S2;
  offert of2;
{
  soffert *sof1, *sof2;

  sof1 = search_soffert (S1, of1);
  sof2 = search_soffert (S2, of2);

  if (sof1->g != sof2->g)
    return FALSE;

  if (sof1->nexp != sof2->nexp)
    return FALSE;

  if (sof1->nexp > 0)
    return match_expl (sof1->nexp, sof1->expl, sof2->expl);

  /* Falta comprobar los predicados!!! */

  return TRUE;
}
