/**************************************************************
 *       str.c - LBM Interpreter String Drawing Functions
 **************************************************************/
/***********************************************
 (C) Copyright 1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: str.c,v $
 * Revision 1.1  1994/11/08  17:00:11  lotos
 * Initial revision
 *
 **********************************************
 $Id: str.c,v 1.1 1994/11/08 17:00:11 lotos Exp $
 **********************************************/

#include "swbus.h"

#define TMP_FILE "tmp~"

/* KJT 20/01/23: added function prototypes */
int unlink(const char *pathname);

PRIVATE FILE *fpout;

PRIVATE char*
PrintFile ()
{
  char *st, *aux;

  st = emalloc (1000*sizeof (char));
  st[0] = '\0';
  aux = emalloc (BUFSIZ*sizeof (char));
  fpout = fopen (TMP_FILE, "r");
  if (fpout != NULL) {
    do {
      aux = fgets (aux, BUFSIZ, fpout);
      if (aux != NULL)
	(void)strncat (st, aux, BUFSIZ);
    } while (aux != NULL);
    (void)fclose (fpout);
    (void)unlink (TMP_FILE);
  }
  else {
    (void)fprintf (stderr, "Cannot open auxiliary file\n");
    exit (1);
  }
  return st;
}

PUBLIC char*
off2str (S, of)
  spe S;
  offert of;
{
  fpout = fopen (TMP_FILE, "w");
  fdraw_off (fpout, S, of, TRUE);
  (void)fclose (fpout);
  return PrintFile ();
}

PUBLIC char*
CNDlist2str (cl, rewrite)
  CNDlist cl;
  boolean rewrite;
{
  fpout = fopen (TMP_FILE, "w");
  fdraw_CNDlist (fpout, cl, rewrite);
  (void)fclose (fpout);
  return PrintFile ();
}

PUBLIC char*
PRDlist2str (S, off, pl, rewrite)
  spe     S;
  offert  off;
  CNDlist pl;
  boolean rewrite;
{
  soffert *soff;
  varlist setvl = NULL;

  fpout = fopen (TMP_FILE, "w");

  if (rewrite) {
    soff = search_soffert (S, off);

    setvl = rewrite_soffert (soff);
  }

  fdraw_CNDlist (fpout, pl, rewrite);
  (void)fclose (fpout);

  if (rewrite)
    unrewrite_soffert (setvl);

  return PrintFile ();
}

