/**************************************************************
 *       tree.h - LBM Interpreter Kernel Tree Interfaz
 **************************************************************/
/***********************************************
 (C) Copyright 1993-1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: tree.h,v $
 * Revision 1.2  1994/10/17  16:42:14  lotos
 * cosmetics
 *
 **********************************************
 $Id: tree.h,v 1.2 1994/10/17 16:42:14 lotos Exp $
 **********************************************/

/* The Kernel Tree. This should be opaque. */

/* Node classes. */

/* TERMINALS */

#define LUNDEFINED       0   /* Non stable */

#define LSTOP            1
#define LINTERNAL        2
#define LACTION          3
#define LEXIT            4

/* NON TERMINALS */

#define LCHOICE          5
#define LFULL_SYNC       6
#define LINTERLEAVING    7
#define LSYNC            8
#define LDISABLING       9
#define LENABLING        10
#define LHIDE            11
#define LRELABEL         12
#define LINSTANTIATION   13

/* values for "xto" field */
#define NOCHOOSEN 0 /* The kt leave was not offered           */
#define EXITED    1 /* The Kt was choosen for "exit"          */
#define NORMAL    2 /* The Kt was choosen with no "exit" sync */

/* Functions to manage the Kernel Tree */

#define FATHER(kt) kt->fth
#define FSON(kt)   kt->son1
#define SSON(kt)   kt->son2
#define BROTHER(kt) (FATHER (kt) == NULL)   \
            ? NULL : (FSON (FATHER (kt)) == kt)  \
	                 ? SSON (FATHER (kt)) : FSON (FATHER (kt))

void     label_kt ();
krnlt    simplify_kt ();
void     init_kt ();
void     evol_kt ();
krnlt    cp_kt ();

void     set_values_for_exit ();
void     clean_offer_propagation ();
void     offer_propagation ();
soffert  *available_events ();
proclist getactpikt ();
krnlt    search_kt ();
krnlt    search_pi_kt ();
