/******************************************************
*       ltg.c: LOTOS Test Generator
*******************************************************/
/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 * $Log: ltg.c,v $
 * Revision 1.4  1994/11/14  14:45:49  lotos
 * port to msdos
 *
 * Revision 1.3  1993/10/18  17:56:53  lotos
 * cleanup interface to interlib
 *
 * Revision 1.2  1993/10/01  11:20:41  lotos
 * integrate front end into test generator
 *
 * Revision 1.1  1993/09/30  14:30:46  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: ltg.c,v 1.4 1994/11/14 14:45:49 lotos Exp $";
#endif

#include "ltgswbus.h"
#include "omgrc.h"


PUBLIC char    *prog_name = NULL;

FILE	*tfp = NULL;
FILE	*sfp = NULL;
FILE	*ofp = NULL;

int	do_report = FALSE;
int	debugging = FALSE;

PRIVATE char sfile[BUFSIZ];  /* specification file */
PRIVATE char tfile[BUFSIZ];  /* test specification file */
PRIVATE char tpfile[BUFSIZ];  /* test specification file in ASCII format*/
PRIVATE char ltpfile[BUFSIZ];  /* test specification file in AST format*/
PRIVATE char ofile[BUFSIZ];  /* output file */

int flagd= 0;
int flags= 0;
int flagt= 0;
int flago= 0;
int flagh= 0;

/*************  DEFINE  *****************/

/*************  INCLUDES *****************/

#include <ctype.h>
#include <stdio.h>
#include <string.h>

/****************** functions ***************/

PRIVATE void
help ()
{
(void) fprintf (stderr,
     "Usage: ltg [-d] [-h] -s specification -t test [-o outputfile] \n");
exit (1);
}

PRIVATE FILE*
efopen(file, mode, toolname)
     char* file;
     char* mode;
     char* toolname;
{
  FILE* fp;
  FILE* fopen();

  if ((fp= fopen (file, mode)) == NULL) {
    (void) fprintf (stderr,
		    "%s: cannot open file %s mode %s\n",
		    toolname, file, mode);
    exit (1);
  }
  return fp;
} /* end of efopen */


/*****************************************/
PRIVATE TIOCOLOURS iocolours [] = {
# include "omcolours.c"
# include "intercolours.c"
	"actl",	 c_actl,  NULL,	writeacts,	NULL,	NULL,
	"factl", c_factl, NULL,	writeacts,	NULL,	NULL,
	"gmax",	 c_gmax,  IO_int,
	"gmin",	 c_gmin,  IO_int,
	"max",	 c_max,	  IO_int,
	"min",	 c_min,	  IO_int,
	"tof",   c_tof,   NULL,	wrtof,		NULL,   NULL,
	"print", c_print, IO_int,
	"obj",   c_obj,   IO_int,
	"exp",   c_exp,   NULL, wrexp,          NULL,   NULL,
	"exl",   c_exl,   NULL, wrexl,          NULL,   NULL,
	OTHERS
	};


/*******************  MAIN FUNCTION  *****************************/

/* KJT 20/01/23: added "int" type */
int main (argc, argv)
     int   argc;
     char* argv[];
{
  int  i;
  char c;
  TNODE* r;
  int sname;
  char cmd1[500];

  do_report = TRUE;
  prog_name = argv[0];

  while (argc > 1) {
    if (argv[1][0] == '-') {
      c = argv[1][1];
      switch (c) {
	case 's':
	  argc--;
	  argv++;
	  if (flags == 0){
	    flags++;
	   (void) strcpy (sfile, argv[1]);
	  } else {
	    flagh++;
	  }
	  break;
	case 't':
	  argc--;
	  argv++;
	  if (flagt == 0){
	    flagt++;
	    (void) strcpy (tfile, argv[1]);
	  } else {
	    flagh++;
	  }
	  break;
	case 'o':
	  argc--;
	  argv++;
	  if (flago == 0){
	    flago++;
	    (void) strcpy (ofile, argv[1]);
	  } else {
	    flagh++;
	  }
	  break;
	case 'd':
	  flagd++;
	  for (i=2; argv[1][i] == 'd'; i++)
	    flagd++;
	  if (argv[1][i] != '\0')
	    help ();
	  break;
	case 'h':
	default:
	  flagh++;
      }
    }
    argc--;
    argv++;
  }

  if ((flagh != 0) || (flags == 0) || (flagt == 0)){
    help ();
    exit (1);
  }
  cast_init (iocolours);

  if (flago != 0)
    ofp = efopen (ofile, "w", "ltg");
  else
    ofp = stdout;

  (void) strcpy (tpfile, tfile);
  (void) strcpy (ltpfile, tfile);

  (void) strcat (tpfile, ".tp");
  if ((tfp= fopen (tpfile, "r")) == NULL) {
    /* file tfile.tp does not exist */
    (void) fprintf (stderr, "ltg: cannot open file %s\n", tpfile);
    (void) fclose (tfp);
    help ();
    exit (1);
  } else {
    (void)sprintf (cmd1, "feltg %s.tp > %s.ltp\n", tfile, tfile);
    if (flagd > 0)
      (void) fprintf (ofp, cmd1);
    if (system (cmd1) != 0) {
      (void) fprintf (stderr, "ltg: %s.ltp generation failed\n",tpfile);
    }
  }


  (void) strcat (tfile, ".ltp");
  tfp = efopen (tfile, "r", "ltg");


  r= restore(tfp);

  grnl = (IAT*) find_attr (c_grnl, r)->value;
  grnl -> incr = 16;
  grnl -> class = 1;
  SymbolTable = (ST*) find_attr (c_ll, r)->value;
  SymbolTable->incr = 16;
  SymbolTable->class = 1;

  sname = STadd (sfile, SymbolTable, TRUE);
  set_attr(c_lexv, r, (CLR_TYPE) sname);
  rag (r);

  if (flagd < 2) {
    name2clr("actl")	->put=NULL;
    name2clr("factl")	->put=NULL;
    name2clr("gmax")	->put=NULL;
    name2clr("gmin")	->put=NULL;
    name2clr("max")	->put=NULL;
    name2clr("min")	->put=NULL;
    name2clr("act")	->put=NULL;
    name2clr("ofname")	->put=NULL;
  }


  if (flagd == 1)
    save_tree (ofp, r);
  else if (flagd > 1)
    dr_tree (r);

  (void) fclose (sfp);
  (void) fclose (tfp);
  if (ofp != stdout)
    (void) fclose (ofp);
  exit(0);
  return 0;
}
