/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: swbus.h,v $
 * Revision 2.4  1993/01/18  18:25:53  lotos
 * distribution issues
 *
 * Revision 2.3  1993/01/12  20:21:18  lotos
 * portability issues
 *
 * Revision 2.2  1993/01/12  14:39:05  lotos
 * use conf.h for portability
 *
 * Revision 2.1  1992/10/20  17:49:56  lotos
 * new KT evaluation algorithm
 * new Lbeta interface
 * cleaning, code optimization, space saving, bugs, ...
 *
 * Revision 1.10  1992/09/11  16:54:45  lotos
 * fix tree re-evaluation to take care of priorities
 *
 * Revision 1.9  1992/09/02  17:38:31  lotos
 * new data structture for a ready queue
 *
 * Revision 1.8  1992/05/06  18:55:12  lotos
 * send traces to stderr
 * make min-delay functionality upward compatible
 *
 * Revision 1.7  92/03/05  17:37:16  lotos
 * just a few more bugs went to the hell
 *
 * Revision 1.6  92/03/04  14:53:02  lotos
 * 100 minor bugettes
 *
 * Revision 1.5  92/02/29  13:26:24  lotos
 * miscellaneous bug fixing
 *
 * Revision 1.4  92/02/12  18:47:56  lotos
 * ni idea, era una version que andaba por ahi ...
 *
 * Revision 1.3  92/01/15  12:41:14  lotos
 * a bug in frames
 * change success and values
 *
 * Revision 1.2  92/01/14  19:38:18  lotos
 * lint fixes
 *
 * Revision 1.1  92/01/14  19:28:35  lotos
 * Initial revision
 *
 ***********************************
 $Id: swbus.h,v 2.4 1993/01/18 18:25:53 lotos Exp $
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <assert.h>
# include "version.h"

/* LINTLIBRARY */

#include "lotos.hh"

/* KJT 20/01/23: added header */
#include <time.h>

#ifndef NDEBUG
#endif

/***************** kfunc.c ***************/

void eval_tree ();
void  ad_gl ();
void  ex_gl ();
void  i_gl ();
void   simp_synch ();
PUBLIC void  simp_stop ();

/***************** ktree.c ******************/
	/* tree traversing */
#define  get_type(b)   b->btype
#define  set_type(b,t) b->btype = t

	/* tree management */
PUBLIC void cut ();
void   clean ();
void   value_en_passing ();
void   sustitute_brd ();
board  initial_tree ();

       /*----------------------------------------
	 --- AUX FUNCTIONS FOR MAKING THE TREE --
	 ----------------------------------------*/

void one_new_son ();
void two_new_sons ();
void evol_annot ();

/***************** negot.c *********************/
PUBLIC  boolean ad_ok ();
PUBLIC  boolean exit_ok ();
PUBLIC  void    valvar ();
/***************** offer.c ***************/
	/* tree leaves queue */
void   insert_lq ();
void   remove_lq ();
board  get_f_leave ();
board  get_n_leave ();

      /* tree ready queue */
void insert_rq ();
boolean  eof_rq ();
offert  get_rq  ();
/* -------------------------------*/
void    or_off ();
offert  and_off ();
/**************** draw.c ********************/
void dumpcore ();
void draw_node ();
void dump_node ();
void dump_tree ();
void draw_tree ();
void dump_off ();
void draw_off ();
void dump_leaves ();
void draw_leaves ();
void dump_ready  ();
void draw_ready ();

void mem_init ();
void reset_mmg ();
gate_list newgte ();
void freegte ();
rel_g_list newrgte ();
void freergte ();
var_list newvar ();
void freevar ();
experiment  newexp ();
exp_list newexpa ();
void freeexpa ();
PUBLIC board newboard ();
void freeboard ();
offert newoff ();
void freeoff ();

/*************************/

board_list    newbar ();
 offert     a_newoff ();
 experiment a_newexp ();
 exp_list   a_newexpa();
 board_list a_newbar();
/*  */

#define bctbl(b)  ctbl[b->frm->but](b)

SHARED    board   Kt;

PUBLIC frame  newframe ();
PUBLIC void   freeframe  ();
PUBLIC frame  frmcpy  ();
PUBLIC void   draw_frame ();
PUBLIC void   dump_frame();

PUBLIC offert a_cpoff ();

#define  brother(x) ((x->bth == NULL)? x->fth->sons :x->bth)
#define  father(b)    b->fth
#define  fson(b)      b->sons
#define  sson(b)      b->sons->bth

#define  offer_type(o)  o->act[0]->btype
#define  offer_gate(o)  o->adg
#define  get_leave(o)  o->act[0]

typedef struct st_arena {
  struct st_arena* next;
  int counter;
  void* field;
} st_arena;
typedef st_arena* arena;

#define test_delay(o)  (o->act[0]->stime <= time (NULL))
#define test_wait(o)  (ftbl [o->act[0]->prd](o->act[0]->frm))

PUBLIC void spec_param ();
PUBLIC void arena_init ();
SHARED boolean g_flag;
SHARED boolean eval_retry;

PUBLIC void * my_malloc ();

typedef struct st_rq_elem {
  int   prior;
  int   n;
  offert off;
  struct st_rq_elem * next;
  struct st_rq_elem * mmg;
} st_rq_elem;

typedef st_rq_elem* rq_elem;

SHARED board   Leaves_queue;
SHARED rq_elem Ready_queue;

PUBLIC void reset_freerqe ();



PUBLIC char * draw ();
