/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: pl.c,v $
 * Revision 2.5  1994/10/17  16:38:24  lotos
 * distribution
 *
 * Revision 2.4  1993/01/18  18:11:22  lotos
 * distribution issues
 *
 * Revision 2.3  1993/01/12  20:20:04  lotos
 * portability issues
 *
 * Revision 2.2  1992/09/12  10:24:47  lotos
 * keep *.h inclusions under strict control
 *
 * Revision 2.1  1992/02/07  17:27:10  lotos
 * complete remake of reshuffling functions
 *
 * Revision 1.5  92/02/07  17:23:21  lotos
 * main program, load and driver
 *
 * Revision 1.4  92/01/14  15:24:25  lotos
 * distribution issues
 *
 * Revision 1.3  92/01/13  19:40:12  lotos
 * adjusted to new grammar
 * ready to ophuscate
 *
 * Revision 1.2  91/02/28  19:38:27  lotos
 * better folding of boxes H->V
 * annotations are considered
 *
 * Revision 1.1  91/01/31  16:06:55  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: pl.c,v 2.5 1994/10/17 16:38:24 lotos Exp $";
#endif

# include "swbus.h"

int x_limit= 70;
int y_limit= 0;

int i_incr= 2;
int s_incr= 1;

/*****  private variables  *****/

PUBLIC	char*   toolname;

PUBLIC TIOCOLOURS iocolours [] = {
# include "colours.c"
	"box",       c_box,      IO_ign,
	"indent",    c_indent,   IO_int,
	OTHERS
	};

PRIVATE FILE	*sfp;
PRIVATE char	*sfile= NULL;
PRIVATE char	*atfile= NULL;

PUBLIC  int     flagd= 0;
PUBLIC  int     flagu= FALSE;
PUBLIC  int     flagl= FALSE;
PUBLIC	AT      *ATable= NULL;

PRIVATE FILE*
efopen(file, mode)
     char* file;
     char* mode;
{
  FILE* fp;
  FILE* fopen();

  if ((fp= fopen (file, mode)) == NULL) {
    (void) fprintf (stderr,
	    "cannot open file %s mode %s\n",
	    file, mode);
    exit (1);
  }
  return fp;
} /* end of efopen */

PUBLIC	void
help	()
{
  (void) fprintf (stderr,"usage: %s [-<opts>] [filename]\n", toolname);
  (void) fprintf (stderr,"\t-at attribute file name\n");
  (void) fprintf (stderr,"\t-i nn indentation increment\n");
  (void) fprintf (stderr,"\t-s nn space increment\n");
  (void) fprintf (stderr,"\t-x nn size of lines in characters\n");
  (void) fprintf (stderr,"\t-y nn size of pages in lines\n");
  (void) fprintf (stderr,"\t-u nn print unique identifiers\n");
  (void) fprintf (stderr,"\t-l nn print lexical identifiers (default)\n");
  (void) fprintf (stderr,"   default: full information\n");
}

PUBLIC int
main (argc, argv)
  int argc;
  char *argv[];
{
  int narg;
  char *arg;
  TNODE *r;

  toolname= argv[0];

  /* option processing */
  arg= argv[narg= 1];
  while (narg < argc && arg[0] == '-') {
    if (strcmp (arg, "-at") == 0) {
      narg++;
      atfile= argv[narg];
    }
    else if (strcmp (arg, "-i") == 0) {
      narg++;
      i_incr= atoi (argv[narg]);
    }
    else if (strcmp (arg, "-s") == 0) {
      narg++;
      s_incr= atoi (argv[narg]);
    }
    else if (strcmp (arg, "-x") == 0) {
      narg++;
      x_limit= atoi (argv[narg]);
    }
    else if (strcmp (arg, "-y") == 0) {
      narg++;
      y_limit= atoi (argv[narg]);
    }
    else if (strcmp (arg, "-u") == 0) {
      flagu= TRUE;
    }
    else if (strcmp (arg, "-l") == 0) {
      flagl= TRUE;
    }
    else if (strcmp (arg, "-d") == 0) {
      flagd++;
    }
    else {
      (void) fprintf (stderr, "%s: unknown option %s\n", arg);
      help ();
      exit (1);
    }
    arg= argv[++narg];
  }

  if (narg < argc)
    sfile= argv[narg];

  if (! flagu)
    flagl= TRUE;

  if (sfile != NULL)
    sfp= efopen (sfile, "r");
  else
    sfp= stdin;

  cast_init(iocolours);
  r= restore(sfp);
  if (r == NULL)
    exit (1);
  (void) fclose (sfp);
  if (find_attr (c_ll, r) == NULL) {
    TNODE* attree;
    char filename[BUFSIZ];
    FILE* flp;

    if (atfile == NULL) {
      (void) strcpy (filename, (char*) find_attr (c_name, r)->value);
      (void) strcat (filename, ".as");
    }
    else
      (void) strcpy (filename, atfile);
    if ((flp= fopen (filename, "r")) == NULL) {
      (void) fprintf (stderr, "pl: could not open %s\n", filename);
      exit (1);
    }
    if ((attree= restore (flp)) == NULL) {
      (void) fprintf (stderr, "pl: could not load AT CAST\n");
      exit (1);
    }
    set_attr(c_ll, r, find_attr(c_ll, attree)->value);
    find_attr(c_ll, attree)->value= NULL;
    set_attr(c_at, r, find_attr(c_at, attree)->value);
    find_attr(c_at, attree)->value= NULL;
    kill_tree(attree);
  }
  SymbolTable= (ST*) find_attr (c_ll, r)->value;
  if (find_attr (c_at, r) != NULL)
    ATable= (AT*) find_attr (c_at, r)->value;

  grnl= (IAT*)(find_attr(c_grnl, r)->value);
  rag(r);
  if (ragerrors > 0) {
    (void) fprintf (stderr, "pl: errors found\n");
    exit (1);
  }
  visit(r);
  exit (0);
  return 0;
}

