/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: tfilter.c,v $
 * Revision 1.4  1993/01/21  20:25:19  lotos
 * code generation for ildi
 *
 * Revision 1.3  1993/01/18  17:53:00  lotos
 * distribution issues
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: tfilter.c,v 1.4 1993/01/21 20:25:19 lotos Exp $";
#endif

# include "tfilter.h"

PRIVATE int ch;
PRIVATE int doprint= 0;

PRIVATE void
eatcomment (fi, fo)
  FILE *fi, *fo;
{
  int isldc= 0;
  char key[5];
  int i;

  if (doprint)
    (void) fprintf (fo, "(*");

  ch= getc (fi);
  if (ch == '|') {
    do {
      ch= getc (fi);
    } while (isspace (ch));
    i= 0;
    key[i++]= ch;
    do {
      key[i++]= ch= getc (fi);
    } while (i < 3 && isalpha (ch));
    key[i]= 0;
    if (strcmp (key, "ldc") == 0) {
      isldc= 1;
      if (!doprint)
	(void) fprintf (fo, "(*");
      (void) fprintf (fo, "| ldc\n");
    }
    else if (doprint)
      (void) fprintf (fo, "| %s", key);
  }
  else
    (void) ungetc (ch, fi);

  while ((ch= getc (fi)) != EOF) {
    if (doprint || isldc)
      (void) putc (ch, fo);
    switch (ch) {
    case '(':
      ch= getc (fi);
      if (ch == '*')
	eatcomment (fi, fo);
      else
        (void) ungetc (ch, fi);
      break;
    case '*':
      ch= getc (fi);
      if (ch == ')') {
	if (doprint || isldc)
	  (void) putc (ch, fo);
	if (!doprint && isldc)
	  (void) putc ('\n', fo);
	ch= getc (fi);
	return;
      }
      else
        (void) ungetc (ch, fi);
      break;
    }
  }
}

PUBLIC void
sm (fi, fo)
  FILE *fi, *fo;
{
  char buffer[BUFSIZ];
  int i, ib;

  while ((ch= getc (fi)) != EOF) {
    if (ch == '(') {
      ch= getc (fi);
      if (ch == '*')
        eatcomment (fi, fo);
      else
        if (doprint)
	  (void) putc ('(', fo);
    }
    if (isalpha (ch)) {
      ib= 0;
      do {
        buffer[ib++]= ch;
	ch= getc (fi);
      } while (isalnum (ch));
      (void) ungetc (ch, fi);
      buffer[ib]= 0;
      if (doprint)
	(void) fprintf (fo, "%s", buffer);

      if (doprint /*&& ib == 7*/) {
        for (i= 0; i < ib; i++)
	  if (isupper (buffer[i]))
	    buffer[i]= tolower (buffer[i]);
        if (strcmp (buffer, "endtype") == 0) {
	  (void) fprintf (fo, "\n");
	  doprint= 0;
	}
        if (strcmp (buffer, "endlib") == 0) {
	  (void) fprintf (fo, "\n");
	  doprint= 0;
	}
      }
      if ((!doprint) /*&& ib == 4*/) {
        for (i= 0; i < ib; i++)
	  if (isupper (buffer[i]))
	    buffer[i]= tolower (buffer[i]);
        if (strcmp (buffer, "type") == 0) {
	  (void) fprintf (fo, "type");
	  doprint= 1;
	}
        if (strcmp (buffer, "library") == 0) {
	  (void) fprintf (fo, "library");
	  doprint= 1;
	}
      }
    }
    else
      if (doprint)
	(void) putc (ch, fo);
  }
}

/*
main (argc, argv)
  int argc;
  char* argv[];
{
  FILE *argf;

  argf= fopen (argv[1], "r");
  if (argf == NULL) {
    perror ("cannot open input file");
    exit (1);
  }
  sm (argf, stdout);
  exit (0);
}
*/

