/*> do cc -g -I$EPSINC -L$EPSLIB -o %P %F -lcast
 *
 * copies an AST file
 * similar to /bin/cp, but using internal representation for the AST
 * treats every colour as OTHERS
 */

# include <stdio.h>
# include <ctype.h>
# include "cast.hh"

TIOCOLOURS iocolours [] = {		/* io driver */
	NULL, others, getstring, putstring, freestring, copystring
	};

FILE* fl= stdin;

main (argc, argv)
     int argc;
     char* argv[];
{
  if (argc > 2) {
    fprintf (stderr, "usage: copy1 [file]\n");
    exit (1);
  }
  if (argc == 2)
    fl= fopen (argv[1], "r");

  cast_init (iocolours);
  save_tree (stdout, restore (fl));
  exit (0);
}
