/*> do cc -g -I$EPSINC -L$EPSLIB -o %P %F -lcast
 *
 * draws a tree
 * in a (slightly) more friendly manner
 * by replacing tree codes into indentation of brothers/sons
 *
 * knows of colour types and handels them appropriately
 */

# include <stdio.h>
# include <ctype.h>
# include "cast.hh"

TIOCOLOURS iocolours [] = {		/* io driver */
  "int",      1, IO_int,	/* integer */
  "I2",       2, IO_I2,		/* integer pair */
  "str",      3, IO_str,	/* string */
  "lxv",      4, IO_lxv,	/* shared strings via hash table */
  "intlist",  5, IO_IL,		/* list of integers */
  "strlist",  6, IO_SL,		/* list of strings */
  "IT",       7, IO_IT,		/* table of integers */
  "ST",       8, IO_ST,		/* table of strings */
  "IAT",      9, IO_IAT,	/* table of integer arrays */
  "ignore",  10, IO_ign,	/* to be ignored */
  OTHERS			/* rest */
  };

int depth= -1;
FILE* fl= stdin;

main (argc, argv)
     int argc;
     char* argv[];
{
  while (argc > 1) {
    if (argv[1][0] == '-') {
      if (isdigit (argv[1][1]))
	depth= atoi (&argv[1][1]);
      else {
	fprintf (stderr, "usage: drast [-depth] [file]\n");
	exit (1);
      }
    }
    else
      fl= fopen (argv[1], "r");
    argc--;
    argv++;
  }
  cast_init (iocolours);
  drn_tree (restore (fl), depth);
  exit (0);
}
