%{

# define lexana_IMP

# include <string.h>
# include <ctype.h>
# include "swbus.h"

PRIVATE token   tttt;
PRIVATE token*  tt= &tttt;
PRIVATE int     lineno= 1;

%}

%%

[ \t]		;
"\n"+		{
		  lineno += strlen(yytext);
		  if (lexdebug > 0)
		    fprintf (stderr, "NEW LINE\n");
		  return '\n';
		}

[0-9]+		{
		  if (lexdebug > 0)
		    fprintf (stderr, "INT: %s\n", yytext);
		  return INT;
		}

.		{
		  if (lexdebug > 0)
		    fprintf (stderr, "CHAR: %c\n", yytext[0]);
		  return yytext[0];
		}

%%

yywrap ()
{
  return 1;
}

PUBLIC	token*
gtk	()
{

   tt->type = yylex();
   switch (tt->type) {
   case INT:
     tt->yylval.name= STHadd (yytext, SymbolTable, hidtbl, FALSE);
   }
   tt->yylval.line= newI2 (lineno, nfname);
   return tt;
}

PUBLIC	int
yyerror	(mess)
	char*	mess;
{
   fprintf(stderr,"efe: %d %s\n", lineno, mess);
   ++errorcount;
}
