#ifndef rag_HH
#define rag_HH

#define PUBLIC
#define PRIVATE static

/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: rag.desc,v $
 * Revision 2.6  1993/06/15  11:03:24  eps
 * is not a LINTLIBRARY
 *
 * Revision 2.5  1993/01/12  16:35:47  eps
 * portability issues
 *
 * Revision 2.4  1992/01/14  15:44:08  eps
 * distribution issues
 *
 * Revision 2.3  92/01/14  15:27:20  eps
 * adapt to case independent cast
 * 
 * Revision 2.2  91/04/10  10:02:57  eps
 * new function todoi
 * 
 * Revision 2.1  90/10/30  08:45:18  eps
 * plenty of small fixes:
 * visit, new classes, integrated tree traversal for evaluation, ...
 * 
 * Revision 1.4  90/05/10  18:15:12  eps
 * entries are documented ... at last!
 * 
 * Revision 1.3  90/03/16  16:53:14  eps
 * specify eval () and rag ()
 * ptclr and lfclr dropped
 * getG, putG fit new cast I/O model
 * 
 * Revision 1.2  90/01/29  14:57:29  eps
 * fixing license details
 * 
 * Revision 1.1  90/01/25  20:11:01  eps
 * Initial revision
 * 
 **********************************************
 $Id: rag.desc,v 2.6 1993/06/15 11:03:24 eps Exp $
 **********************************************/

#include "cast.hh"

/* Holds the number of errors found during rag execution.
 * It is incremented in report ()
 */
#ifndef rag_IMP
extern	int ragerrors;
#else
	int ragerrors= 0;
#endif

/* Holds the table of gramatical rules
 * it must be loaded by the application,
 * typically from the AST itself
 */
#ifndef rag_IMP
extern	IAT* grnl;
#else
	IAT* grnl= NULL;
#endif

/* Holds symbol table.
 * It must be loaded by the application, if used.
 * It influences the behaviour of report()
 */
#ifndef rag_IMP
extern	ST* SymbolTable;
#else
	ST* SymbolTable= NULL;
#endif

/*****  exported functions  *****/

/* This function is generated by RAG,
 * and shows up in [the generated file] rag.c
 * It evaluates a value for an attribute in a node.
 */

CLR_TYPE	eval ();

/* This function is generated by RAG,
 * and shows up in [the generated file] rag.c
 * It takes care of
 *   . initialization of the CAST,
 *     associating colours to nodes
 *                 and functions to evaluate those colours
 *   . runs as many preliminary phases as required
 *   . runs a phase to check conditions
 *   . runs one last general evaluating phase
 */

void	rag ();

/* This function is generated by RAG,
 * and shows up in [the generated file] rag.c
 * It takes care of following the thread of visits
 */

void	visit ();

/**********************************************************
	auxiliary colour functions
 **********************************************************/

/* Adds a colour to anode, annotating its value
 * checks for existence of -colour or +colour
 */

void	adclr ();

/* Finds and sets the value for a colour.
 * If the colour doesn't exist, then report an error.
 * If is already evaluated, return it.
 * If it is under evaluation, then report an error.
 * If it is not evaluated, then try to evaluate it.
 */

CLR_TYPE	fdclr ();

/* calculates h values */

void	heval ();

/* forces the evaluation of every pending colour in the subtree */
/* only phase i */

void	todoi ();

/* forces the evaluation of every pending colour in the subtree */

void	todo ();

/* Generates a report
 * by looking for a close node with an attr_line colour.
 * It increments variable ragerrors.
 * If global variable SymbolTable is NULL,
 * colour atrr_line is regarded as an integer,
 * and used as line number.
 * If SymbolTable is not NULL,
 * attr_line colour is regarded as a pair of integers (I2),
 * where the first one is the source line,
 * and the second is an index into SymbolTable to get the source file name.
 */

void	report ();

/*****  *****/
#endif
