#ifndef lnt_pass_HH
#define lnt_pass_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "lnt_pass.hh": LiNT PASSing (complaints suppression) functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: lnt_pass.desc,v $
 * Revision 1.4  1993/01/12  18:18:15  eps
 * portability issues.
 *
 * Revision 1.3  1993/01/12  16:36:28  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:01  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:48:15  eps
 * Initial revision
 * 
 ***********************************
 $Id: lnt_pass.desc,v 1.4 1993/01/12 18:18:15 eps Exp $
 ***********************************/


/* avoids "lint" complaints about pointer alinment */

#ifndef lint
#  define ALIN(type, ptr)	((type *)(ptr))
#else
#  define ALIN(type, ptr)	((type *)(int)&*(ptr))
#endif

/* useful to avoid "lint" complaints about null effect code */

#ifndef lint
#  define NOOP()	((void)0)
#else
   int __NOOP__= 0;

#  define NOOP()	((void)(++__NOOP__))
#endif

/* suppress "lint" complaints about constant conditions */

#ifndef lint
#  define TEST(cond)	(cond)
#else
   int __TEST__= 0;

#  define TEST(cond)	(__TEST__= (cond), __TEST__)
#endif

/* avoids "lint" complaints about constants in conditions */

#ifndef lint
#  define EVAL(exp)	(exp)
#else
   int __EVAL__= TRUE;

#  define EVAL(exp)	(__EVAL__? (exp): (exp))
#endif
#endif
