#ifndef prg_error_HH
#define prg_error_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "prg_error.hh": PRoGramming ERROR detection functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: prg_error.desc,v $
 * Revision 1.3  1993/01/12  16:36:33  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:06  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:48:42  eps
 * Initial revision
 * 
 ***********************************
 $Id: prg_error.desc,v 1.3 1993/01/12 16:36:33 eps Exp $
 ***********************************/


#if !defined(NCHECK) && defined(NDEBUG)
#  define NCHECK
#endif

/* if condition is true, writes a message and aborts */

void _cond_fail();

#ifndef NDEBUG
#  define abort_if(cond)				\
	  {						\
	    if (TEST(cond))				\
	      _cond_fail(__FILE__, __LINE__);		\
	  }
#else
#  define abort_if(cond)	{}
#endif

/* evaluates an expression if condition is true, else aborts */

void _cond_fail();

#ifndef NDEBUG
#  define eval_if(cond, exp)				\
	    ((TEST(cond)? NOOP()			\
		    : _cond_fail(__FILE__, __LINE__)	\
	     ), (exp))
#else
#  define eval_if(cond, exp)	(exp)
#endif

/* checks and returns a condition if it is true, else aborts */

void _check_fail();

#ifndef NCHECK
#  define check(cond)					\
	    ((TEST(cond)? NOOP()			\
		    : _check_fail(__FILE__, __LINE__)	\
	     ), TRUE)
#else
#  define check(cond)	(TRUE)
#endif
#endif
