#ifndef rec_basic_HH
#define rec_basic_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "rec_basic.hh": RECord BASIC functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: rec_basic.desc,v $
 * Revision 1.3  1993/01/12  16:36:49  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:20  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:50:06  eps
 * Initial revision
 * 
 ***********************************
 $Id: rec_basic.desc,v 1.3 1993/01/12 16:36:49 eps Exp $
 ***********************************/


typedef enum { NUL, SYM, STR, INT } eFLD;	/* available fields */

typedef struct
{ eFLD FT;
  union
  { int SYM;
    char *STR;
    int INT;
  } F;
} sFLD;		/* field structure */

typedef struct
{ int NR;
  int NF;
  int size;
  sFLD *fld;
} sREC;		/* record structure */

/* creates a record */

sREC *	crt_rec ();

/* expands a record */

sREC *	exp_rec ();

/* clears a record */

sREC *	clr_rec ();

/* deletes a record */

void	del_rec ();

/* duplicates a record */

sREC *	dup_rec ();

#endif
