/***********************************************************************
     "rec_draw.o": RECord DRAWing functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: rec_draw.c,v $
 * Revision 1.4  1993/01/12  18:19:03  eps
 * portability issues
 *
 * Revision 1.3  1993/01/12  16:37:22  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:58  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:51:48  eps
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: rec_draw.c,v 1.4 1993/01/12 18:19:03 eps Exp $";
#endif

/* LINTLIBRARY */

#define rec_draw_IMP

#include <stdio.h>
#include "bsc_dcls.hh"
#include "lnt_pass.hh"
#include "err_handl.hh"
#include "prg_error.hh"
#include "fld_basic.hh"
#include "rec_draw.hh"


/* draws a field on stderr */

PUBLIC void
_dr_fld (fld, first)
  sFLD *fld;
  int first;
{
  abort_if(fld == NULL)
  switch (fld->FT)
  { case SYM:
      if (!first)
	(void) fputc(' ', stderr);
      (void) fputs(sym_name(fld->F.SYM), stderr);
      break;
    case STR:
      (void) fputs(fld->F.STR, stderr);
      break;
    case INT:
      if (!first)
	(void) fputc(' ', stderr);
      (void) fprintf(stderr, "%d", fld->F.INT);
      break;
    default:
      abort_if(TRUE)
  }
}

PUBLIC void
dr_rec (rec)
  sREC *rec;
{
  int i;

  abort_if(rec == NULL ||
	   rec->fld == NULL)
  for (i= 1; i <= rec->NF; ++i)
    _dr_fld(rec->fld + i, i == 1);
  (void) fputc('\n', stderr);
}
