/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: astlink.c,v $
 * Revision 2.4  1993/09/20  14:16:40  eps
 * new functions: ln_rb ln_lb
 *
 * Revision 2.3  1993/01/12  16:34:01  eps
 * portability issues
 *
 * Revision 2.2  1992/01/14  15:42:42  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:32:08  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 * 
 * Revision 1.4  90/03/16  15:41:14  eps
 * minor beautifying
 * 
 * Revision 1.3  90/02/12  10:51:57  eps
 * miscellaneous cleanup
 * OK, BAD replaced by TRUE, FALSE in lnsons
 * 
 * Revision 1.2  90/01/29  14:51:27  eps
 * fixing license details
 * 
 * Revision 1.1  90/01/25  17:59:05  eps
 * Initial revision
 * 
 **********************************************/

#ifndef lint
static char rcsid[]= "$Id: astlink.c,v 2.4 1993/09/20 14:16:40 eps Exp $";
#endif

/***********************************************************************
        Tomas P. de Miguel Moro
	Jose A. Manas
        dpt. Ingenieria Telematica
        E.T.S.I. Telecomunicacion
        Ciudad Universitaria
        E-28040  MADRID

        tmiguel@dit.upm.es
        jmanas@dit.upm.es
 **********************************************************************/

/* LINTLIBRARY */

# define cast_IMP
# include "cast.hh"

# include <stdio.h>

PUBLIC int
lnsons (pfather, psons)
        TNODE*  pfather;
        TNODE*  psons;
{
        TNODE* auxp;

  if (pfather == NULL)
    return FALSE;
  if (pfather->sons == NULL)
     pfather->sons = psons;
  else{
        for (auxp = pfather->sons;
             auxp->brothers != NULL;
             auxp = auxp->brothers)
            ;
        auxp->brothers = psons;
      }
  for( ; psons != NULL; psons = psons->brothers)
       psons->father = pfather;
  return TRUE;

} /* end of lnsons */

PUBLIC TNODE*
lnnson (father, son, n)
        TNODE*  father;
        TNODE*  son;
        int     n;
{
  if (father == NULL || son == NULL) return NULL;
  son->father = father;
  if (father->sons == NULL) {
    son->brothers= NULL;
    father->sons = son;
    }
  else if (n <= 1) {
    son->brothers= father->sons;
    father->sons= son;
    }
  else {
        father = father->sons;
        while (--n > 1) {
             if (father->brothers == NULL)
               break;
             father = father->brothers;
        }
        son->brothers = father->brothers;
        father->brothers = son;
      }
  return father;

} /* end of lnnson */

PUBLIC void
lnrnode (brothers, new)
        TNODE*  brothers;
        TNODE*  new;
{
  if (brothers != NULL)
  {
    while (brothers->brothers != NULL) brothers = brothers->brothers;
    brothers->brothers = new;
    if (new != NULL)
    {
      new->brothers = NULL;
      new->father = brothers->father;
    }
  }

} /* end of lnrnode */

PUBLIC void
lnlnode (brothers, new)
        TNODE*  brothers;
        TNODE*  new;
{
  if (new != NULL)
  {
     new->brothers = brothers;
     new->father = brothers->father;
     if (brothers->father != NULL) brothers->father->sons = new;
  }

} /* end of lnlnode */

PUBLIC void
lnbrothers (nodep, brothers)
        TNODE*  nodep;
        TNODE*  brothers;
{
  if (nodep != NULL)
  {
    nodep->brothers = brothers;
    for( ; brothers != NULL; brothers = brothers->brothers)
         brothers->father = nodep->father;
  }

} /* end of lnbrothers */

/* adds a new brother to the right */

PUBLIC void
ln_rb (nodep, new)
  TNODE* nodep;
  TNODE* new;
{
  if (nodep == NULL)
    return;
  if (new == NULL)
    return;
  new->father= nodep->father;
  new->brothers= nodep->brothers;
  nodep->brothers= new;
}

/* adds a new brother to the left */

PUBLIC void
ln_lb (nodep, new)
  TNODE* nodep;
  TNODE* new;
{
  TNODE* auxp;

  if (nodep == NULL)
    return;
  if (new == NULL)
    return;
  new->father= nodep->father;
  new->brothers= nodep;
  auxp= nodep->father;
  if (auxp != NULL)
  { auxp= auxp->sons;
    if (auxp == nodep)
      nodep->father->sons= new;
    else
    { while (auxp->brothers != nodep)
	auxp= auxp->brothers;
      auxp-> brothers= new;
    }
  }
}

