/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: clrI2.c,v $
 * Revision 2.4  1993/01/12  16:34:47  eps
 * portability issues
 *
 * Revision 2.3  1992/11/17  11:48:05  eps
 * fix definition of *alloc for PC portability
 *
 * Revision 2.2  1992/01/14  15:43:19  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:33:32  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 * 
 **********************************************/

#ifndef lint
static char rcsid[]= "$Id: clrI2.c,v 2.4 1993/01/12 16:34:47 eps Exp $";
#endif

/***********************************************************************
	Jose A. Manas
        dpt. Ingenieria Telematica
        E.T.S.I. Telecomunicacion
        Ciudad Universitaria
        E-28040  MADRID

        jmanas@dit.upm.es

        functions for pairs of integers
 **********************************************************************/

/* LINTLIBRARY */

# define cast_IMP
# include "cast.hh"

# include <stdio.h>

PRIVATE int* pool= NULL;
PRIVATE int remainder= 0;

# define BUCKSIZE 256

PUBLIC int*
newI2 (i, j)
  int i, j;
{
  if (remainder == 0) {
    pool= (int*) calloc (2*BUCKSIZE, sizeof (int));
    remainder= BUCKSIZE;
  }
  *(pool++)= i;
  *(pool++)= j;
  remainder--;
  return pool-2;
}

PUBLIC CLR_TYPE
getI2 (fp)
    FILE* fp;
{
  int i, j;

  (void) fscanf (fp, "%d %d", &i, &j);
  return (CLR_TYPE) newI2 (i, j);
}

PUBLIC void
putI2 (fp, val)
    FILE* fp;
    CLR_TYPE val;
{
  int* where;

  where= (int*) val;
  (void) fprintf (fp, "%d %d", where[0], where[1]);
}
