/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: clrstr.c,v $
 * Revision 2.4  1993/01/12  16:34:28  eps
 * portability issues
 *
 * Revision 2.3  1992/11/17  11:47:36  eps
 * fix definition of *alloc for PC portability
 *
 * Revision 2.2  1992/01/14  15:43:08  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:32:35  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 * 
 * Revision 1.4  90/05/10  17:12:29  eps
 * change colour delimiters from !...! into {...}
 * 
 * Revision 1.3  90/03/16  15:54:49  eps
 * get and put do direct file access
 * escapes '\'
 * 
 * Revision 1.2  90/01/29  14:51:56  eps
 * fixing license details
 * 
 * Revision 1.1  90/01/25  18:00:17  eps
 * Initial revision
 * 
 **********************************************/

#ifndef lint
static char rcsid[]= "$Id: clrstr.c,v 2.4 1993/01/12 16:34:28 eps Exp $";
#endif

/***********************************************************************
        Tomas P. de Miguel Moro
	Jose A. Manas
        dpt. Ingenieria Telematica
        E.T.S.I. Telecomunicacion
        Ciudad Universitaria
        E-28040  MADRID

        tmiguel@dit.upm.es
        jmanas@dit.upm.es

        functions for string valued colours
 **********************************************************************/

/* LINTLIBRARY */

# define cast_IMP
# include "cast.hh"

# include <stdio.h>
# include <string.h>

/* There are colours that are directly strings,
 * and use getstr as it is.
 * There are other colours that are collections of strings,
 * and use getstr as a pre-loader.
 *
 * getstr interprets the following escape sequences
 *   \{  ->  {
 *   \}  ->  }
 *   \\  ->  \
 */

PRIVATE char* strbuf= NULL;
PRIVATE unsigned sizebuf= 0;

PUBLIC CLR_TYPE
getstring (fp)
    FILE* fp;
{
  int i, c;
  char* s;

  if (sizebuf == 0) {
    sizebuf= BUFSIZ;
    strbuf= (char*) malloc (sizebuf);
    if (strbuf == NULL)
      fatal ("getstring: run out of memory");
  }
  i= 0;
  for (c= getc (fp); c != '}'; c= getc (fp)) {
    if (sizebuf < i+4) {
      sizebuf+= BUFSIZ;
      strbuf= (char*) realloc (strbuf, sizebuf);
      if (strbuf == NULL)
	fatal ("getstr: run out of memory");
    }
    if (c == '\\') {
      c= getc (fp);
      if (c != '{' && c != '}' && c != '\\')
        strbuf[i++]= '\\';
    }
    strbuf[i++]= c;
  }
  (void) ungetc (c, fp);
  strbuf[i++]= 0;
  if (i <= 1)
    return ((CLR_TYPE) "");
  s= str_alloc (strbuf);
  return (CLR_TYPE) s;
}

PUBLIC void
putstring (fp, val)
    FILE* fp;
    CLR_TYPE val;
{
  int i;
  char* p= (char*) val;
  char c;

  for (i= 0; p[i] != 0; i++) {
    c= p[i];
    if (c == '{' || c == '}' || c == '\\')
      putc ('\\', fp);
    putc (c, fp);
  }
}

PUBLIC void
freestring (val)
    CLR_TYPE val;
{
  (void) free ((char*)val);
}

PUBLIC CLR_TYPE
copystring (val)
    CLR_TYPE val;
{
  return (CLR_TYPE) str_alloc ((char*) val);
}
