/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: emalloc.c,v $
 * Revision 2.5  1993/06/15  10:58:17  eps
 * is a LINTLIBRARY
 *
 * Revision 2.4  1993/01/12  16:35:09  eps
 * portability issues
 *
 * Revision 2.3  1992/11/17  11:48:21  eps
 * fix definition of *alloc for PC portability
 *
 * Revision 2.2  1992/01/14  15:43:34  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:36:35  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 * 
 * Revision 1.3  90/03/16  16:00:40  eps
 * the name is maintained for historical reasons!
 * emalloc disappears
 * new str_alloc
 * new fatal
 * 
 * Revision 1.2  90/01/29  14:52:17  eps
 * fixing license details
 * 
 * Revision 1.1  90/01/25  18:01:00  eps
 * Initial revision
 * 
 **********************************************/

/* LINTLIBRARY */

#ifndef lint
static char rcsid[]= "$Id: emalloc.c,v 2.5 1993/06/15 10:58:17 eps Exp $";
#endif

# include "cast.hh"
# include <stdio.h>
# include <string.h>

PUBLIC char*
str_alloc (s)
     char* s;
{
  char* p;
  unsigned n;
  
  n= 1 + (unsigned) strlen (s);
  p= (char*) malloc (n);
  if (p == NULL)
    fatal ("str_alloc: run out of memory");
  (void) strcpy (p, s);
  return p;
}

PUBLIC void
fatal (msg)
    char* msg;
{
  perror (msg);
  exit (1);
}
