/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *
 *  5 Dec 1990
 *
 *  Definition and Management of the meta-boolean expressions.
 *
 *  COMPILATION FLAGS:
 *  
 *  TYPE DEFINITIONS:
 *  
 *  FUNCTION DEFINITIONS:
 *     InitBool   : initialization of this module
 *     IsMetaBool : say if an operation is a meta-boolean one
 *     GetBool    : return the descriptor of the meta-boolean meta-sort
 *     GetEqual   : return the descriptor of the meta-boolean equality
 *     IsEqual    : say if an operation is the meta-boolean equality
 *     MakeEqual  : make the meta-equality of two expressions
 *     GetTrue    : return the descriptor of the meta-boolean operation TRUE
 *     IsTrue     : say if an operation is the meta-boolean TRUE
 *     MakeTrue   : make a meta TRUE expression
 *     GetFalse   : return the descriptor of the meta-boolean operation FALSE
 *     IsFalse    : say if an operation is the meta-boolean TRUE
 *     MakeFalse  : make a meta FALSE expression
 *
 *  LOG:
 *
 ******************************************************************/


#ifndef babool_H
#define babool_H

#include "baexpr.h"


/* InitBool
 * Initialization of this module.
 * This function must be called before a load.
 */
extern void InitBool();


/* IsMetaBool
 * Return TRUE if the operation d is a meta-bool operation.
 */
extern boolean IsMetaBool( /* d */ );
/* int d;  */


/* GetBool
 * Return the descriptor of the meta sort meta-bool
 */
extern int GetBool();


/* PutBool
 * Store the name of the meta sort bool.
 */
extern void PutBool( /* d */ );
/*      int d; */


/* GetEqual
 * Return the name of the semantic equality operation (=).
 */
extern int GetEqual();


/* IsEqual
 * Return true if ve is the meta equal operation.
 */
extern boolean IsEqual( /* ve */ );
/* ExprTyp  ve;  */


/* MakeEqual
 * Make the expression e1=e2
 */
extern ExprTyp MakeEqual( /* e1,e2 */ );
/* ExprTyp  e1;  
   ExprTyp  e2;  */


/* GetTrue
 * Return the name the meta operation TRUE.
 */
extern int GetTrue();


/* IsTrue
 * Return TRUE if ve is the meta TRUE operation.
 */
extern boolean IsTrue( /* ve */ );
/* ExprTyp  ve;  */


/* MakeTrue
 * Make an expression with the meta TRUE operation.
 */
extern ExprTyp MakeTrue();


/* GetFalse
 * Return the name of the meta operation FALSE.
 */
extern int GetFalse();


/* IsFalse
 * Return TRUE if ve is the meta FALSE operation.
 */
extern boolean IsFalse( /* ve */ );
/* ExprTyp  ve;  */


/* MakeFalse
 * Make the expression FALSE
 */
extern ExprTyp MakeFalse();


#endif

