/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *
 *  30 Nov 1990
 *
 *  COMPILATION FLAGS:
 *     SDEBUG : activate debugging checks
 *  
 *  TYPE DEFINITIONS:
 *     BehTyp : behaviour type 
 *  
 *  FUNCTION DEFINITIONS:
 *     StatMove               : statistic of memory usage.
 *     InitMove               : init this module when a new specification
 *                              is loaded.
 *     FreeMove               : clean the internal data of this module when
 *                              the current specification is deleted.
 *     GetCursor              : return the internal cursor.
 *     GetRoot                : return the process cell whose behaviour
 *                              is pointed by the internal cursor.
 *     MvCursorBeh            : move the cursor to the behaviour of the root.
 *                              ( first argument of GetRoot() ).
 *     MoveRoot               : move root and cursor to the specification level.
 *     MoveProc               : move the cursor to a process.
 *     MoveDProc              : move the cursor to a process.
 *     Move                   : move the cursor to the specified place.
 *     Current_Process        : return the descriptor of GetRoot().
 *     CopyMovePath           : return a copy of the path root-cursor.
 *     IsCursorAt_WBE_Context : say if the cursor is at a context suitable for
 *                              applying weak bisimulation transformations.
 *
 *  LOG:
 *
 ******************************************************************/


#ifndef inmove_H
#define inmove_H


#include "listack.h"
#include "babeh.h"


/* StatMove
 * Return the number of node lists used to keep the cursor position.
 */
extern int StatMove();


/* InitMove
 * Initialization of this module.
 * Set the cursor to the specification or process specified with d.
 */
extern void InitMove( /* d */ );
/* DescriptorTyp d; */


/* FreeMove
 * Clean the internal data of the module.
 * It must be used when the current specification is deleted.
 */
extern void FreeMove();


/* GetCursor
 * Return the position of the "cursor".
 */
extern BehTyp GetCursor();


/* GetRoot
 * Return a pointer to the specification or process where the 
 * internal cursor is.
 */
extern BehTyp GetRoot();


/* MvCursorBeh
 * Move the cursor to the first behaviour operator, i.e. jumps the
 * Process Definition and Specification operators.
 * Return the new cursor.
 */
extern BehTyp MvCursorBeh();


/* MoveRoot
 * Move the root and the cursor to the specification level, i.e. to the 
 * first position of the process table.
 */
extern BehTyp MoveRoot();


/* MoveProc
 * Move the cursor to the definition of the process called "name".
 */
extern BehTyp MoveProc( /* name */ );
/* char *name; */


/* MoveDProc
 * Move the cursor to the definition of the process "d".
 */
extern BehTyp MoveDProc( /* d */ );
/* DescriptorTyp  d; */


/* Move
 * Move the cursor to the specified place.
 */
extern BehTyp Move( /* offset,direction */ );
/* int offset;
   char direction; */


/* Current_Process
 * Return the descriptor of the process whose behaviour the cursor is
 * pointing to.
 */
extern DescriptorTyp Current_Process();


/* CopyMovePath
 * return a copy of the path root-cursor.
 */
extern BehTyp CopyMovePath();


/* IsCursorAt_WBE_Context
 * Say if the cursor is at a context where an i removal i;B ~ B
 * would leave it Weak Bisimulation Congruent.
 */
extern boolean IsCursorAt_WBE_Context();


#endif






