/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *  David Larrabeiti Lopez
 *      
 *  30 Jan 1990
 *
 *  Pretty printer for LOTOS behaviours.
 *  Printing follows ISO8807 and supports the IT operator as well.
 *
 *  COMPILATION FLAGS:
 *     ITDEBUG : IT printing debugging
 *
 *  TYPE DEFINITIONS:
 *  
 *  FUNCTION DEFINITIONS:
 *     InitPrint           : init LOTOS printer module
 *     PrintBeh            : print a behaviour
 *     PBeh                : print a behaviour in stdout
 *     PBehN               : print a behaviour in stdout until depth
 *     PrintParOper        : print a parallel operator
 *     PrintMoves          : print a behaviour and compute associations
 *                           line -> movement
 *     GetMove             : get move associated to a line
 *     CleanLinesMovements : clean line-move associations table
 *     StatPrint           : node usage of this module
 *  
 *  LOG:
 *
 ******************************************************************/


#ifndef baprint_H
#define baprint_H

/*
 *  These are the values allowed for the proc argument of PrintBeh.
 */
#define ALL_PROC   0
#define USED_PROC  1
#define NO_PROC    2


/* InitPrint
 * Initialize the LOTOS printer module
 */
extern void InitPrint();


/* PrintBeh
 * Print the behaviour pointed by ptr.
 * depth     is the printing depth.
 * proc      indicates which processes must be printed.
 * type      indicates if the type definitions must be printed or not.
 * indent    is string to indent the output.
 * pstr      is a function to print strings. The behaviour is transformed 
 *           in a set of lines which are printed with this function.
 * dots      indicates if when a behaviour reachs depth must print ".....".
 * line_nums indicates whether the line number of the original specification 
 *           must be printed or not.
 */
extern void PrintBeh ( /* ptr, depth, proc, type,
                          indent, pstr, dots, line_nums */ );
/* BehTyp  ptr        ;
   int     depth      ;
   int     proc       ;
   boolean type, dots ;
   char    *indent    ;
   void    (*pstr)()  ;
   boolean line_nums  ; */


/* PBeh
 * Print a behaviour in stdout
 */
extern void PBeh( /* b */ );
/* BehTyp b; */


/* PBehN
 * Print a behaviour down to level n in stdout
 */
extern void PBehN(/* b,n */);
/*	 BehTyp b;
	 int    n; */


/* PrintParOper
 * Print a parallel operator.
 * pstr is the function used to print strings.
 */
extern void PrintParOper( /* p, pstr */ );
/* BehTyp p ;
   void (*pstr)(); */


/* PrintMoves
 * Print the behaviour pointed by ptr and calculates the pairs 
 * <line,movement> from the root of ptr.
 * pstr  is a function to print strings. The behaviour is transformed 
 *       in a set of lines which are printed with this function.
 * depth is the printing depth. If depth is 0, it is calculated what 
 *       depth must be used so as not to exceed the height of the screen.
 * lines is TRUE if the line numbers must be printed.
 */
extern void PrintMoves( /* pstr,ptr,depth,lines */ );
/* BehTyp  ptr        ;
   void    (*pstr)()  ; 
   int     depth      ; 
   boolean lines      ;  */


/* GetMove
 * Return the movement associated to the line l according to 
 * the last call to PrintMoves
 *
 * A movement is a list of integers, like 3,-2,1,-5,22,-6.
 * 
 * The last value means:
 *    if it is positive: move up the specified value.
 *    if it is zero    : no movement.
 *    if it is negative: go to the specified process definition.
 *
 * The other values mean:
 *     - positive number are down movements.
 *     - negative number are selection of branchs.
 *
 * This example means:
 *             move GetP_name(6) 22d 5b 1d 2b 3d
 *
 * BE CAREFUL: The returned list is not a copy: Do not modify it.
 */
extern ListTyp GetMove( /* l */ );
/* int l; */


/* CleanLinesMovements
 * Clean the table with the associations <line,movement>.
 * This function must be called when the current behaviour is changed.
 */
extern void CleanLinesMovements();


/* StatPrint
 * Number of string blocks used by this module
 */
extern int StatPrint();


#endif
