/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  25-04-91
  
  Repeated Variations calculation for
  gd = ( a[1],...,a[m] in [b[1],..,b[n]] )
  
  This module generates a n-module counter of m digits.
  Each digit is an index in b[].
  
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  ************************************/


#include "excount.h"

/* The Counter :
   digits  = number of digits,
   module  = module,
   counter = counter.
   
   Each digit is a position in the array */

int counter[MAXDIGITS];

static int digits, module;

/*----------------------------------------------------------------*/

/* Initialize_Counter
 * Clears counter[] & Sets the number of digits for it, and its module.
 */
void Initialize_Counter( dignum, mod )
     int dignum, mod;
{
  LASSERT( dignum<=MAXDIGITS );
  
  module = mod;
  digits = dignum;
  for ( ; dignum>0 ; dignum-- )
    counter[ dignum-1 ]=0;
}

/*----------------------------------------------------------------*/

/* Increment
 * Increments counter ("module"-module).
 * if it succeeds :
 return true
 * If the counter overflows (over "digits" digits)
 *    there is no increment & return false.
 */
boolean Increment()
{
  int i;
  
  for ( i=0; (i<digits) && (counter[i]==(module-1)); i++ )
    counter[i]=0;
  
  if (i==digits)
    return FALSE;
  else {
    counter[i]++;
    return TRUE;
  }
}

/*----------------------------------------------------------------*/



