/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Francisco Monfort Martin
  
  3 May 1990
  
  Module to manage dynamic stacks
  of data of any type.
  
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  SDEBUG : activate debugging mode
  DEBUGMEM : activate control of deallocated memory
  
  TYPE DEFINITIONS:
  DataStackTyp : stacked data type 
  StackTyp : stack type
  
  FUNCTION DEFINITIONS:
  Create_Stack : creates an empty stack
  Free_Stack : frees a stack
  Save_Stack : saves an element on a stack
  Look_Stack : looks at the top element of a stack
  Get_Stack : gets ( picks up ) the top element from a stack
  Remove_Stack : removes and frees the top element from a stack
  Copy_Stack : copies a stack
  Print_Stack : prints a stack into a file
  IsEmpty_Stack : says if a stack is empty
  Count_Stack : number of elements in the stack
  GetBottom_Stack : get the element at the bottom of the stack
  Stack_to_list : Transform a stack into a list
  
  
  ************************************/


#ifndef LIstack_H
#define LIstack_H


#include "lilists.h"
#include "listdh.h"


typedef DataListTyp DataStackTyp;


/*
 * TYPE stack of DataStackTyp
 */
typedef ListTyp StackTyp;


/* Create_Stack
 * Create an empty stack.
 */
extern StackTyp Create_Stack();


/* Free_Stack
 * Frees the stack.
 * Deallocates the memory used by the elements with FreeF.
 */
extern void Free_Stack( /* stack, FreeF */ );
/* StackTyp stack;
   void (*FreeF) (); */


/* Save_Stack
 * Put the element info onto the stack
 */
extern StackTyp Save_Stack( /* info,stack */ );
/* DataStackTyp info;
   StackTyp stack; */


/* Look_Stack
 * Look at the first element of stack
 */
extern DataStackTyp Look_Stack( /* stack */ );
/* StackTyp stack; */


/* Get_Stack
 * Get the first element of the stack pointed by pstack. 
 * If the stack is empty, return NULL
 */
extern DataStackTyp Get_Stack( /* pstack */  );
/* StackTyp *pstack; */


/* Remove_Stack
 * Remove the last element of the stack pointed by pstack. 
 * Deallocate the memory used by this element with "func".
 */
extern StackTyp Remove_Stack( /* pstack,func */ );
/* StackTyp * pstack;
   void (*func)(); */


/* Copy_Stack
 * Return a copy of stack.
 * Elements are copied with func.
 */
extern StackTyp Copy_Stack( /* stack,func */ );
/* StackTyp stack;
   int (*func) (); */


/* Print_Stack
 * Prints a stack in the format: infoTop, infoNext, ..., infoLast
 * "f" is a function that returns a string of char with the information
 * of the node.
 * "pstr" is the function used to print the value returned by "f".
 * BE CAREFULL: the strings returned by "f" are not disposed.
 */
extern void Print_Stack( /* st, f, pstr */ );
/*     StackTyp st;
       char *  (*f)();
       void (*pstr)(); */



/* IsEmpty_Stack
 * Return TRUE if stack is empty and FALSE if it is not.
 */
extern boolean IsEmpty_Stack( /* stack */ );
/* StackTyp stack; */


/* Count_Stack
 * Number of elements in a stack s.
 */
extern int Count_Stack( /* s */ );
/* StackTyp s; */


/* GetBottom_Stack
 * Get the element at the bottom of the stack pointed by pstack. (FIFO fashion)
 * If the stack is empty, return NULL
 */
extern DataStackTyp GetBottom_Stack( /* pstack */);
/* StackTyp *pstack; */


/* Stack_to_list
 * Transform a stack into a list.
 */
extern ListTyp Stack_to_list(/* s */);
/*     StackTyp s; */


/* LookN_Stack
 * Look at the n-th element of stack
 * return NULL if it does not exist.
 */
extern DataStackTyp LookN_Stack(/* stack,n */);
/*     StackTyp stack;
       int      n; */

#endif

