/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon Gomez
  
  december 2, 1992
  
  This module defines variables:
  - to specify the runtime configuration of LOLA
  - to assign the printing functions used by all the functions
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  TYPE DEFINITIONS: (none)
  
  FUNCTION DEFINITIONS: (none)
  
  VARIABLE DEFINITIONS: 
  
  runtimeConfig : Runtime configuration.
  
  printTarget: How and where the main information is printed.
  flushTarget: flushes the target.
  printError : How and where the main information is printed.
  printMsgs  : How and where unbuffered messages are printed.
  printPos   : As printTarget, but it print the information in 
  a determined position of the output.
  printCursor: How and where the selection menues are printed.
  
  ************************************/


#include "listdh.h"
#include "listdout.h"

/* runtimeConfig
 * This variable stores the runtime configuration mode.
 * Values allowed are XWindowsMode and TextMode. 
 */
int runtimeConfig = (int)NULL;


/* printTarget
 * This variable is set with a function to print the main information.
 */
void (*printTarget)() = NULL;
     
     
     /* flushTarget
      *  Flushes the target.
      */
     void (*flushTarget)() = NULL;
     
     
     /* printError
      *  This variable is set with a function to print the error output.
      */
     void (*printError)() = NULL;
     
     
     /* printMsgs
      *  This variable is set with a function to print unbuffered messages.
      */
     void (*printMsgs)() = NULL;
     
     
     /* printPos
      *  This variable is set with a function to print messages.
      *  It is equal to printTarget, but it print the information in 
      *  a determined position of the output.
      */
     long (*printPos)() = NULL;
     
     
     /* printCursor
      *  This variable is set with a function to print the selection menues.
      */
     void (*printCursor)() = NULL;
     
     
