/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************

  Santiago Pavon Gomez
  David Larrabeiti Lopez

  December 1, 1992

  Main function of LOLA.

  ************************************/

/* KJT 29/10: define CygWin to get signals */

/* #define __CYGWIN__ */

#include <signal.h>

#include "listdh.h"
#include "listdout.h"
#include "inparser.h"
#include "batransl.h"
#include "bainit.h"
#include "limisc.h"
#include "ligetlin.h"
#include "incomm.h"
#include "apxlola.h"

#define SCREENWIDTH 80

/*----------------------------------------------------------------*/

#ifndef MSDOS
/* Signal_Handler
 * Handle specified signal and reset Signal_Handler for next same interrupt
 */
void Signal_Handler(sig, code, scp, addr)
     int sig, code;
     struct sigcontext *scp;
     char *addr;
{
  switch (sig) {
  case SIGCONT:
    /*
     * re-program keyboard
     */
    gl_init(SCREENWIDTH);
    break;
  case SIGTSTP:
    /*
     * un-program keyboard
     */
    gl_cleanup();
    break;
  case SIGCHLD:
  case SIGPIPE:
    break;
  }
  (void) signal(sig,Signal_Handler);
}
#endif
/*----------------------------------------------------------------*/

/*
 * FirstMsg
 */
static void FirstMsg()
{
  /* KJT 25/01/23: changed version string */
  (void)printf(
    "\n Lola Version 3.7.5 (modified K J Turner 2023-01-25)\n");
#ifdef TIME
  (void)printf("\n Timed Lola prototype.\n");
#endif
  (void)printf(" Departamento de Ingenieria Telematica, ETSIT\n");
  (void)printf(" Universidad Politecnica de Madrid\n\n");
#ifdef SDEBUG
  (void)printf("  WARNING: Lola has been compiled in debug mode. \n");
  (void)printf("    Compile without option SDEBUG to improve its performance.\n\n");
#endif
}

/*----------------------------------------------------------------*/

/* Initio
 * Initialization of the program.
 */
static void Initio()
{
#ifdef DEBUGMEM
  (void)malloc_debug(2);
#endif
  InitBA();
  InitTR();
}

/*----------------------------------------------------------------*/

/* Usage
 * syntax
 */
static void Usage()
{
#ifdef XLOLA
  /*
   * (void)printf("  usage: xlola [-l<lib>] <spec> [-nw]\n\n");
   */
  (void)printf("  xlola <spec> [-l<lib>]\n\n");
#else
  (void)printf("  lola <spec> [-l<lib>]\n\n");
#endif
}

/*----------------------------------------------------------------*/

/*
 * Main program
 */
/* KJT 22/01/23: added "int" type */
int main(argc,argv)
     int argc;
     char * argv[];
{

  char nspec[256];
  char nlibr[256];
  int c;
  char **v;
#ifdef XLOLA
  boolean xwin = TRUE;
#endif

#ifdef sun
  (void)signal(SIGCHLD,Signal_Handler); /* Handle child (here, system calls)
					   stop or exit */
  (void)signal(SIGPIPE,Signal_Handler); /* Handle write on a pipe with no
					   one to read it */
  (void)signal(SIGTSTP,Signal_Handler); /* Handle program stopped from term */
  (void)signal(SIGCONT,Signal_Handler); /* Handle program continuation */
#endif
  printTarget   = PrintString;
  flushTarget   = (void(*)())VoidF;
  printPos      = NULL;
  printMsgs     = PrintString;
  printError    = PrintString;
  printCursor   = PrintString;
  runtimeConfig = TextMode ;

  nspec[0] = '\0';
  nlibr[0] = '\0';

  c = argc;
  v = argv;
  while (c > 1) {
    if (v[1][0] == '-') {
      switch (v[1][1])
	{ case 'l':
	    if (v[1][2] != '\0')
	      (void) strcpy (nlibr, &(v[1][2]));
	    else {
	      if (c == 1) {
		(void)printf ("WARNING: missing library name\n");
		Usage();
		return -1;
	      }
	      else {
		c--;
		v++;
		(void) strcpy (nlibr, &(v[1][0]));
	      }
	    }
	    break;
#ifdef XLOLA
	  case 'n':
	    if (v[1][2] == 'w') {
	      xwin = FALSE;
	    }
	    break;
#endif
	  default: ;
	  }
    }
    else
      if (nspec[0]=='\0')
	(void) strcpy (nspec, v[1]);
    c--;
    v++;
  }

  if (nspec[0]=='\0') {
    Usage();
    return -1;
  }
  FirstMsg();
  Initio();
  if (ECload(nspec,nlibr)==-1)
    return -1;
  gl_init(SCREENWIDTH);
#ifdef XLOLA
  if (xwin) {
    printTarget = PrintStrInOutput;
    flushTarget = FlushOutput;
    printPos    = ReplaceStrInOutput;
    printMsgs   = PrintStrInOutputFlush;
    printError  = PrintStrInOutput;
    printCursor = PrintStrInCursor;
    runtimeConfig = XWindowsMode;

    XwindowsInt(argc,argv,nspec,nlibr);
  }
  else
    CommandInt();
#else
  CommandInt();
#endif
  return 0;
}

/*----------------------------------------------------------------*/












