# --------------------------------------
# generic makefile for any specification
# --------------------------------------

#CFLAGS= -DNDEBUG -I$(TOPOINC)
CFLAGS= -g -I$(TOPOINC)
LDFLAGS= -L$(TOPOLIB) -lkaos

TRGT=	$(SPEC)
DNAME=	d$(SPEC)
GLAD=	$(SPEC).gld
OBJS=	$(DNAME).o test.o

null:

exec:	$(TRGT)

$(TRGT):	$(OBJS)
	$(CC) $(CFLAGS) -o $@ $(OBJS) $(LDFLAGS)

$(DNAME).o:	$(DNAME).hh

$(DNAME).c $(DNAME).hh:	$(SPEC).lot $(GLAD) $(SPEC).ctx
	$(TOPOBIN)/topo $(SPEC) -verbose -d

$(SPEC).ctx:
	$(TOPOBIN)/toposet $(SPEC) -dname $(DNAME)
	$(TOPOBIN)/toposet $(SPEC) -glad $(GLAD)

clean:
	$(TOPOBIN)/topo $(SPEC) -clean
	rm -f $(OBJS)

tidy:
	$(TOPOBIN)/topo $(SPEC) -tidy
	rm -f $(TRGT) $(OBJS)
	rm -f $(SPEC).ctx
