/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: colours.c,v $
 * Revision 2.13  1993/03/24  18:02:51  lotos
 * new annotations for glad
 *
 * Revision 2.12  1993/01/18  18:04:54  lotos
 * distribution issues
 *
 * Revision 2.11  1992/11/04  16:31:45  lotos
 * add colour ldcinit
 *
 * Revision 2.10  1992/11/04  16:24:32  lotos
 * add common colours: cui, cso, cop
 *
 * Revision 2.9  1992/10/14  19:20:45  lotos
 * added annotations type & copy
 *
 * Revision 2.8  1992/10/14  18:37:37  lotos
 * add new annotation IF, and USE
 *
 * Revision 2.7  1992/09/02  14:47:27  lotos
 * keep annotations as independent (and sorted!) nodes in AST
 *
 * Revision 2.6  92/09/02  09:47:37  lotos
 * new colours for tool exchange of information:
 * 	sp, ty, pr, so, fs, op, fo, ga, va, ac
 * 
 * Revision 2.5  92/01/14  15:22:50  lotos
 * distribution issues
 * 
 * Revision 2.4  92/01/10  15:02:28  lotos
 * add c_impt c_parse c_implby c_initSby c_initZby 
 * remove c_iterate
 * 
 * Revision 2.3  91/08/28  15:54:16  lotos
 * added colours: internal, lexical, lexicalifpossible, using,
 *                constructor, nonconstructor, and Einfix
 * 
 * Revision 2.2  91/02/28  17:17:56  lotos
 * rule 'premiss ::= _value_expression' removed
 * consequences: colours c_bool, c_rectrue, c_true removed
 * unique identifier per class generated
 * 
 * 
 * Revision 2.1  90/10/30  14:13:22  lotos
 * compressed AST
 * use of hardwired colours
 * compressed value expressions
 * annotations to colours
 * 
 ***********************************/
/********************************************************
  shared colours: used for tools to exchange information
 *******************************************************/

/*****  hardwired colours  **********
 **
 **           tree   ATable
 **         +----------------+
 **  value0 | GL[#]  idclass |
 **  value1 | class  LL[#]   |
 **         +----------------+
 ************************************/

/*****  for TIOCOLOURS  *****/

"ATable",   c_at,       IO_AT,	/* SymbolTable				*/
"impt",     c_impt,     IO_int,	/* implicit TRUE flag			*/
"cdep",     c_cdep,     IO_IL,	/* transitive closure of type deps	*/
                             	/* { ATable[#] }			*/
"CM",       c_comm,     IO_str,	/* comments				*/
"flatt",    c_flatt,    IO_int,	/* bool: already flattened		*/
"funny",    c_funny,    IO_int,	/* internal syntax extension		*/
"GL",       c_grnl,     IO_IAT,	/* table of gram. rule lists		*/
"id",       c_iddec,    IO_int,	/* id declaration			*/
				/* ATable[#]				*/
"ir",       c_idref,    IO_int,	/* id reference				*/
				/* ATable[#]				*/
"I",        c_infix,    IO_int,	/* infix operation			*/
                             	/* -> ATable				*/
"ldep",     c_ldep,     IO_IL,	/* type deps				*/
                             	/* { ATable[#] }			*/
"L",        c_lexv,     IO_int,	/* lexical value			*/
				/* LL[#]				*/
                             	/* -> ATable				*/
"N",        c_line,     IO_I2,	/* {src line, src file}			*/
				/* {#, LL[#]}				*/
"LL",       c_ll,       IO_ST,	/* table of lexical values		*/
"luid",     c_luid,     IO_int,	/* last unique identifier		*/
"O",        c_ofsort,   IO_int,	/* of sort				*/
				/* LL[#]				*/
"P",        c_paren,    IO_int,	/* # of parenthesis around an exp	*/
"sidref",   c_sidref,   IO_int,	/* idref for expl. ofsort in exp	*/
"sort",     c_sort,     IO_int,	/* sort					*/
				/* ATable[#]				*/
"sargl",    c_sargl,    IO_IL,	/* sort	of argument list		*/
				/* { ATable[#] }			*/
"tid",      c_tid,      IO_int,	/* original type of decl.		*/
"ui",       c_ui,       IO_int,	/* unique identifier per class
                             	/* -> ATable				*/

"sp",       c_sp,       IO_int, /* last specification unique ident.     */
"ty",       c_ty,       IO_int, /* last type unique ident.              */
"pr",       c_pr,       IO_int, /* last process unique ident.           */
"so",       c_so,       IO_int, /* last sort unique ident.              */
"fs",       c_fs,       IO_int, /* last formal sort unique ident.       */
"op",       c_op,       IO_int, /* last operation unique ident.         */
"fo",       c_fo,       IO_int, /* last formal operation unique ident.  */
"ga",       c_ga,       IO_int, /* last gate unique ident.              */
"va",       c_va,       IO_int, /* last variable unique ident.          */
"ac",       c_ac,       IO_int, /* last action denotation unique ident. */
"cso",      c_cso,      IO_int, /* last sort uniq. id (compacted)       */
"cop",      c_cop,      IO_int, /* last operation uniq. id (compacted)  */
"cui",      c_cui,      IO_int, /* compacted uniq. ide. per class
                                /* -> ATable                            */
"ct",       c_ct,       IO_AT,  /* specification colour table           */
"spec",     c_spec,     IO_int, /* begin specification                  */
				/* ATable[#]				*/
"endspec",  c_endspec,  IO_int, /* end specification                    */
				/* ATable[#]				*/
"gA",       c_Gannot,   IO_IT,  /* glad annotation type table */
                                /* -> ATable                            */
"gN",       c_Gline,    IO_IT,  /* glad annotation line table */
                                /* -> ATable                            */

/***  annotations  ***/

"C",                    c_c,                  IO_str,
"call",                 c_call,               IO_str, /* -> ATable */
"constructor",          c_constructor,        IO_str, /* -> ATable */
"copy",                 c_copy,               IO_str, /* -> ATable */
"default",              c_default,            IO_str,
"delay",                c_delay,              IO_str,
"draw",                 c_draw,               IO_str, /* -> ATable */
"equal",                c_equal,              IO_str, /* -> ATable */
"eval",                 c_eval,               IO_str,
"extern",               c_extern,             IO_str, /* -> ATable */
"free",                 c_free,               IO_str, /* -> ATable */
"if",                   c_if,                 IO_str,
"internal",             c_internal,           IO_str, /* -> ATable */
"lbc",                  c_lbc,                IO_str,
"ldc",                  c_ldc,                IO_str, /* -> CTable */
"ldcinit",              c_ldcinit,            IO_str, /* -> CTable */
"lexical",              c_lexical,            IO_str, /* -> ATable */
"lexicalifpossible",    c_lexicalifpossible,  IO_str, /* -> ATable */
"name",                 c_name,               IO_str, /* -> ATable */
"nocopy",               c_nocopy,             IO_str, /* -> ATable */
"nodraw",               c_nodraw,             IO_str, /* -> ATable */
"nofree",               c_nofree,             IO_str, /* -> ATable */
"nonconstructor",       c_nonconstructor,     IO_str, /* -> ATable */
"noparse",              c_noparse,            IO_str, /* -> ATable */
"parse",                c_parse,              IO_str, /* -> ATable */
"partial",              c_partial,            IO_str, /* -> ATable */
"priority",             c_priority,           IO_str,
"type",                 c_type,               IO_str, /* -> ATable */
"use",                  c_use,                IO_str,
"using",                c_using,              IO_str, /* -> ATable */
"usingsort",            c_usingsort,          IO_str, /* -> ATable */
"wait",                 c_wait,               IO_str,

/* ascom compiler */
"implementedby",	c_implby,	IO_str,
"initialisedby",	c_initSby,	IO_str,
"initializedby",	c_initZby,	IO_str,

/*****  *****/
