# *************************************************************
#	labra: LOTOS Ada Behaviour Runtime A...
# *************************************************************
#***********************************
# (C) Copyright 1993; dit/upm
#  Distributed under the conditions stated in the
#  TOPO General Public License (see file LICENSE)
#***********************************
# $Id: labra.make,v 1.2 1993/10/08 16:52:25 lotos Exp $
#***********************************

#ADACPL= NONE
#ADARTS= sequence
#ADARTS= parallel

ADASRCS= u_rand.a arena.a mmg.a lbcsz.a kobj.a kspe.a lbc.a k_body.a
ADAIMPS= $(TOPOLIB)/kaos/$(ADARTS)

ADAMKF= $(TOPOLIB)/ada
ADALIB= $(MAKE) $(MFLAGS) -f $(ADACPL).mk

NOOP:

make:	$(ADACPL).init $(ADACPL).done

$(ADACPL).init:	$(ADACPL).mk
	$(ADALIB) init
	for lib in $(ADAIMPS); do		\
	  $(ADALIB) import LIB="$$lib";		\
	done
	touch $@

$(ADACPL).done:	$(ADASRCS)
	for src in $(ADASRCS); do		\
	  $(ADALIB) compile SRC="$$src";	\
	done
	touch $@

freeze:	$(ADACPL).freeze

$(ADACPL).freeze:	$(ADACPL).init $(ADACPL).done
	$(ADALIB) export
	touch $@

$(ADACPL).mk:
	cp $(ADAMKF)/$@ $@

clean:	$(ADACPL).mk
	$(ADALIB) clean
	rm -f $(ADACPL).freeze
	rm -f $(ADACPL).done
	rm -f $(ADACPL).init
