/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: lotos.hh,v $
 * Revision 2.8  1994/03/02  13:26:14  lotos
 * new function: get parameters from command line
 *
 * Revision 2.7  1993/06/28  19:12:30  lotos
 * max_var -> max_accepted
 *
 * Revision 2.6  1993/02/22  16:14:53  lotos
 * bug fixing --annotation USE
 *
 * Revision 2.5  1993/01/18  18:25:53  lotos
 * distribution issues
 *
 * Revision 2.4  1993/01/12  14:38:40  lotos
 * specification parameters
 *
 * Revision 2.3  1992/11/25  15:01:05  lotos
 * adapt type of EVAL functions to match the new data formats
 *
 * Revision 2.2  1992/11/17  17:27:06  lotos
 * var -> rav
 * success -> xto
 * distinguish kdatum / udatum
 *
 * Revision 2.1  1992/10/20  17:49:56  lotos
 * new KT evaluation algorithm
 * new Lbeta interface
 * cleaning, code optimization, space saving, bugs, ...
 *
 * Revision 1.8  1992/09/11  16:54:39  lotos
 * fix tree re-evaluation to take care of priorities
 *
 * Revision 1.7  1992/09/02  17:34:52  lotos
 * a new field to hold sort list code
 *
 * Revision 1.6  1992/03/05  17:37:14  lotos
 * just a few more bugs went to the hell
 *
 * Revision 1.5  92/03/04  14:53:00  lotos
 * 100 minor bugettes
 * 
 * Revision 1.4  92/02/29  13:26:20  lotos
 * miscellaneous bug fixing
 * 
 * Revision 1.3  92/02/12  18:47:52  lotos
 * ni idea, era una version que andaba por ahi ...
 * 
 * Revision 1.2  92/01/15  12:41:11  lotos
 * a bug in frames
 * change success and values
 * 
 * Revision 1.1  92/01/14  19:26:51  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char lotosrcsid[]= "$Id: lotos.hh,v 2.8 1994/03/02 13:26:14 lotos Exp $";
#endif

# include "kaos.hh"

#define PUBLIC
#define SHARED  extern
#define PRIVATE static

  
  /*------------------------------------------------
    ------------------------------------------------
    --                DATA TYPES                  --
    ------------------------------------------------
    ------------------------------------------------*/
  
extern struct Konfig {
        long    (*random)();
        int     trace;
        int     debug;
	int	negotiation;
        } konfig;

  
  /*********************    BOOLEANS  *******************/
  
typedef int boolean;

#ifndef TRUE
# define FALSE 0
# define TRUE  1
#endif

  /**********************    GATES     ******************/

typedef int        gate;
typedef gate    *  rel_g_list;  /* array of gates indexed by gates */
typedef boolean *  gate_list;   /* array of bool flags indexed by gates */

# define  EXITG 0
# define  NO_GTE -1

  /***********************  VARIABLES  *******************/

typedef int        variable;
typedef variable * var_list;  /* array of variables indexed by int */

# define  NO_VAR -1

typedef int tsort_id;

# define  NO_SORT -1

  /***********************    VALUES   *******************/


typedef udatum  value;
typedef value  * value_list;      /* array of value indexed by ?? */

/****************** PREDICATES AND CORROUTINES **************/

typedef int  predi;
typedef void      (*coroutine) ();
typedef predi     (*predicate) ();

#define  NO_PRD    -1
#define  PRD_NRDY  -1

/****************  EVAL FUNCTIONS ********************/

typedef boolean   (*eval_f) ();

#define NO_EVAL   -1
/* #define EVAL_END  ((value) -1)
#define EVAL_LATER NULL */

#define EVAL_END   FALSE
#define EVAL_OK    TRUE
#define EVAL_LATER -1

/*****************  EXPERIMENTS  ********************/
		       
typedef char     exp_class;

typedef struct st_experiment {
  exp_class  class;		        /*  ! ?  d  e          */  
  value      val;		        /*  ! value expression & default */
  variable   rav;		        /*  ? var # in frame   */ 
  int        eval;  		        /*  function for neg.  */

  struct st_experiment  * mmg;
} st_experiment;

typedef st_experiment* experiment;
typedef experiment   * exp_list;      /* experiment array indexed by index */

  /********************    FRAMES   *********************/

typedef int  entryp;
typedef int  bh_unit;

typedef struct st_frame {
  bh_unit	but;	       /*  behaviour unit type  */
  entryp	ent;	       /*  coroutine entry */
  value_list    rav;	       /*  process vars */ 
  struct st_offert * off;
  struct st_board  * ch;
  struct st_board  * dis;
  struct st_frame  * mmg;
} st_frame;
typedef st_frame* frame;

   /*******************    BOARDS   *************************/
	/** board types **/
# define b_hd	-10	/* hide		*/
# define b_en	-11	/* >>		*/
# define b_ds	-12	/* [>		*/
# define b_ps	-13	/* ||		*/
# define b_pi	-14	/* |||		*/
# define b_pe	-15	/* |[ ]|	*/
# define b_ch	-16	/* []		*/
# define b_st	-17	/* stop		*/
# define b_ii	-18	/* i		*/
# define b_ad	-19	/* g!?		*/
# define b_ex	-20	/* exit		*/
# define b_dl	-22	/* delay  	*/
# define b_wt	-23	/* wait		*/

	/** internal types **/
# define b_se	-30	/* SEXIT	*/
# define b_us	-31	/* unstable	*/

# define b_kt	-43	/* kt grandfather */
# define b_re	-45	/* Relab. board   */
# define b_fr	-46     /* Free  boards   */

typedef int      brd_type;
typedef long     time_l;

typedef struct  st_board  {
  brd_type btype;
  struct  st_board *   fth;
  struct  st_board *   bth;
  struct  st_board *   sons;
  struct  st_board *   r_leaf;
  struct  st_board *   l_leaf;

        /* ----- colapsar los siguientes en un record variante */
  predi           prd;	   /* --  wait  boards  */
  time_l          stime;   /* --  delay boards  */
  gate_list	  gte;     /* --  hide and par. explicit */ 
  rel_g_list	  gte_r;   /* --  relabeling of gates */
  var_list	  rav;     /* --  enabling  */
  int      num_fields;      /*  for enabling and relabel */

  frame   frm;
  struct  st_offert* offer;
  bh_unit  but; 

  struct  st_board *   mmg;
} st_board;
typedef st_board* board;

   /*******************  OFFERS *****************/

typedef  board *  board_list; /* array of boards index by int */
	    
typedef struct st_offert {
  gate                adg;	        /*  the gate   */
  int		      sort_id;
  exp_list            exp;	        /*  array of experiments*/
  predi               prd;	        /*  predicate, if any */
  int                 prior;            /* priority */
  boolean             f_eval;
  boolean             f_prd;
  boolean             f_prd_ok;
  board_list          act;
  int                 actn;
  board               enable;
  struct st_offert *  next;
  bh_unit             but; 
  struct st_offert *  mmg;
} st_offert;
typedef st_offert * offert;

   /************************** STACK ***************************/

typedef  experiment  stacks_exp;
typedef  gate        stacks_gte;

/**************************************************************/
/**************************************************************/
/***************   END OF DATA TYPES   ************************/
/**************************************************************/
/**************************************************************/

#define MAX_ST  1024

     /************* GLOBAL VARIABLES *************/

SHARED  int  specpar;
SHARED  value_list xto;
SHARED  int        suc_n;

SHARED  coroutine  ctbl [];
SHARED  predicate  ftbl [];

SHARED int max_val;
SHARED int max_accepted;
SHARED int max_gte;
SHARED int max_exp;

SHARED  stacks_exp        st_exp[];
SHARED  stacks_gte        st_gte[];
       
SHARED  int stp_exp;
SHARED  int stp_gte;
 
SHARED char     * TSprocesses[]; /*                               */
SHARED char    ** TSgates    []; /*                               */
SHARED tsort_id * TSsorts    []; /* sort index by but & var #     */
SHARED tsort_id * TSsbes     []; /* sort index by sort_id & exp # */
SHARED int        TSsizes    []; /* exp size index by sort_id     */
SHARED eval_f     TSevals    []; /* eval function index by int    */
SHARED char    ** TSvariables[];



     /************* PUBLIC FUNCTIONS   *************/
/*   mainf.c */

PUBLIC  void   cmd2lbc ();

PUBLIC  void   lbcinit ();
PUBLIC  void   lbcend  ();

PUBLIC  boolean  sch ();
PUBLIC  int      step ();

PUBLIC  int  min_delay ();


/*       make.c  ***/

PUBLIC  void   mkad   ();  
PUBLIC  void   mkch   ();  
PUBLIC  void   mkdis  ();  
PUBLIC  void   mkdl   ();  
PUBLIC  board  mken   ();  
PUBLIC  void   mkex   ();  
PUBLIC  void   mkso   ();
PUBLIC  void   mkuse  ();
PUBLIC  void   mkmo   ();
PUBLIC  void   mkdef  ();
PUBLIC  void   mkeval ();
PUBLIC  board  mkhd   ();  
PUBLIC  void   mki    ();  
PUBLIC  void   mkpe   ();  
PUBLIC  void   mkpi   ();  
PUBLIC  board  mkre   ();
PUBLIC  void   mkps   ();  
PUBLIC  void   mkst   ();  
PUBLIC  void   mkwt   ();  


/*********************** stack.c **********/

#define push_exp(e)  st_exp[stp_exp ++] = e
#define pop_exp()    st_exp[ -- stp_exp]
    
#define push_gte(g)  st_gte[stp_gte++]= g
#define pop_gte()    st_gte[--stp_gte]

/*************** tables ********************/



