/* translation of file(s)
	"commonrep.k"
	"cr_uniq.k"
 */
/* generated by:
 *	@(#)$Author: Kimwitu version: V3_8P5 (c) 1990 University of Twente $
 */
#define KC_CSGIO
#define KIMW_CSGIO /* for backwards compatibility */
#include <stdio.h>
#include <setjmp.h>
#include <ctype.h>
#include <string.h>
#if ((!defined(__STDC__)) && defined(sun))
   extern char *sprintf();
#endif
#if defined(__STDC__)
# include <stdlib.h>
#else
  extern double atof (/* char* */);
#endif
#include "k.h"
#include "csgiok.h"
/* macro's that do the string concatenation */
#define KC_MIdStr(s) s
#ifdef __STDC__
# define KC_MStrConc(s1,s2) s1 ## s2
# define KC_MStrConc3(s1,s2,s3) s1 ## s2 ## s3
#else
# define KC_MStrConc(s1,s2) KC_MIdStr(s1)s2
# define KC_MStrConc3(s1,s2,s3) KC_MIdStr(KC_MIdStr(s1)s2)s3
#endif

#ifndef MALLOC
#  define MALLOC emalloc
#endif
#ifndef REALLOC

#  define REALLOC erealloc

#endif
#ifndef CALLOC
#  define CALLOC ecalloc
#endif
#ifndef FREE
#  define FREE efree
#endif
#ifndef efree

#  define efree(kc_p) free((kc_malloc_t)(kc_p))

#endif

/* kc_qsort_firstarg_t should be void* kc_voidptr_t, but sun's include files are dumb */
#ifndef KC_QSORT_FIRSTARG_T
typedef char *kc_qsort_firstarg_t;
#else
typedef KC_QSORT_FIRSTARG_T kc_qsort_firstarg_t;
#endif

/* macro that does the string concatenation */
#define kc_str_conc2(a,b) (char*)strcat(strcpy((char *) MALLOC((kc_size_t)(strlen(a) + strlen(b) +1)), a), b)

/* macro that does the field/son selection */
#ifndef KC_FIELD
#  define KC_FIELD(var,oper,subphy,subphynr,sonnr) (var->u.oper.KC_MStrConc3(subphy,_,subphynr))
#endif

/* macro that reads the integers */
#define kc_do_get_int(c,c_init,i,f)\
  c = c_init;\
  i = 0;\
  while (isdigit(c)){\
    i = (i*10) + (c-'0');\
    c = getc(f);\
  }

static char *kc_malloc_area = (char*)0;
static kc_size_t kc_sizeof_malloc_area = 0;
#define KC_GETMALLOCAREA(kc_s) (((kc_s) > kc_sizeof_malloc_area) ? kc_grow_malloc_area(kc_s) : kc_malloc_area)
static char *kc_grow_malloc_area
#ifdef KC_USE_PROTOTYPES
(kc_size_t kc_s)
#else
(kc_s) kc_size_t kc_s;
#endif
{
	if (kc_malloc_area != (char*)0) FREE((kc_voidptr_t)kc_malloc_area);
	kc_malloc_area = (char*)MALLOC(kc_s);
	kc_sizeof_malloc_area = kc_s;
	return kc_malloc_area;
}

typedef enum {
	KC_CSGIOSTATUS_NO_ERR = 0,
	KC_CSGIOSTATUS_SCAN_ERR_1, KC_CSGIOSTATUS_SCAN_ERR_2, KC_CSGIOSTATUS_SCAN_ERR_3, KC_CSGIOSTATUS_SCAN_ERR_4, KC_CSGIOSTATUS_SCAN_ERR_5,
	KC_CSGIOSTATUS_GRAM_INCONSISTENT, KC_CSGIOSTATUS_ROK, KC_CSGIOSTATUS_ILLEGAL_OPTION, KC_CSGIOSTATUS_TOO_MANY_OPERATORS,
	KC_CSGIOSTATUS_WOK, KC_CSGIOSTATUS_TXT_FILE_INPUT, KC_CSGIOSTATUS_SYNTAX_ERROR, KC_CSGIOSTATUS_ILLEGAL_CONTEXT, KC_CSGIOSTATUS_PREMATURE_EOF,
	KC_CSGIOSTATUS_UNEXP_FATHER_MARK
} KC_IO_STATUS;

typedef struct {
	KC_IO_STATUS io_status;
	char *err_reason;
	int line;
} KC_IO_RETURN;

/* global variables */
static jmp_buf kc_priv_env;
static char *kc_csgio_err_reason = "";
static int kc_no_external_ops;
#define KC_NOT_FOUND_OPERATOR -1
static int kc_file_offset_base;
static int kc_file_offset;

/* Magic File descriptor(s) */
/* Magic descriptors of length up to KC_MAGIC_LENGTH-1 are supported. */
/* When changing KC_MAGIC_LENGTH. change constant in MAGIC_READ_FORMAT to be one less than KC_MAGIC_LENGTH. */
/* Every file is assumed to start with the magic file descriptor for asc_csg_v3 */

static char kc_ascii_prefix_magic_v3[] = "A#S#C#S#S#L#V#3";
#define KC_MAGIC_LENGTH 25
#define KC_MAGIC_READ_FORMAT "%24s\n" 

/* Operators with names of length upto OP_LENGTH-1 are supported. */
/* When changing OP_LENGHTH, change constant in OP_READ_FOMAT to be one less */
#define KC_OP_LENGTH 256
#define KC_OP_READ_FORMAT "%255s\n" 

/************************/
/* Error-string Routine */
/************************/

static char *kc_CSGIOerrorstring
#ifdef KC_USE_PROTOTYPES
(KC_IO_STATUS kc_io_status)
#else
(kc_io_status) KC_IO_STATUS kc_io_status;
#endif
{
	switch( (int)kc_io_status ) {
	case (int)KC_CSGIOSTATUS_NO_ERR: return( "No errors" );
	case (int)KC_CSGIOSTATUS_SCAN_ERR_1: return( "Scan error(1)" );
	case (int)KC_CSGIOSTATUS_SCAN_ERR_2: return( "Scan error(2)" );
	case (int)KC_CSGIOSTATUS_SCAN_ERR_3: return( "Scan error(3)" );
	case (int)KC_CSGIOSTATUS_SCAN_ERR_4: return( "Scan error(4)" );
	case (int)KC_CSGIOSTATUS_SCAN_ERR_5: return( "Scan error(5)" );
	case (int)KC_CSGIOSTATUS_GRAM_INCONSISTENT: return( "Grammar is inconsistent" );
	case (int)KC_CSGIOSTATUS_ROK: return( "Read OK structure file" );
	case (int)KC_CSGIOSTATUS_ILLEGAL_OPTION: return( "Illegal option in write command" );
	case (int)KC_CSGIOSTATUS_TOO_MANY_OPERATORS: return( "Too many operators for binary format" );
	case (int)KC_CSGIOSTATUS_WOK: return( "Written OK" );
	case (int)KC_CSGIOSTATUS_TXT_FILE_INPUT: return( "Read OK Text-file" );
	case (int)KC_CSGIOSTATUS_SYNTAX_ERROR: return( "Syntax error" );
	case (int)KC_CSGIOSTATUS_ILLEGAL_CONTEXT: return( "Illegal context for operator" );
	case (int)KC_CSGIOSTATUS_PREMATURE_EOF: return( "Premature eof in file" );
	case (int)KC_CSGIOSTATUS_UNEXP_FATHER_MARK: return( "Unexpected FATHER MARKER" );
	default: return( "Unknown error code" );
	}
}

static kc_hashtable_t kc_CSGIOhashtable;

/* Maps */
typedef struct {
	int left;
	int right;
} kc_OpToOpMap_tuple_t;

static kc_OpToOpMap_tuple_t kc_OpToOpMap[ KC_NO_OF_OPERATORS ];
#define KC_NOT_USED -1

static int kc_op_search
#ifdef KC_USE_PROTOTYPES
(char *kc_s)
#else
(kc_s) char *kc_s;
#endif
{
	int kc_i;
	for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
		if ( strcmp( kc_s, kc_OperatorInfo[kc_i].name ) == 0 ) return( kc_i );
	}
	return( KC_NOT_FOUND_OPERATOR );
}

static void kc_initializeOpToOpMap
#ifdef KC_USE_PROTOTYPES
(int kc_v)
#else
(kc_v) int kc_v;
#endif
{
	int kc_i;
	for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
		kc_OpToOpMap[kc_i].left = kc_i;
		kc_OpToOpMap[kc_i].right = kc_v;
}	}

static int kc_OpToOpMap_tuple_t_compare_right
#ifdef KC_USE_PROTOTYPES
(kc_constvoidptr_t kc_el1, kc_constvoidptr_t kc_el2)
#else
(kc_el1, kc_el2) kc_constvoidptr_t kc_el1, kc_el2;
#endif
{
	kc_OpToOpMap_tuple_t *kc_elt1 = (kc_OpToOpMap_tuple_t *)kc_el1;
	kc_OpToOpMap_tuple_t *kc_elt2 = (kc_OpToOpMap_tuple_t *)kc_el2;
	/* sort in DECREASING order */
	return (kc_elt2->right - kc_elt1->right);
}

static int kc_OpToOpMap_tuple_t_compare_left
#ifdef KC_USE_PROTOTYPES
(kc_constvoidptr_t kc_el1, kc_constvoidptr_t kc_el2)
#else
(kc_el1, kc_el2) kc_constvoidptr_t kc_el1, kc_el2;
#endif
{
	kc_OpToOpMap_tuple_t *kc_elt1 = (kc_OpToOpMap_tuple_t *)kc_el1;
	kc_OpToOpMap_tuple_t *kc_elt2 = (kc_OpToOpMap_tuple_t *)kc_el2;
	/* sort in INCREASING order */
	return (kc_elt1->left - kc_elt2->left);
}

static void kc_sort_rightOpToOpMap()
{
	qsort((kc_qsort_firstarg_t)kc_OpToOpMap, KC_NO_OF_OPERATORS, sizeof(kc_OpToOpMap_tuple_t), kc_OpToOpMap_tuple_t_compare_right);
}

static void kc_sort_leftOpToOpMap()
{
	qsort((kc_qsort_firstarg_t)kc_OpToOpMap, KC_NO_OF_OPERATORS, sizeof(kc_OpToOpMap_tuple_t), kc_OpToOpMap_tuple_t_compare_left);
}

static void kc_renumberOpToOpMap()
{
	int kc_i, kc_j = 0;
	for ( kc_i=0; kc_i < KC_NO_OF_OPERATORS; kc_i++ ) {
		if (kc_OpToOpMap[kc_i].right > 0) {
			kc_OpToOpMap[kc_i].right = kc_j++;
		} else {
			kc_OpToOpMap[kc_i].right = KC_NOT_USED;
}	}	}



#define KC_MAKE_NEW_MAPPING(ext_op,int_op) kc_OpToOpMap[ext_op].right = int_op;
#define KC_MAKE_NEW_SCAN_MAPPING(ext_op) kc_OpToOpMap[ext_op].right++;
#define KC_MAP(op) (kc_OpToOpMap[op].right)
#define KC_IS_MAPPED(op) (kc_OpToOpMap[op].right != KC_NOT_USED)
#define KC_OP_NAME(op) (kc_OperatorInfo[op].name)
#define KC_NO_SONS(prod) (kc_OperatorInfo[prod].no_sons)
#define KC_ATOMICITY(prod) (kc_OperatorInfo[prod].atomicity)

/*ARGSUSED*/
static void kc_error_operator_not_in_phylum
#ifdef KC_USE_PROTOTYPES
(int kc_op, char *kc_str1, char *kc_str2, int kc_phy, char *kc_fn, int kc_l)
#else
(kc_op, kc_str1, kc_str2, kc_phy, kc_fn, kc_l) int kc_op; char *kc_str1; char *kc_str2; int kc_phy; char *kc_fn; int kc_l;
#endif
{
	char *kc_error_message1 = "operator not defined in phylum ";
	char *kc_error_message2 = ": ";
	if ((kc_op <= (int)kc_one_before_first_operator) || (kc_op >= (int)kc_last_operator)) {
		char kc_value[30];
		(void)sprintf(kc_value, "%d",kc_op);
		kc_csgio_err_reason = kc_str_conc2("unknown operator number: ",kc_value);
	} else {
		kc_csgio_err_reason = (char*)strcat(strcat(strcat(strcpy((char*)MALLOC((kc_size_t)(strlen(kc_error_message1)+strlen(kc_PhylumInfo[kc_phy].name)+strlen(kc_error_message2)+strlen(kc_OperatorInfo[kc_op].name)+1)), kc_error_message1), kc_PhylumInfo[kc_phy].name), kc_error_message2), kc_OperatorInfo[kc_op].name);
	}
	longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_ILLEGAL_CONTEXT ); /*NOTREACHED*/
}

/* NEED to be extended */
static KC_IO_RETURN kc_io_return
#ifdef KC_USE_PROTOTYPES
(KC_IO_STATUS kc_status, char *kc_err_reason /*, int kc_line*/)
#else
(kc_status, kc_err_reason /*, kc_line*/ ) KC_IO_STATUS kc_status; char *kc_err_reason; /*int kc_line;*/
#endif
{
	KC_IO_RETURN kc_r;
	kc_r.io_status = kc_status;
	kc_r.err_reason = kc_err_reason;
	/*kc_r.line = kc_line;*/
	return(kc_r);
}

static char *kc_readKC_IO_RETURN2char
#ifdef KC_USE_PROTOTYPES
(KC_IO_RETURN kc_p)
#else
(kc_p) KC_IO_RETURN kc_p;
#endif
{
	char *kc_err_ret = (char *)0;
	char *kc_err_sep = ": ";
	if (kc_p.io_status != KC_CSGIOSTATUS_ROK) {
		char *kc_io_err = kc_CSGIOerrorstring(kc_p.io_status);
		kc_err_ret = (char *)MALLOC((kc_size_t)strlen(kc_io_err)+strlen(kc_err_sep)+strlen(kc_p.err_reason)+1);
		(void)strcpy(kc_err_ret, kc_io_err);
		(void)strcat(kc_err_ret, kc_err_sep);
		(void)strcat(kc_err_ret, kc_p.err_reason);
	}
	return kc_err_ret;
}

static char *kc_writeKC_IO_RETURN2char
#ifdef KC_USE_PROTOTYPES
(KC_IO_RETURN kc_p)
#else
(kc_p) KC_IO_RETURN kc_p;
#endif
{
	char *kc_err_ret = (char *)0;
	char *kc_err_sep = ": ";
	if (kc_p.io_status != KC_CSGIOSTATUS_WOK) {
		char *kc_io_err = kc_CSGIOerrorstring(kc_p.io_status);
		kc_err_ret = (char *)MALLOC((kc_size_t)strlen(kc_io_err)+strlen(kc_err_sep)+strlen(kc_p.err_reason)+1);
		(void)strcpy(kc_err_ret, kc_io_err);
		(void)strcat(kc_err_ret, kc_err_sep);
		(void)strcat(kc_err_ret, kc_p.err_reason);
	}
	return kc_err_ret;
}

/* Base 64 numbers are written with the digits:
   : ; < = > ? @ A-Z [ \ ] ^ _ ` a-y
   Base 10 numbers are written with the ordinary digits 0-9.
   Other characters are used in special circumstances:
	! Indicates switch between reading attribute and unattributed nodes.
	# Indicates that the father is the next PROD_INSTANCE in the file.
	+ Indicates that the following bytes are not a base 64 number
	* Indicates a line containing a (decimal) count of attributes.
*/
#define KC_B64_ZERO_CHAR	':'
#define KC_IS_B64(c)	((unsigned)((c)-KC_B64_ZERO_CHAR)<64)
#define KC_ASCII_ZERO	'0'
#define KC_NON_B64_CHAR	'+'
#define KC_FATHER_MARKER	'#'
#define KC_SIX_BIT_MASK  0x3f

#ifndef KC_NO_CSGIO_READ

/* read and compute the base 64 integer in stream */
static unsigned get_rest_of_b64
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, register int kc_read_char, char kc_trailing_char)
#else
(kc_stream, kc_read_char, kc_trailing_char) FILE *kc_stream; register int kc_read_char; char kc_trailing_char;
#endif
{
	unsigned kc_next_char;
	register int kc_offset;
	register int kc_i = 0;

	if (!KC_IS_B64(kc_read_char))
		longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
	kc_offset = (int) kc_read_char - KC_B64_ZERO_CHAR;

	kc_next_char = (unsigned) getc(kc_stream);
	while(KC_IS_B64(kc_next_char)) {
		kc_offset += (int) ((kc_next_char - KC_B64_ZERO_CHAR) << (6 * (++kc_i)));
		kc_next_char = (unsigned) getc(kc_stream);
		}

	if (kc_next_char == '-') {
		kc_offset *= -1;
		kc_next_char = (unsigned) getc(kc_stream);
	}

	if (kc_next_char != kc_trailing_char)
		longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
	return((unsigned) kc_offset);
}

/* read shared functions */
typedef enum { KC_NOT_READ_YET, KC_READ_EARLIER } KC_READ_STATUS;
/* variable used by the sharing routines during a read */
/* stores pointers to value_ptr fields */
static YYSTYPE *kc_offset_to_address_map;
static char* *kc_offset_to_address_map_base;

static void kc_init_read_sharing
#ifdef KC_USE_PROTOTYPES
(int kc_node_count, int kc_node_count_base)
#else
(kc_node_count, kc_node_count_base) int kc_node_count; int kc_node_count_base;
#endif
{
	kc_offset_to_address_map = (YYSTYPE *)CALLOC((kc_size_t)kc_node_count, (kc_size_t)sizeof(YYSTYPE));
	kc_file_offset = 0;
	kc_offset_to_address_map_base = (char* *)CALLOC((kc_size_t)kc_node_count_base, (kc_size_t)sizeof(char*));
	kc_file_offset_base = 0;
}

static KC_READ_STATUS kc_read_sharing_find
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, YYSTYPE *kc_valptr)
#else
(kc_stream, kc_valptr) FILE *kc_stream; YYSTYPE *kc_valptr;
#endif
{	char kc_first_char;
	unsigned kc_offset;

	kc_first_char = getc(kc_stream);
	if (KC_IS_B64(kc_first_char)) {
		kc_offset = get_rest_of_b64(kc_stream, kc_first_char, '\n');
		*kc_valptr = kc_offset_to_address_map[kc_file_offset - (int) kc_offset];
		return(KC_READ_EARLIER);
	} else {
		(void)ungetc(kc_first_char, kc_stream);
		return(KC_NOT_READ_YET);
}	}

static KC_READ_STATUS kc_read_sharing_find_base
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, char **kc_valptr)
#else
(kc_stream, kc_valptr) FILE *kc_stream; char **kc_valptr;
#endif
{	char kc_first_char;
	unsigned kc_offset;

	kc_first_char = getc(kc_stream);
	if (KC_IS_B64(kc_first_char)) {
		kc_offset = get_rest_of_b64(kc_stream, kc_first_char, '\n');
		*kc_valptr = kc_offset_to_address_map_base[kc_file_offset_base - (int) kc_offset];
		return(KC_READ_EARLIER);
	} else {
		return(KC_NOT_READ_YET);
}	}

#define kc_read_sharing_store(kc_ptr, kc_loc) \
	kc_offset_to_address_map[kc_loc] = kc_ptr
#define kc_read_sharing_store_base(kc_ptr) \
	kc_offset_to_address_map_base[kc_file_offset_base++] = kc_ptr


static void kc_end_read_sharing()
{
	FREE((kc_voidptr_t)kc_offset_to_address_map);
	FREE((kc_voidptr_t)kc_offset_to_address_map_base);
}

static void kc_CSGIOdo_read_atom_denotation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, char *kc_sbase, int kc_len)
#else
(kc_stream, kc_sbase, kc_len) FILE *kc_stream; char *kc_sbase; int kc_len;
#endif
{
	char * kc_sptr = kc_sbase;
	register int kc_ch, kc_ch1;
	register char kc_test;
	register int kc_i;

	for (kc_i=0; kc_i<kc_len; kc_i++, kc_sptr++) {
		kc_ch = getc(kc_stream);
		if (kc_ch == '\n') {
			(void)ungetc(kc_ch, kc_stream);
			break;
		}
		*kc_sptr = (char) kc_ch;
		if ( kc_ch == '\\' ) {
			if ( ( kc_test = getc( kc_stream ) ) != '\\' ) { /* Must be escaped hex */
				if (isdigit(kc_test)) kc_ch1 = kc_test - '0'; else kc_ch1 =kc_test + 10 - 'a';
				kc_ch1 = 16 * kc_ch1;
				kc_test = getc(kc_stream);
				if (isdigit(kc_test)) kc_test= kc_test - '0'; else kc_test=kc_test + 10 - 'a';
				kc_ch1 = kc_ch1 + kc_test;
				*kc_sptr = (char)kc_ch1; /* cast is for explicit narrowing from int to char */
			}
		}
	}

	kc_ch = getc(kc_stream);
	if ( kc_ch == EOF ) longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_PREMATURE_EOF );
	else if (kc_ch != '\n') longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1 );

	*kc_sptr = '\000';
}

static float kc_ator
#ifdef KC_USE_PROTOTYPES
(char *kc_s)
#else
(kc_s) char *kc_s;
#endif
{
	return atof( kc_s );
}

static kc_voidptr_t kc_CSGIOread2dft
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, kc_enum_phyla kc_phylum)
#else
(kc_stream, kc_phylum) FILE *kc_stream; kc_enum_phyla kc_phylum;
#endif
{
	char *kc_sbase;
	int kc_len;
	int kc_delim;
	YYSTYPE kc_answer;
	int kc_location;
	boolean kc_not_read_yet = False;

/* get operator */
	int kc_op;
	int kc_ext_op;
	int kc_testing;
	int kc_version_no;
	/* scan for optional unparsing version number */
	if (kc_read_sharing_find( kc_stream, &kc_answer ) == KC_READ_EARLIER ) {
		return kc_do_copy_phylum( (kc_voidptr_t)kc_answer.yt_casestring, False, kc_phylum );
	}
	kc_do_get_int(kc_testing,getc(kc_stream),kc_ext_op,kc_stream);
	if ( kc_testing == EOF )
		longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1 );
	if ( kc_testing == '(' ) {
		if ( fscanf( kc_stream, "%d)%c", &kc_version_no, &kc_testing ) != 2 )
			longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1 );
	}
	if ( kc_testing == KC_FATHER_MARKER )
		longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_UNEXP_FATHER_MARK );
	if ( kc_testing != '\n' )
		longjmp( kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1 );
	kc_op = KC_MAP( kc_ext_op );
/* end get operator */

	assertOperatorInPhylumFn(kc_op, "kc_op", "", kc_phylum, kc_error_operator_not_in_phylum);
	kc_location = kc_file_offset++;
	switch( (int)kc_op ) {
	case (int)sel__Int:
		kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
		if ( kc_delim == EOF )
			longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
		kc_sbase = (char *) KC_GETMALLOCAREA((kc_size_t)(kc_len + 1)); /* +1 for '\0' */
		kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
		kc_answer.yt_int = atoi( kc_sbase );
		break;
	case (int)sel__Real:
		kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
		if ( kc_delim == EOF )
			longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
		kc_sbase = (char *) KC_GETMALLOCAREA((kc_size_t)(kc_len + 1)); /* +1 for '\0' */
		kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
		kc_answer.yt_float = kc_ator( kc_sbase );
		break;
	case (int)sel__Str:
		if (kc_read_sharing_find_base( kc_stream, &kc_sbase ) == KC_NOT_READ_YET) {
			kc_not_read_yet = True;
			kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
			if ( kc_delim == EOF )
				longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
			kc_sbase = (char *) KC_GETMALLOCAREA((kc_size_t)(kc_len + 1)); /* +1 for '\0' */
			kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
		}
		kc_answer.yt_casestring = mkcasestring( kc_sbase );
		if (kc_not_read_yet) {
			kc_read_sharing_store_base( kc_answer.yt_casestring->name );
		}
		break;
	case (int)sel_NoCaseStr:
		if (kc_read_sharing_find_base( kc_stream, &kc_sbase ) == KC_NOT_READ_YET) {
			kc_not_read_yet = True;
			kc_do_get_int(kc_delim,getc(kc_stream),kc_len,kc_stream);
			if ( kc_delim == EOF )
				longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
			kc_sbase = (char *) KC_GETMALLOCAREA((kc_size_t)(kc_len + 1)); /* +1 for '\0' */
			kc_CSGIOdo_read_atom_denotation(kc_stream, kc_sbase, kc_len);
		}
		kc_answer.yt_nocasestring = mknocasestring( kc_sbase );
		if (kc_not_read_yet) {
			kc_read_sharing_store_base( kc_answer.yt_nocasestring->name );
		}
		break;
	default: {
		kc_voidptr_t kc_subtmp[12];
		int kc_i;
		for (kc_i = 0; kc_i < kc_OperatorInfo[kc_op].no_sons; kc_i++) {
			kc_subtmp[kc_i] = kc_CSGIOread2dft(kc_stream, kc_OperatorInfo[kc_op].subphylum[kc_i] );
		}
		switch(kc_OperatorInfo[kc_op].no_sons) {
		case 0: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)(); break;
		case 1: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0] ); break;
		case 2: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1] ); break;
		case 3: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2] ); break;
		case 4: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3] ); break;
		case 5: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4] ); break;
		case 7: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6] ); break;
		case 8: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7] ); break;
		case 12: kc_answer.yt_casestring = (casestring) (*kc_OperatorInfo[kc_op].create_routine)( kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7], kc_subtmp[8], kc_subtmp[9], kc_subtmp[10], kc_subtmp[11] ); break;
		default: assertReason(kc_zero_constant, "unexpected number of sub-phyla"); break;
		}
	}}
	kc_read_sharing_store( kc_answer, kc_location );
	return (kc_voidptr_t) kc_answer.yt_casestring;
}

static KC_IO_RETURN kc_CSGIOreadphylum
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, kc_voidptr_t *kc_ptr, kc_enum_phyla kc_phylum)
#else
(kc_stream, kc_ptr, kc_phylum) FILE *kc_stream; kc_voidptr_t *kc_ptr; kc_enum_phyla kc_phylum;
#endif
{	KC_IO_STATUS kc_answer;
	int kc_scan_return_code;
	char kc_magic_no[KC_MAGIC_LENGTH];
	char kc_dollarcode[KC_OP_LENGTH];
	char kc_ext_name[KC_OP_LENGTH];
	int kc_operator, kc_node_count, kc_node_count_base;

	kc_csgio_err_reason = "";
	kc_scan_return_code = fscanf( kc_stream, KC_MAGIC_READ_FORMAT, kc_magic_no );
	if ( kc_scan_return_code != 1 )
		return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT, "magic string not scanned") );
	if ( strcmp( kc_magic_no, kc_ascii_prefix_magic_v3 ) != 0 )
		return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"scanned magic string is not asc_ssl_v3 magic string") );
	if ( fscanf( kc_stream, "$%[^ ] \n", kc_dollarcode ) != 1 )
		return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"problems finding $ before operators") );
	while ( strcmp( kc_dollarcode, "operators" ) != 0 ) {
		if ( fscanf( kc_stream, "%*[^$]$%[^ ] \n", kc_dollarcode) != 1 )
			return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT,"problems finding operators keyword") );
	}
	/* read all external operator definitions and initialize map */
	kc_no_external_ops = 0;
	kc_initializeOpToOpMap(KC_NOT_FOUND_OPERATOR);
	while ( ! kc_zero_constant ) {
		int kc_ext_arity, kc_ext_attr_arity, kc_ext_atomicity;

		if ( fscanf( kc_stream, "%[^ ] ", kc_ext_name ) != 1 )
			return( kc_io_return(KC_CSGIOSTATUS_SCAN_ERR_3, "no operator name at start of line") );
		else if ( kc_ext_name[0] == '$' )
			break;
		else if ( fscanf( kc_stream, "%d %d %d\n", &kc_ext_arity, &kc_ext_attr_arity, &kc_ext_atomicity ) != 3 )
			return( kc_io_return(KC_CSGIOSTATUS_SCAN_ERR_4, "no arity, attr_arity or atomicity") );
		else {
			kc_operator = kc_op_search( kc_ext_name );
			if ( ( kc_operator == KC_NOT_FOUND_OPERATOR ) ||
				 ( KC_NO_SONS( kc_operator ) != kc_ext_arity ) ||
				 ( KC_ATOMICITY( kc_operator) != kc_ext_atomicity )
			   )
				return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT, kc_str_conc2("problems with operator: ",kc_ext_name)) );
			else {
				KC_MAKE_NEW_MAPPING( kc_no_external_ops, kc_operator );
				kc_no_external_ops++;
	}	}	}
	kc_answer = (KC_IO_STATUS) setjmp( kc_priv_env );
	if ( kc_answer != KC_CSGIOSTATUS_NO_ERR )
		/* longjmp was called if we get here */
		return( kc_io_return(kc_answer, kc_csgio_err_reason));
	else {
		/* ascertain that we are at the $object section, or get to that point */
		if ( strcmp( kc_ext_name, "$object" ) != 0 ) /* if not at $object */
			while ( strcmp( kc_ext_name, "object" ) != 0 ) {
				if ( fscanf( kc_stream, "%*[^$]$%[^ ]", kc_ext_name ) != 1 )
					return( kc_io_return(KC_CSGIOSTATUS_GRAM_INCONSISTENT, kc_str_conc2("problems finding start of object section","")) );
			}

		/* read node_count; set up address map */
		if (fscanf(kc_stream, "%d %d\n", &kc_node_count, &kc_node_count_base) != 2)
			longjmp(kc_priv_env, (int)KC_CSGIOSTATUS_SCAN_ERR_1);
		kc_init_read_sharing(kc_node_count, kc_node_count_base); /* for shared values */

		/* read the tree (actually a graph) */
		*kc_ptr = kc_CSGIOread2dft( kc_stream, kc_phylum );
		kc_end_read_sharing(); /* for atomic values */

		kc_answer = KC_CSGIOSTATUS_ROK;
	}
	return( kc_io_return(kc_answer, "") );
}

char *CSGIOread_nocasestring
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, nocasestring *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; nocasestring *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_nocasestring )); }
char *CSGIOread_casestring
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, casestring *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; casestring *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_casestring )); }
char *CSGIOread_float
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, float *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; float *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_float )); }
char *CSGIOread_int
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, int *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; int *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_int )); }
char *CSGIOread_cr_specification
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_specification )); }
char *CSGIOread_cr_specification_type
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification_type *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification_type *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_specification_type )); }
char *CSGIOread_cr_boolean_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_boolean_indication *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_boolean_indication *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_boolean_indication )); }
char *CSGIOread_cr_definition_block
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_definition_block *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_definition_block *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_definition_block )); }
char *CSGIOread_cr_process_definition_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_definition_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_definition_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_process_definition_list )); }
char *CSGIOread_cr_process_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_definition *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_definition *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_process_definition )); }
char *CSGIOread_cr_functionality
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_functionality *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_functionality *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_functionality )); }
char *CSGIOread_cr_sort_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_identifier_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_identifier_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_identifier_list )); }
char *CSGIOread_cr_data_type_definition_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_data_type_definition_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_data_type_definition_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_data_type_definition_list )); }
char *CSGIOread_cr_data_type_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_data_type_definition *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_data_type_definition *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_data_type_definition )); }
char *CSGIOread_cr_completeness_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_completeness_indication *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_completeness_indication *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_completeness_indication )); }
char *CSGIOread_cr_persistency_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_persistency_indication *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_persistency_indication *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_persistency_indication )); }
char *CSGIOread_cr_p_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_p_expression *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_p_expression *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_p_expression )); }
char *CSGIOread_cr_type_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_type_identifier_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_type_identifier_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_type_identifier_list )); }
char *CSGIOread_cr_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_replacement *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_replacement *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_replacement )); }
char *CSGIOread_cr_sort_replacement_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_replacement_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_replacement_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_replacement_list )); }
char *CSGIOread_cr_sort_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_replacement *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_replacement *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_replacement )); }
char *CSGIOread_cr_sort_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_declaration_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_declaration_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_declaration_list )); }
char *CSGIOread_cr_sort_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_declaration *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_declaration *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_declaration )); }
char *CSGIOread_cr_operation_replacement_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_replacement_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_replacement_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation_replacement_list )); }
char *CSGIOread_cr_operation_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_replacement *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_replacement *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation_replacement )); }
char *CSGIOread_cr_flattened_type_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_flattened_type_definition *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_flattened_type_definition *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_flattened_type_definition )); }
char *CSGIOread_cr_operation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation_list )); }
char *CSGIOread_cr_operation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation )); }
char *CSGIOread_cr_prefix_infix
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_prefix_infix *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_prefix_infix *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_prefix_infix )); }
char *CSGIOread_cr_rewrite_strategy
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_rewrite_strategy *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_rewrite_strategy *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_rewrite_strategy )); }
char *CSGIOread_cr_operator_class
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operator_class *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operator_class *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operator_class )); }
char *CSGIOread_cr_equations_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equations_option *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equations_option *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equations_option )); }
char *CSGIOread_cr_equation_structure_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_structure_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_structure_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equation_structure_list )); }
char *CSGIOread_cr_equation_structure
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_structure *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_structure *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equation_structure )); }
char *CSGIOread_cr_equation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equation_list )); }
char *CSGIOread_cr_equation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equation )); }
char *CSGIOread_cr_premiss_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_premiss_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_premiss_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_premiss_list )); }
char *CSGIOread_cr_equality
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equality *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equality *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_equality )); }
char *CSGIOread_cr_identifier_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_declaration_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_declaration_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_identifier_declaration_list )); }
char *CSGIOread_cr_identifier_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_declaration *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_declaration *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_identifier_declaration )); }
char *CSGIOread_cr_value_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_identifier_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_identifier_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_value_identifier_list )); }
char *CSGIOread_cr_annotated_value_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_annotated_value_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_annotated_value_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_annotated_value_identifier )); }
char *CSGIOread_cr_behaviour_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_behaviour_expression *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_behaviour_expression *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_behaviour_expression )); }
char *CSGIOread_cr_parallel_operator
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_parallel_operator *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_parallel_operator *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_parallel_operator )); }
char *CSGIOread_cr_gate_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_declaration_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_declaration_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_gate_declaration_list )); }
char *CSGIOread_cr_gate_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_declaration *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_declaration *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_gate_declaration )); }
char *CSGIOread_cr_gate_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_identifier_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_identifier_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_gate_identifier_list )); }
char *CSGIOread_cr_exit_entry_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_exit_entry_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_exit_entry_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_exit_entry_list )); }
char *CSGIOread_cr_exit_entry
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_exit_entry *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_exit_entry *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_exit_entry )); }
char *CSGIOread_cr_identifier_equation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_equation_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_equation_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_identifier_equation_list )); }
char *CSGIOread_cr_identifier_equation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_equation *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_equation *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_identifier_equation )); }
char *CSGIOread_cr_action_denotation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_action_denotation *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_action_denotation *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_action_denotation )); }
char *CSGIOread_cr_experiment_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_option *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_option *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_experiment_option )); }
char *CSGIOread_cr_experiment_offer_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_offer_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_offer_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_experiment_offer_list )); }
char *CSGIOread_cr_experiment_offer
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_offer *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_offer *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_experiment_offer )); }
char *CSGIOread_cr_guard_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_guard_option *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_guard_option *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_guard_option )); }
char *CSGIOread_cr_value_expression_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_expression_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_expression_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_value_expression_list )); }
char *CSGIOread_cr_value_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_expression *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_expression *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_value_expression )); }
char *CSGIOread_cr_specification_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_specification_identifier )); }
char *CSGIOread_cr_operation_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation_identifier )); }
char *CSGIOread_cr_type_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_type_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_type_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_type_identifier )); }
char *CSGIOread_cr_sort_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_identifier )); }
char *CSGIOread_cr_gate_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_gate_identifier )); }
char *CSGIOread_cr_value_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_value_identifier )); }
char *CSGIOread_cr_process_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_process_identifier )); }
char *CSGIOread_cr_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_identifier )); }
char *CSGIOread_cr_extension
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_extension *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_extension *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_extension )); }
char *CSGIOread_cr_operation_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_name *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_name *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_operation_name )); }
char *CSGIOread_cr_sort_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_name *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_name *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_sort_name )); }
char *CSGIOread_cr_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_name *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_name *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_name )); }
char *CSGIOread_cr_comment_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_comment_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_comment_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_comment_list )); }
char *CSGIOread_cr_annotation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_annotation_list *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_annotation_list *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_annotation_list )); }
char *CSGIOread_cr_LABEL
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_LABEL *kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_LABEL *kc_p;
#endif
{ return kc_readKC_IO_RETURN2char( kc_CSGIOreadphylum( kc_stream, (kc_voidptr_t *)kc_p, kc_phylum_cr_LABEL )); }
#endif /* ! KC_NO_CSGIO_READ */

#ifndef KC_NO_CSGIO_WRITE
static int kc_node_count;
static int kc_node_count_base;

static void kc_print_to_file
#ifdef KC_USE_PROTOTYPES
(FILE *kc_f, char *kc_value)
#else
(kc_f, kc_value) FILE *kc_f; char *kc_value;
#endif
{	register unsigned char *kc_vptr = (unsigned char*)kc_value;
	register int kc_len = strlen(kc_value);
	register int kc_i;
	static char kc_hex_digit[] = "0123456789abcdef";

	(void)fprintf(kc_f, "%d ", kc_len);
	for (kc_i=0; kc_i<kc_len; kc_i++, kc_vptr++) {
		if (*kc_vptr == '\\') {
			(void)fprintf(kc_f, "\\\\");
		} else if (isprint(*kc_vptr)) {
			(void)putc((char)*kc_vptr, kc_f);
		} else {
			(void)fprintf(kc_f, "\\%c%c", kc_hex_digit[*kc_vptr / 16], kc_hex_digit[*kc_vptr % 16]);
		}
	}
	(void)putc('\n', kc_f);
/**** very dirty, i think *************
	(void)putc('\0', kc_f);
	(kc_f->_ptr)--;
	kc_f->_cnt++;
 *****************************/
}

static void kc_print_b64_to_file
#ifdef KC_USE_PROTOTYPES
(FILE *kc_f, int kc_value)
#else
(kc_f, kc_value) FILE *kc_f; int kc_value;
#endif
{	unsigned int kc_pos_value;	

	if (kc_value == 0) {
		(void)putc(KC_B64_ZERO_CHAR, kc_f);
	} else {
		kc_pos_value = abs(kc_value);
        	while (kc_pos_value != 0) {
			(void)putc((int)((kc_pos_value & KC_SIX_BIT_MASK) + KC_B64_ZERO_CHAR), kc_f);
			kc_pos_value >>= 6;
		}
		if (kc_value < 0) {
			(void)putc('-', kc_f);
		}
	}
	(void)putc('\n', kc_f);
}

static void kc_CSGIOscan
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, kc_voidptr_t kc_p, kc_enum_phyla kc_phylum)
#else
(kc_stream, kc_p, kc_phylum) FILE *kc_stream; kc_voidptr_t kc_p; kc_enum_phyla kc_phylum;
#endif
{	int kc_i;
	kc_enum_operators kc_prodsel;
	kc_hashnode_t kc_hn;
	assertPhylum(((casestring)kc_p),"kc_p",kc_phylum);
	kc_prodsel = (kc_phylum == kc_phylum_int ? sel__Int : (kc_phylum == kc_phylum_float ? sel__Real :((casestring)kc_p)->prod_sel));
	kc_hn = kc_mkhashnode((kc_voidptr_t) kc_p, kc_CSGIOhashtable);
	if (kc_hn->number == -1) {
		kc_hn->number = kc_node_count++;
		KC_MAKE_NEW_SCAN_MAPPING( (int)kc_prodsel );
		switch((int)kc_prodsel) {
		case (int)sel__Int:
		case (int)sel__Real:
			break;
		case (int)sel__Str:
		case (int)sel_NoCaseStr:
			kc_hn = kc_mkhashnode(((kc_voidptr_t) ((casestring)kc_p)->name), kc_CSGIOhashtable);
			if (kc_hn->number == -1) {
				kc_hn->number = kc_node_count_base++;
			}
			break;
		default:
			for (kc_i=0; kc_i < kc_OperatorInfo[(int)kc_prodsel].no_sons; kc_i++) {
				kc_CSGIOscan( kc_stream, (kc_voidptr_t)KC_SUBPHYLUM(kc_p, kc_OperatorInfo[(int)kc_prodsel].suboffset[kc_i]), kc_OperatorInfo[(int)kc_prodsel].subphylum[kc_i] );
}	}	}	}

static void KC_CSGIOwrite2structure
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, kc_voidptr_t kc_p, kc_enum_phyla kc_phylum)
#else
(kc_stream, kc_p, kc_phylum) FILE *kc_stream; kc_voidptr_t kc_p; kc_enum_phyla kc_phylum;
#endif
{	int kc_i;
	kc_enum_operators kc_prodsel;
	kc_hashnode_t kc_hn;
	assertPhylum(((casestring)kc_p),"kc_p",kc_phylum);
	kc_prodsel = (kc_phylum == kc_phylum_int ? sel__Int : (kc_phylum == kc_phylum_float ? sel__Real : ((casestring)kc_p)->prod_sel));
	kc_hn = kc_mkhashnode((kc_voidptr_t) kc_p, kc_CSGIOhashtable);
	if (kc_hn->created) {
		kc_print_b64_to_file( kc_stream, kc_file_offset - kc_hn->number );
	} else {
		kc_hn->created = True;
		(void)fprintf( kc_stream, "%d\n", KC_MAP( (int)kc_prodsel ) );
		kc_file_offset++;
		switch((int)kc_prodsel) {
		case (int)sel__Int: {
			char kc_value[30];
			(void)sprintf( kc_value, "%d", (int)kc_p);
			kc_print_to_file( kc_stream, kc_value );
			break; }
		case (int)sel__Real: {
			char kc_value[30];
			YYSTYPE kc_y;
			kc_y.yt_int = (int)kc_p; /* VERY DIRTY */
			(void)sprintf( kc_value, "%f", kc_y.yt_float);
			kc_print_to_file( kc_stream, kc_value );
			break; }
		case (int)sel__Str:
		case (int)sel_NoCaseStr:
			kc_hn = kc_mkhashnode(((kc_voidptr_t) ((casestring)kc_p)->name), kc_CSGIOhashtable);
			if (kc_hn->created) {
				kc_print_b64_to_file( kc_stream, kc_file_offset_base - kc_hn->number );
			} else {
				kc_hn->created = True;
				(void)fprintf( kc_stream, "%c", KC_NON_B64_CHAR );
				kc_print_to_file( kc_stream, ((casestring)kc_p)->name );
				kc_file_offset_base++;
			}
			break;
		default:
			for (kc_i=0; kc_i < kc_OperatorInfo[(int)kc_prodsel].no_sons; kc_i++) {
				KC_CSGIOwrite2structure( kc_stream, (kc_voidptr_t)KC_SUBPHYLUM(kc_p, kc_OperatorInfo[(int)kc_prodsel].suboffset[kc_i]), kc_OperatorInfo[(int)kc_prodsel].subphylum[kc_i] );
}	}	}	}

static int kc_CSGIO_hashtablesize = 5000;
int kc_set_csgio_hashtablesize
#ifdef KC_USE_PROTOTYPES
(int kc_i)
#else
(kc_i) int kc_i;
#endif
{	int kc_tmp = kc_CSGIO_hashtablesize;
	kc_CSGIO_hashtablesize =  kc_i;
	return kc_tmp;
}

static KC_IO_RETURN kc_CSGIOwritephylum
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, kc_voidptr_t kc_p, kc_enum_phyla kc_phylum)
#else
(kc_stream, kc_p, kc_phylum) FILE *kc_stream; kc_voidptr_t kc_p; kc_enum_phyla kc_phylum;
#endif
{	int kc_i;

	kc_csgio_err_reason = "";

	kc_CSGIOhashtable = kc_ht_create_simple(kc_CSGIO_hashtablesize);

	/* write out the magic string and $operators string */
	(void)fprintf( kc_stream, "%s\n$operators \n", kc_ascii_prefix_magic_v3 );

	/* Initialize map from internal operators to external operators, */
	/* initially empty */
	kc_no_external_ops = 0;
	kc_node_count = 0;
	kc_node_count_base = 0;
	kc_initializeOpToOpMap(0); /* initialize to 0, not an other value */

	/* write out grammar and compute OpToOpMap[] */
	kc_CSGIOscan( kc_stream, kc_p, kc_phylum );
	/* sort the optoopmap on decreasing operator usage */
	kc_sort_rightOpToOpMap();
	kc_renumberOpToOpMap();
	
	/* write out the _sorted_ operator table */
	for(kc_i = 0; kc_i < KC_NO_OF_OPERATORS; kc_i++) {
		if (kc_OpToOpMap[kc_i].right != KC_NOT_USED) {
			(void)fprintf( kc_stream, "%s %d %d %d\n", KC_OP_NAME( kc_OpToOpMap[kc_i].left), KC_NO_SONS( kc_OpToOpMap[kc_i].left ), 0, KC_ATOMICITY( kc_OpToOpMap[kc_i].left ) );
	}	}

	/* sort the optoopmap increasing on the operator number */
	kc_sort_leftOpToOpMap();

	/* write out the grammar terminator string and the number of nodes */
	(void)fprintf( kc_stream, "$object \n%d %d\n", kc_node_count, kc_node_count_base );

	/* write out the tree */
	kc_file_offset = 0;
	kc_file_offset_base = 0;
	KC_CSGIOwrite2structure( kc_stream, kc_p, kc_phylum );

	kc_ht_delete(kc_CSGIOhashtable);

	return( kc_io_return(KC_CSGIOSTATUS_WOK, kc_csgio_err_reason) );
}

char *CSGIOwrite_nocasestring
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, nocasestring kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; nocasestring kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_nocasestring )); }
char *CSGIOwrite_casestring
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, casestring kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; casestring kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_casestring )); }
char *CSGIOwrite_float
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, float kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; float kc_p;
#endif
{ 	YYSTYPE kc_y;
	kc_y.yt_float = kc_p; /* VERY DIRTY */
	return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_y.yt_int, kc_phylum_float ));
}
char *CSGIOwrite_int
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, int kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; int kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_int )); }
char *CSGIOwrite_cr_specification
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_specification )); }
char *CSGIOwrite_cr_specification_type
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification_type kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification_type kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_specification_type )); }
char *CSGIOwrite_cr_boolean_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_boolean_indication kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_boolean_indication kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_boolean_indication )); }
char *CSGIOwrite_cr_definition_block
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_definition_block kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_definition_block kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_definition_block )); }
char *CSGIOwrite_cr_process_definition_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_definition_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_definition_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_process_definition_list )); }
char *CSGIOwrite_cr_process_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_definition kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_definition kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_process_definition )); }
char *CSGIOwrite_cr_functionality
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_functionality kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_functionality kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_functionality )); }
char *CSGIOwrite_cr_sort_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_identifier_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_identifier_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_identifier_list )); }
char *CSGIOwrite_cr_data_type_definition_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_data_type_definition_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_data_type_definition_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_data_type_definition_list )); }
char *CSGIOwrite_cr_data_type_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_data_type_definition kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_data_type_definition kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_data_type_definition )); }
char *CSGIOwrite_cr_completeness_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_completeness_indication kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_completeness_indication kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_completeness_indication )); }
char *CSGIOwrite_cr_persistency_indication
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_persistency_indication kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_persistency_indication kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_persistency_indication )); }
char *CSGIOwrite_cr_p_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_p_expression kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_p_expression kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_p_expression )); }
char *CSGIOwrite_cr_type_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_type_identifier_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_type_identifier_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_type_identifier_list )); }
char *CSGIOwrite_cr_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_replacement kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_replacement kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_replacement )); }
char *CSGIOwrite_cr_sort_replacement_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_replacement_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_replacement_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_replacement_list )); }
char *CSGIOwrite_cr_sort_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_replacement kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_replacement kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_replacement )); }
char *CSGIOwrite_cr_sort_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_declaration_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_declaration_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_declaration_list )); }
char *CSGIOwrite_cr_sort_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_declaration kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_declaration kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_declaration )); }
char *CSGIOwrite_cr_operation_replacement_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_replacement_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_replacement_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation_replacement_list )); }
char *CSGIOwrite_cr_operation_replacement
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_replacement kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_replacement kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation_replacement )); }
char *CSGIOwrite_cr_flattened_type_definition
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_flattened_type_definition kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_flattened_type_definition kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_flattened_type_definition )); }
char *CSGIOwrite_cr_operation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation_list )); }
char *CSGIOwrite_cr_operation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation )); }
char *CSGIOwrite_cr_prefix_infix
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_prefix_infix kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_prefix_infix kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_prefix_infix )); }
char *CSGIOwrite_cr_rewrite_strategy
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_rewrite_strategy kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_rewrite_strategy kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_rewrite_strategy )); }
char *CSGIOwrite_cr_operator_class
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operator_class kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operator_class kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operator_class )); }
char *CSGIOwrite_cr_equations_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equations_option kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equations_option kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equations_option )); }
char *CSGIOwrite_cr_equation_structure_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_structure_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_structure_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equation_structure_list )); }
char *CSGIOwrite_cr_equation_structure
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_structure kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_structure kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equation_structure )); }
char *CSGIOwrite_cr_equation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equation_list )); }
char *CSGIOwrite_cr_equation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equation kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equation kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equation )); }
char *CSGIOwrite_cr_premiss_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_premiss_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_premiss_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_premiss_list )); }
char *CSGIOwrite_cr_equality
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_equality kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_equality kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_equality )); }
char *CSGIOwrite_cr_identifier_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_declaration_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_declaration_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_identifier_declaration_list )); }
char *CSGIOwrite_cr_identifier_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_declaration kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_declaration kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_identifier_declaration )); }
char *CSGIOwrite_cr_value_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_identifier_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_identifier_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_value_identifier_list )); }
char *CSGIOwrite_cr_annotated_value_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_annotated_value_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_annotated_value_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_annotated_value_identifier )); }
char *CSGIOwrite_cr_behaviour_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_behaviour_expression kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_behaviour_expression kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_behaviour_expression )); }
char *CSGIOwrite_cr_parallel_operator
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_parallel_operator kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_parallel_operator kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_parallel_operator )); }
char *CSGIOwrite_cr_gate_declaration_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_declaration_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_declaration_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_gate_declaration_list )); }
char *CSGIOwrite_cr_gate_declaration
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_declaration kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_declaration kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_gate_declaration )); }
char *CSGIOwrite_cr_gate_identifier_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_identifier_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_identifier_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_gate_identifier_list )); }
char *CSGIOwrite_cr_exit_entry_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_exit_entry_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_exit_entry_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_exit_entry_list )); }
char *CSGIOwrite_cr_exit_entry
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_exit_entry kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_exit_entry kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_exit_entry )); }
char *CSGIOwrite_cr_identifier_equation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_equation_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_equation_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_identifier_equation_list )); }
char *CSGIOwrite_cr_identifier_equation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier_equation kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier_equation kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_identifier_equation )); }
char *CSGIOwrite_cr_action_denotation
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_action_denotation kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_action_denotation kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_action_denotation )); }
char *CSGIOwrite_cr_experiment_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_option kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_option kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_experiment_option )); }
char *CSGIOwrite_cr_experiment_offer_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_offer_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_offer_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_experiment_offer_list )); }
char *CSGIOwrite_cr_experiment_offer
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_experiment_offer kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_experiment_offer kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_experiment_offer )); }
char *CSGIOwrite_cr_guard_option
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_guard_option kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_guard_option kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_guard_option )); }
char *CSGIOwrite_cr_value_expression_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_expression_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_expression_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_value_expression_list )); }
char *CSGIOwrite_cr_value_expression
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_expression kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_expression kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_value_expression )); }
char *CSGIOwrite_cr_specification_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_specification_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_specification_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_specification_identifier )); }
char *CSGIOwrite_cr_operation_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation_identifier )); }
char *CSGIOwrite_cr_type_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_type_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_type_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_type_identifier )); }
char *CSGIOwrite_cr_sort_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_identifier )); }
char *CSGIOwrite_cr_gate_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_gate_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_gate_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_gate_identifier )); }
char *CSGIOwrite_cr_value_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_value_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_value_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_value_identifier )); }
char *CSGIOwrite_cr_process_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_process_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_process_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_process_identifier )); }
char *CSGIOwrite_cr_identifier
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_identifier kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_identifier kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_identifier )); }
char *CSGIOwrite_cr_extension
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_extension kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_extension kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_extension )); }
char *CSGIOwrite_cr_operation_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_operation_name kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_operation_name kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_operation_name )); }
char *CSGIOwrite_cr_sort_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_sort_name kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_sort_name kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_sort_name )); }
char *CSGIOwrite_cr_name
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_name kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_name kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_name )); }
char *CSGIOwrite_cr_comment_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_comment_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_comment_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_comment_list )); }
char *CSGIOwrite_cr_annotation_list
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_annotation_list kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_annotation_list kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_annotation_list )); }
char *CSGIOwrite_cr_LABEL
#ifdef KC_USE_PROTOTYPES
(FILE *kc_stream, cr_LABEL kc_p )
#else
(kc_stream, kc_p) FILE *kc_stream; cr_LABEL kc_p;
#endif
{ return kc_writeKC_IO_RETURN2char( kc_CSGIOwritephylum( kc_stream, (kc_voidptr_t)kc_p, kc_phylum_cr_LABEL )); }
#endif /* ! KC_NO_CSGIO_WRITE */

