/**********************************************
* (C) Copyright 1992; The LotoSphere Consortium
***********************************************
$Log: swbus.h,v $
 * Revision 2.4  1993/01/12  20:22:03  lotos
 * portability issues
 *
 * Revision 2.3  1993/01/12  14:41:08  lotos
 * use conf.h for portability
 *
 * Revision 2.2  1992/09/11  16:55:32  lotos
 * track new location of annotations
 *
 * Revision 2.1  1992/05/07  19:48:59  lotos
 * integreted into topo
 *
 * Revision 1.7  92/03/05  18:50:07  gabriel
 * Adapted to CR v9
 * 
 * Revision 1.6  92/01/31  11:35:06  gabriel
 * Adapted to TOPO 2R1.
 * It generates the CR as writen originally by the user.
 * Fixed the data types representation: now, it contains the original
 * data types and the semi-flattened versions of them.
 * Also the library is now correctly generated, with their own semi-
 * flattened representation.
 * 
 * Revision 1.5  92/01/08  13:39:10  gabriel
 * Added annotations for the lite compiler (colos)
 * Removed unneeded strdup's
 * Added progname variable
 * 
 * Revision 1.4  91/11/19  20:24:53  gabriel
 * Corrected bugs related with memory management in aux.c.
 * 
 * Revision 1.3  91/09/24  09:49:38  gabriel
 * Adapted to TOPO 1R7
 * 
 * Revision 1.2  91/07/05  18:25:31  gabriel
 * Cosmetics
 * Adapted to new version of TOPO
 * 
 * Revision 1.1  91/07/05  18:13:12  gabriel
 * Initial revision
 * 
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <setjmp.h>

#ifndef __STDC__
#  include <memory.h>
#endif

# include <sys/types.h>
#ifdef sun
#  include <sys/time.h>
#  include <sys/resource.h>
#endif

# include "version.h"

# include <rag.hh>
# include "k.h"

# include "colours.h"

# define c_mytid                                 116
# define c_isformal                              117
# define c_yes_sflat                             118
# define c_mylexv                                119
# define c_ccr_specification                     120
# define c_ccr_process_identifier                121
# define c_ccr_gate_identifier_list              122
# define c_ccr_identifier_declaration_list       123
# define c_ccr_functionality                     124
# define c_ccr_data_type_definition_list         125
# define c_ccr_definition_block                  126
# define c_ccr_annotation_list                   127
# define c_ccr_behaviour_expression              128
# define c_ccr_sort_identifier_list              129
# define c_ccr_sort_identifier                   130
# define c_ccr_exit_entry_list                   131
# define c_ccr_exit_entry                        132
# define c_ccr_value_expression                  133
# define c_ccr_action_denotation                 134
# define c_ccr_experiment_offer_list             135
# define c_ccr_experiment_offer                  136
# define c_ccr_guard_option                      137
# define c_ccr_gate_identifier                   138
# define c_ccr_value_expression_list             139
# define c_ccr_process_definition                140
# define c_ccr_process_definition_list           141
# define c_ccr_data_type_definition              142
# define c_ccr_flattened_type_definition         143
# define c_ccr_sort_declaration_list             144
# define c_ccr_operation_list                    145
# define c_ccr_actual_equations_option           146
# define c_ccr_equation_structure_list           147
# define c_ccr_equation_structure                148
# define c_ccr_formal_operation_list             149
# define c_ccr_formal_sort_declaration_list      150
# define c_ccr_type_identifier_list              151
# define c_ccr_type_identifier                   152
# define c_ccr_p_expression                      153
# define c_ccr_replacement                       154
# define c_ccr_sort_replacement_list             155
# define c_ccr_sort_replacement                  156
# define c_ccr_operation_replacement_list        157
# define c_ccr_operation_replacement             158
# define c_ccr_formal_equations_option           159
# define c_ccr_sort_declaration                  160
# define c_ccr_operation                         161
# define c_ccr_identifier_equation_list          162
# define c_ccr_identifier_equation               163
# define c_ccr_identifier_declaration            164
# define c_ccr_gate_declaration_list             165
# define c_ccr_gate_declaration                  166
# define c_ccr_operation_identifier              167
# define c_ccr_value_identifier                  168

# define c_ccr_prefix_infix                      170
# define c_ccr_parallel_operator                 171
# define c_ccr_value_identifier_list             172
# define c_ccr_annotated_value_identifier        173

# define c_ccr_equality                          175
# define c_ccr_specification_identifier          176
# define c_ccr_equation                          177
# define c_ccr_equation_list                     178
# define c_ccr_premiss_list                      179
# define c_ccr_casestring                        180

/*+++++ +++++*/
# define TSPEC  1
# define TTYPE  2
# define TSORT  3
# define TOPN   4
# define TPROC  5
# define TGATE  6
# define TVAL   7
/*+++++ +++++*/

SHARED char	*progname;

SHARED int      printable;
SHARED int      debugging;
SHARED AT*      ATable;
SHARED int      mk_unique;
SHARED TNODE**   sflt;

PUBLIC int  Getid ();
PUBLIC char *Getlexv ();
PUBLIC char *int2str ();
PUBLIC void print_spe ();

PUBLIC cr_specification_identifier make_cr_specification_id ();
PUBLIC cr_gate_identifier          make_cr_gate_id ();
PUBLIC cr_sort_identifier          make_cr_sort_id ();
PUBLIC cr_value_identifier         make_cr_value_id ();
PUBLIC cr_process_identifier       make_cr_process_id ();
PUBLIC cr_type_identifier          make_cr_type_id ();
PUBLIC cr_operation_identifier     make_cr_operation_id ();

PUBLIC cr_value_expression_list    get_val_expression_list ();
PUBLIC casestring                  make_annotations ();
PUBLIC cr_LABEL                    make_cr_label ();

PUBLIC CLR_TYPE reduce ();
PUBLIC CLR_TYPE red_inv ();

PUBLIC cr_data_type_definition_list mkconscr_data_type_definition_list ();
PUBLIC cr_process_definition_list   mkconscr_process_definition_list ();
PUBLIC cr_value_identifier_list     mkconscr_value_identifier_list ();

