#ifndef d2c_HH
#define d2c_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "d2c.hh": lotos Data language to C.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: d2c.desc,v $
 * Revision 2.7  1995/01/17  09:55:17  lotos
 * dynamic table sizing
 *
 * Revision 2.6  1993/06/10  14:04:19  lotos
 * new annotation CALL
 *
 * Revision 2.5  1993/05/28  10:51:50  lotos
 * opcion -c tiene niveles
 *
 * Revision 2.4  1993/01/18  18:32:21  lotos
 * cleaning of would-be-generated files, under file breaking
 *
 * Revision 2.2  1992/12/09  10:49:49  lotos
 * split into pieces
 *
 * Revision 2.1  1992/10/14  18:16:00  lotos
 * new philosophy to write ADTs,
 * every new expression is supposed to be pointed once,
 * in order to share a value, it has to be kd_copy'ed
 * functions assume their arguments are absolutely theirs
 *
 * Revision 1.5  1992/09/02  14:04:23  lotos
 * avoid casting on LHS (for portability)
 *
 * Revision 1.4  92/02/29  13:26:56  lotos
 * flags for pretty printing: optional
 * 
 * Revision 1.3  92/01/15  12:45:02  lotos
 * ready to distribute
 * 
 * Revision 1.2  91/11/20  13:26:31  lotos
 * parse and eval code added
 * 
 * Revision 1.1  91/10/02  16:59:52  lotos
 * Initial revision
 * 
 ***********************************/

#include "dtok.hh"
#include "clng.hh"


#define CMN_MAX_ARG     3

typedef struct
{ int put_help;
  int add_cmt;
  int indt_incr;
  int splt_pics;
  char *splt_prfx;
  int full_clng;
  char *hdr_file;
} tPROG_FLAG;	/* program flag storage structure */

/* program name */
#ifndef d2c_IMP
extern	char *prog_name;
#else
	char *prog_name= NULL;
#endif

/* program flag storage */
#ifndef d2c_IMP
extern	tPROG_FLAG prog_flag;
#else
	tPROG_FLAG prog_flag= { FALSE, 0, 0, 0, NULL, FALSE, NULL };
#endif

#endif
