#ifndef kaos_HH
#define kaos_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "kaos.hh": Kernel of "cAOS" generated code (C version).
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: kaos.desc,v $
 * Revision 2.6  1993/03/24  17:48:31  lotos
 * field RFC, removed
 *
 * Revision 2.5  1993/01/18  18:16:12  lotos
 * distribution issues
 *
 * Revision 2.4  1993/01/12  18:37:16  lotos
 * include stdio.h
 *
 * Revision 2.3  1992/12/02  11:04:05  lotos
 * draw and parse functions are controled by options
 * format of parse, changed
 *
 * Revision 2.2  1992/11/17  18:35:08  lotos
 * separate internal (kdatum) and external (udatum)
 * new annotation ldc at the very and of the spec
 * new annotation ldcinit at the beginning
 *
 * Revision 2.1  1992/10/14  18:16:00  lotos
 * new philosophy to write ADTs,
 * every new expression is supposed to be pointed once,
 * in order to share a value, it has to be kd_copy'ed
 * functions assume their arguments are absolutely theirs
 *
 * Revision 1.5  1992/09/02  14:04:23  lotos
 * avoid casting on LHS (for portability)
 *
 * Revision 1.4  92/05/06  18:45:53  lotos
 * debug flag added
 *
 * Revision 1.3  92/01/15  12:45:04  lotos
 * ready to distribute
 *
 * Revision 1.2  91/11/20  13:27:37  lotos
 * parse and eval code added
 *
 * Revision 1.1  91/10/02  17:00:04  lotos
 * Initial revision
 *
 ***********************************/

#include <stdio.h>
/* KJT 21/04/00: #include <values.h> */

/* boolean values */

#ifndef TRUE
#  define TRUE	1
#  define FALSE	0
#endif

/* basic data types */

typedef struct
{ int debug;	/* debugging flag */
  struct
  { int draw;
    int parse;
  } try;
} tKAOS_CFG;

#ifndef kaos_IMP
extern	tKAOS_CFG kaos;
#else
	tKAOS_CFG kaos= { FALSE, FALSE, FALSE };
#endif

typedef struct Kdatum
{ /* KJT 21/04/00: int:BITS(int)-1; */
  int cnt;		/* KJT 12/08/00: to allow cast to _xdatum */
  int opn;		/* operation identifier */
  struct Klink *lnk;	/* link to arguments */
} *kdatum;

typedef struct Klink
{ struct Kdatum *arg;	/* argument */
  struct Klink *next;	/* next argument */
} *klink;

typedef struct Udatum
{ /* KJT 21/04/00: int:BITS(int)-1; */
  int cnt;		/* KJT 12/08/00: to allow cast to _xdatum */
  int ino;		/* integer number */
  void *ptr;		/* any pointer */
} *udatum;

typedef struct
{ int sid;		/* sort identifier */
  int isextern;		/* is sort extern? */
  char *name;		/* sort name */
  void (*free)();	/* memory deallocation function */
  int (*equal)();	/* equality checking function */
  char *(*draw)();	/* drawing function */
  int (*parse)();	/* parsing function */
} tSORT_TBL[];

extern tSORT_TBL sort_tbl;
extern unsigned sort_tbl_size;

typedef struct
{ int oid;		/* operation identifier */
  int sid;		/* sort identifier */
  int narg;		/* number of arguments */
  int *sarg;		/* sort of arguments */
  int isextern;		/* is operation extern? */
  int isinfix;		/* is operation infix? */
  char *name;		/* operation name */
  kdatum (*eval)();	/* evaluation function */
} tOPN_TBL[];

extern tOPN_TBL opn_tbl;
extern unsigned opn_tbl_size;

/* error handling functions */

/* KJT 20/01/23: omitted: void	put_error (); */

/* data handling functions */

void	ldcinit ();

#define kd_alloc()	((kdatum)_xd_alloc())

#define ud_alloc()	((udatum)_xd_alloc())

#define kd_link()	((klink)_xd_link())

#define kd_copy(exp)		((kdatum)_xd_copy(_xd_internal, exp))

#define ud_copy(sort, exp)	((udatum)_xd_copy(sort, exp))

#define kd_const(exp)		((kdatum)_xd_const(_xd_internal, exp))

#define ud_const(sort, exp)	((udatum)_xd_const(sort, exp))

#define kd_free(exp)		(_xd_free(_xd_internal, exp))

#define ud_free(sort, exp)	(_xd_free(sort, exp))

#define kd_equal(exp1, exp2) \
	  (_xd_equal(_xd_internal, exp1, exp2, _xd_preserve))

#define ud_equal(sort, exp1, exp2) \
	  (_xd_equal(sort, exp1, exp2, _xd_preserve))

#define kd_gequal(exp1, exp2, mask) \
	  (_xd_equal(_xd_internal, exp1, exp2, mask))

#define ud_gequal(sort, exp1, exp2, mask) \
	  (_xd_equal(sort, exp1, exp2, mask))

#define kd_draw(exp)		(_xd_draw(_xd_internal, exp, _xd_preserve))

#define ud_draw(sort, exp)	(_xd_draw(sort, exp, _xd_preserve))

#define kd_gdraw(exp, mask)		(_xd_draw(_xd_internal, exp, mask))

#define ud_gdraw(sort, exp, mask)	(_xd_draw(sort, exp, mask))

#define kd_parse(sort, ptr, r)	(_xd_parse(sort, ptr, r))

#define ud_parse(sort, ptr, r)	(_xd_parse(sort, ptr, r))

#define kd_eval(sort, str, r)	(_xd_eval(sort, str, r))

#define ud_eval(sort, str, r)	(_xd_eval(sort, str, r))

#define kd_sort(snm)	_xd_sort(snm)

#define ud_sort(snm)	_xd_sort(snm)

/* internal functions */

#define _xd_internal (-7007)
#define _xd_preserve ((0x1 << 4) | (0x1 << 7))

extern kdatum _xd_alloc();
extern kdatum _xd_copy();
extern kdatum _xd_const();
extern void _xd_free();
extern int _xd_equal();
extern char *_xd_draw();
extern int _xd_parse();
extern int _xd_eval();
extern int _xd_sort();

#ifdef lint

#undef kd_alloc
extern kdatum kd_alloc();
#undef ud_alloc
extern udatum ud_alloc();

#undef kd_link
extern klink kd_link();

#undef kd_copy
extern kdatum kd_copy();
#undef ud_copy
extern udatum ud_copy();

#undef kd_const
extern kdatum kd_const();
#undef ud_const
extern udatum ud_const();

#undef kd_free
extern void kd_free();
#undef ud_free
extern void ud_free();

#undef kd_equal
extern int kd_equal();
#undef ud_equal
extern int ud_equal();

#undef kd_gequal
extern int kd_gequal();
#undef ud_gequal
extern int ud_gequal();

#undef kd_draw
extern char * kd_draw();
#undef ud_draw
extern char * ud_draw();

#undef kd_gdraw
extern char * kd_gdraw();
#undef ud_gdraw
extern char * ud_gdraw();

#undef kd_parse
extern int kd_parse();
#undef ud_parse
extern int ud_parse();

#undef kd_eval
extern int kd_eval();
#undef ud_eval
extern int ud_eval();

#undef kd_sort
extern int kd_sort();
#undef ud_sort
extern int ud_sort();

#endif
#endif
