%{
/***********************************************************************
     "glad.spe": General Language to Annotate Data, specification.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: glad.spe,v $
 Revision 1.5  2000/07/00  16:32:00  kjt
 changed YYMAXDEPTH to 512

 Revision 1.4  1993/06/10  13:56:52  lotos
 new annotation CALL

 Revision 1.3  1993/03/29  18:14:34  lotos
 keep lint shut down
 error recovery added

 Revision 1.2  1993/03/24  17:45:23  lotos
 new option -s
 new annotations: nofree, nodraw, noparse

 Revision 1.1  1993/03/18  11:14:24  lotos
 Initial revision

 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: glad.spe,v 1.4 1993/06/10 13:56:52 lotos Exp $";
#endif
%}
%{
# include "rag.hh"
# include "nodes.h"
# include "grc.h"
# define YYMAXDEPTH      512
# define YYSTYPE         yystype
# define putgrn(n)       (void)ITadd(n, gl)
# define class(nt)       { cls= 0; xxc= nt-1;   \
	       for (xc= 0; xc < nt; xc++, xxc--)    \
			     if (stpick(xc)->type != tNULL) \
		 cls += (1 << xxc);}
# define ndput(tp)   { stput(tp);   \
	       if (gn != NULL){gn->value0=  \
		  (CLR_TYPE)IAT_IT_add(gl, grnl); \
		  gl->size= 0;} \
	       gn= (sttype() == tNULL) ? NULL : sttop(); }
# define ndterm(tp, val) { stput (tp);  \
		       staclr (c_lexv, (CLR_TYPE)val.name); \
		       staclr (c_line, (CLR_TYPE)val.line);}

IT* gl;
TNODE*  gn;
int cls;
int xc;
int xxc;

#include "glad.hh"
#include "support.hh"
#include "token.hh"

#ifdef lint
#  define malloc(size)		_call_malloc(size)
#  define realloc(ptr, size)	_call_realloc(ALIN(void, ptr), size)
#  define free(ptr)		_call_free(ALIN(void, ptr))
#endif

/* KJT 20/01/23: added function prototypes */
int yyparse();

%}

%token SORTS 260
%token OPNS 261
%token IMPLICATION 262
%token SPECIFICATION 263
%token ANTBEGIN 264
%token ANTEND 265
%token ENDSPEC 266
%token ARROW 267
%token ANY 268
%token FORALL 269
%token IDENTIFIER 270
%token SPECIAL 271
%token LDC 272
%token ANTWORD 273
%token ANTTEXT 274
%token LDCINIT 275
%token USING 276
%token USINGSORT 277
%token NAME 278
%token LEXICAL 279
%token LEXICALIFPOSSIBLE 280
%token INTERNAL 281
%token EXTERN 282
%token FREE 283
%token NOFREE 284
%token EQUAL 285
%token DRAW 286
%token NODRAW 287
%token PARSE 288
%token NOPARSE 289
%token CALL 290
%token PARTIAL 291
%token CONSTRUCTOR 292
%token NONCONSTRUCTOR 293

%start module


%%

module                  :
	 template
	{
	if (errorcount == 0)
	{
	 putgrn(1);
	}
	}
	;

I1repa                  :
	 /* empty */
	{ ndput(tNULL); }
	;

I1repa                  :
	 I1repa rule_set
	{
	if (errorcount == 0)
	{
	 if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	}
	}
	;

template                :
	 I1repa
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(ttemplate);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(2);
	}
	}
	;

rule_set                :
	 initial_rule
	{
	if (errorcount == 0)
	{
	 putgrn(3);
	}
	}
	;

rule_set                :
	 SORTS sort_rule_list
	{
	if (errorcount == 0)
	{
	 putgrn(4);
	}
	}
	;

rule_set                :
	 OPNS operation_rule_list
	{
	if (errorcount == 0)
	{
	 putgrn(5);
	}
	}
	;

rule_set                :
	 final_rule
	{
	if (errorcount == 0)
	{
	 putgrn(6);
	}
	}
	;

I2opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I2opt                   :
	 IMPLICATION initial_annotation_list
	;

initial_rule            :
	 initial_pattern I2opt ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tinitial_rule);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(7);
	}
	}
	;

initial_pattern         :
	 SPECIFICATION
	{
	if (errorcount == 0)
	{
	 ndput(tinitial_pattern);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(8);
	}
	}
	;

I3repp                  :
	 initial_annotation
	;

I3repp                  :
	 I3repp initial_annotation
	{ if (errorcount == 0) stlrlink (); }
	;

initial_annotation_list :
	 I3repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tinitial_annotation_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(9);
	}
	}
	;

initial_annotation      :
	 ldc_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(10);
	}
	}
	;

initial_annotation      :
	 ldcinit_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(11);
	}
	}
	;

initial_annotation      :
	 ANTBEGIN error ANTEND
	{
	if (errorcount == 0)
	{
	 putgrn(12);
	}
	}
	;

initial_annotation      :
	 error
	{
	if (errorcount == 0)
	{
	 putgrn(13);
	}
	}
	;

I4opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I4opt                   :
	 IMPLICATION final_annotation_list
	;

final_rule              :
	 final_pattern I4opt ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tfinal_rule);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(14);
	}
	}
	;

final_pattern           :
	 ENDSPEC
	{
	if (errorcount == 0)
	{
	 ndput(tfinal_pattern);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(15);
	}
	}
	;

I5repp                  :
	 final_annotation
	;

I5repp                  :
	 I5repp final_annotation
	{ if (errorcount == 0) stlrlink (); }
	;

final_annotation_list   :
	 I5repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tfinal_annotation_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(16);
	}
	}
	;

final_annotation        :
	 ldc_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(17);
	}
	}
	;

final_annotation        :
	 ANTBEGIN error ANTEND
	{
	if (errorcount == 0)
	{
	 putgrn(18);
	}
	}
	;

final_annotation        :
	 error
	{
	if (errorcount == 0)
	{
	 putgrn(19);
	}
	}
	;

I6repp                  :
	 sort_rule
	;

I6repp                  :
	 I6repp sort_rule
	{ if (errorcount == 0) stlrlink (); }
	;

sort_rule_list          :
	 I6repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_rule_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(20);
	}
	}
	;

I7opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I7opt                   :
	 IMPLICATION sort_annotation_list
	;

sort_rule               :
	 sort_pattern I7opt ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tsort_rule);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(21);
	}
	}
	;

sort_pattern            :
	 sort_descriptor
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_pattern);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(22);
	}
	}
	;

sort_pattern            :
	 error
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tsort_pattern);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(23);
	}
	}
	;

sort_descriptor         :
	 any_sort
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(24);
	}
	}
	;

sort_descriptor         :
	 sort_identifier
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(25);
	}
	}
	;

I8repp                  :
	 sort_annotation
	;

I8repp                  :
	 I8repp sort_annotation
	{ if (errorcount == 0) stlrlink (); }
	;

sort_annotation_list    :
	 I8repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tsort_annotation_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(26);
	}
	}
	;

sort_annotation         :
	 name_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(27);
	}
	}
	;

sort_annotation         :
	 lexical_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(28);
	}
	}
	;

sort_annotation         :
	 extern_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(29);
	}
	}
	;

sort_annotation         :
	 free_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(30);
	}
	}
	;

sort_annotation         :
	 nofree_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(31);
	}
	}
	;

sort_annotation         :
	 equal_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(32);
	}
	}
	;

sort_annotation         :
	 draw_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(33);
	}
	}
	;

sort_annotation         :
	 nodraw_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(34);
	}
	}
	;

sort_annotation         :
	 parse_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(35);
	}
	}
	;

sort_annotation         :
	 noparse_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(36);
	}
	}
	;

sort_annotation         :
	 ANTBEGIN error ANTEND
	{
	if (errorcount == 0)
	{
	 putgrn(37);
	}
	}
	;

sort_annotation         :
	 error
	{
	if (errorcount == 0)
	{
	 putgrn(38);
	}
	}
	;

I9repp                  :
	 operation_rule
	;

I9repp                  :
	 I9repp operation_rule
	{ if (errorcount == 0) stlrlink (); }
	;

operation_rule_list     :
	 I9repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_rule_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(39);
	}
	}
	;

I10opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I10opt                  :
	 IMPLICATION operation_annotation_list
	;

operation_rule          :
	 operation_pattern I10opt ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(toperation_rule);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(40);
	}
	}
	;

I11opt                  :
	 /* empty */
	{ ndput (tNULL); }
	;

I11opt                  :
	 argument_descriptor
	;

operation_pattern       :
	 operation_descriptor ':' I11opt ARROW result_descriptor
	{
	if (errorcount == 0)
	{
	 class(3);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(toperation_pattern);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(41);
	}
	}
	;

operation_pattern       :
	 error
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(toperation_pattern);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(42);
	}
	}
	;

operation_descriptor    :
	 any_operation
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(43);
	}
	}
	;

operation_descriptor    :
	 operation_identifier
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(44);
	}
	}
	;

operation_descriptor    :
	 '_' operation_identifier '_'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(45);
	}
	}
	;

argument_descriptor     :
	 any_argument_list
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(targument_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(46);
	}
	}
	;

argument_descriptor     :
	 argument_list
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(targument_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(47);
	}
	}
	;

I12repp_sep             :
	 argument
	;

I12repp_sep             :
	 I12repp_sep ',' argument
	{ if (errorcount == 0) stlrlink (); }
	;

argument_list           :
	 I12repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(targument_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(48);
	}
	}
	;

argument                :
	 any_sort
	{
	if (errorcount == 0)
	{
	 putgrn(49);
	}
	}
	;

argument                :
	 sort_identifier
	{
	if (errorcount == 0)
	{
	 putgrn(50);
	}
	}
	;

result_descriptor       :
	 any_sort
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tresult_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(51);
	}
	}
	;

result_descriptor       :
	 sort_identifier
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tresult_descriptor);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(52);
	}
	}
	;

I13repp                 :
	 operation_annotation
	;

I13repp                 :
	 I13repp operation_annotation
	{ if (errorcount == 0) stlrlink (); }
	;

operation_annotation_list :
	 I13repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(toperation_annotation_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(53);
	}
	}
	;

operation_annotation    :
	 using_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(54);
	}
	}
	;

operation_annotation    :
	 usingsort_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(55);
	}
	}
	;

operation_annotation    :
	 name_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(56);
	}
	}
	;

operation_annotation    :
	 lexical_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(57);
	}
	}
	;

operation_annotation    :
	 lexicalifpossible_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(58);
	}
	}
	;

operation_annotation    :
	 internal_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(59);
	}
	}
	;

operation_annotation    :
	 extern_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(60);
	}
	}
	;

operation_annotation    :
	 call_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(61);
	}
	}
	;

operation_annotation    :
	 partial_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(62);
	}
	}
	;

operation_annotation    :
	 constructor_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(63);
	}
	}
	;

operation_annotation    :
	 nonconstructor_annotation
	{
	if (errorcount == 0)
	{
	 putgrn(64);
	}
	}
	;

operation_annotation    :
	 ANTBEGIN error ANTEND
	{
	if (errorcount == 0)
	{
	 putgrn(65);
	}
	}
	;

operation_annotation    :
	 error
	{
	if (errorcount == 0)
	{
	 putgrn(66);
	}
	}
	;

any_sort                :
	 ANY
	{
	if (errorcount == 0)
	{
	 ndput(tany_sort);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(67);
	}
	}
	;

any_operation           :
	 ANY
	{
	if (errorcount == 0)
	{
	 ndput(tany_operation);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(68);
	}
	}
	;

any_argument_list       :
	 FORALL
	{
	if (errorcount == 0)
	{
	 ndput(tany_argument_list);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(69);
	}
	}
	;

sort_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tsort_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(70);
	}
	}
	;

operation_identifier    :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(71);
	}
	}
	;

operation_identifier    :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(72);
	}
	}
	;

ldc_annotation          :
	 ANTBEGIN LDC ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tldc_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(73);
	}
	}
	;

ldc_annotation          :
	 ANTBEGIN LDC ANTTEXT ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tldc_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(74);
	}
	}
	;

ldc_annotation          :
	 ANTBEGIN LDC error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tldc_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(75);
	}
	}
	;

ldcinit_annotation      :
	 ANTBEGIN LDCINIT ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tldcinit_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(76);
	}
	}
	;

ldcinit_annotation      :
	 ANTBEGIN LDCINIT ANTTEXT ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tldcinit_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(77);
	}
	}
	;

ldcinit_annotation      :
	 ANTBEGIN LDCINIT error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tldcinit_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(78);
	}
	}
	;

using_annotation        :
	 ANTBEGIN USING ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tusing_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(79);
	}
	}
	;

using_annotation        :
	 ANTBEGIN USING error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tusing_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(80);
	}
	}
	;

usingsort_annotation    :
	 ANTBEGIN USINGSORT ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tusingsort_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(81);
	}
	}
	;

usingsort_annotation    :
	 ANTBEGIN USINGSORT error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tusingsort_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(82);
	}
	}
	;

name_annotation         :
	 ANTBEGIN NAME ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tname_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(83);
	}
	}
	;

name_annotation         :
	 ANTBEGIN NAME error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tname_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(84);
	}
	}
	;

lexical_annotation      :
	 ANTBEGIN LEXICAL ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tlexical_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(85);
	}
	}
	;

lexical_annotation      :
	 ANTBEGIN LEXICAL error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tlexical_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(86);
	}
	}
	;

lexicalifpossible_annotation :
	 ANTBEGIN LEXICALIFPOSSIBLE ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tlexicalifpossible_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(87);
	}
	}
	;

lexicalifpossible_annotation :
	 ANTBEGIN LEXICALIFPOSSIBLE error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tlexicalifpossible_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(88);
	}
	}
	;

internal_annotation     :
	 ANTBEGIN INTERNAL ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tinternal_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(89);
	}
	}
	;

internal_annotation     :
	 ANTBEGIN INTERNAL error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tinternal_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(90);
	}
	}
	;

extern_annotation       :
	 ANTBEGIN EXTERN ANTEND
	{
	if (errorcount == 0)
	{
  ndput(textern_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(91);
	}
	}
	;

extern_annotation       :
	 ANTBEGIN EXTERN error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(textern_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(92);
	}
	}
	;

free_annotation         :
	 ANTBEGIN FREE ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tfree_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(93);
	}
	}
	;

free_annotation         :
	 ANTBEGIN FREE error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tfree_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(94);
	}
	}
	;

nofree_annotation       :
	 ANTBEGIN NOFREE ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tnofree_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(95);
	}
	}
	;

nofree_annotation       :
	 ANTBEGIN NOFREE error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tnofree_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(96);
	}
	}
	;

equal_annotation        :
	 ANTBEGIN EQUAL ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tequal_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(97);
	}
	}
	;

equal_annotation        :
	 ANTBEGIN EQUAL error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tequal_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(98);
	}
	}
	;

draw_annotation         :
	 ANTBEGIN DRAW ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tdraw_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(99);
	}
	}
	;

draw_annotation         :
	 ANTBEGIN DRAW error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tdraw_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(100);
	}
	}
	;

nodraw_annotation       :
	 ANTBEGIN NODRAW ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tnodraw_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(101);
	}
	}
	;

nodraw_annotation       :
	 ANTBEGIN NODRAW error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tnodraw_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(102);
	}
	}
	;

parse_annotation        :
	 ANTBEGIN PARSE ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tparse_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(103);
	}
	}
	;

parse_annotation        :
	 ANTBEGIN PARSE error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tparse_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(104);
	}
	}
	;

noparse_annotation      :
	 ANTBEGIN NOPARSE ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tnoparse_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(105);
	}
	}
	;

noparse_annotation      :
	 ANTBEGIN NOPARSE error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tnoparse_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(106);
	}
	}
	;

call_annotation         :
	 ANTBEGIN CALL ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tcall_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(107);
	}
	}
	;

call_annotation         :
	 ANTBEGIN CALL ANTTEXT ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tcall_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(108);
	}
	}
	;

call_annotation         :
	 ANTBEGIN CALL error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tcall_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(109);
	}
	}
	;

partial_annotation      :
	 ANTBEGIN PARTIAL ANTWORD ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tpartial_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(110);
	}
	}
	;

partial_annotation      :
	 ANTBEGIN PARTIAL ANTTEXT ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tpartial_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
  staclr(c_antv, (CLR_TYPE) ALIN(void, $3.antv));
	 putgrn(111);
	}
	}
	;

partial_annotation      :
	 ANTBEGIN PARTIAL error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tpartial_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(112);
	}
	}
	;

constructor_annotation  :
	 ANTBEGIN CONSTRUCTOR ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tconstructor_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(113);
	}
	}
	;

constructor_annotation  :
	 ANTBEGIN CONSTRUCTOR error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tconstructor_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(114);
	}
	}
	;

nonconstructor_annotation :
	 ANTBEGIN NONCONSTRUCTOR ANTEND
	{
	if (errorcount == 0)
	{
  ndput(tnonconstructor_annotation);
  staclr(c_line, (CLR_TYPE) $3.line);
	 putgrn(115);
	}
	}
	;

nonconstructor_annotation :
	 ANTBEGIN NONCONSTRUCTOR error ANTEND
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tnonconstructor_annotation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(116);
	}
	}
	;

%%

PRIVATE int
yylex ()
{
    token *tk;

   tk = gtk ();
   yylval = tk->yylval;
   return tk->type;
}

PUBLIC TNODE*
bast ()
{
   gl= ITcreate (4, 2, 1);
   gn= NULL;
   (void)yyparse();
   if (gn != NULL) gn->value0= (CLR_TYPE)IAT_IT_add(gl, grnl);
   return sttop();
}
