/***********************************************************************
     "glad.spe": General Language to Annotate Data, specification.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: glad.spe,v $
 Revision 1.4  1993/06/10  13:56:52  lotos
 new annotation CALL

 Revision 1.3  1993/03/29  18:14:34  lotos
 keep lint shut down
 error recovery added

 Revision 1.2  1993/03/24  17:45:23  lotos
 new option -s
 new annotations: nofree, nodraw, noparse

 Revision 1.1  1993/03/18  11:14:24  lotos
 Initial revision

 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: glad.spe,v 1.4 1993/06/10 13:56:52 lotos Exp $";
#endif

# include <assert.h>
# include "rag.hh"
# include "nodes.h"
# include "grc.h"

IAT* grnl= NULL;

#include "glad.hh"
#include "support.hh"
#include "process.hh"

PRIVATE void
PROCESINI (r)
    TNODE* r;
{
  TNODE* h[33];
  /* KJT 20/01/23: added "int" type */
  register int i;
  int nr;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
     nr= grl[i];
     switch (nr) {
      case _initial_rule_1:
	 if (h[0] != NULL)
	  adclr (-c_init, h[0], 1);
	 break;
      case _final_rule_1:
	 if (h[0] != NULL)
	  adclr (-c_init, h[0], 2);
	 break;
      case _sort_rule_1:
	 if (h[0] != NULL)
	  adclr (-c_init, h[0], 3);
	 break;
      case _operation_rule_1:
	 if (h[0] != NULL)
	  adclr (-c_init, h[0], 4);
	 break;
      case _operation_descriptor_3:
	 adclr (-c_infix, h[1], 5);
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCESINI */

PUBLIC CLR_TYPE
eval (nar, r)
    int nar;
    TNODE* r;
{
  TNODE* h[33];

  if (r == NULL) return (CLR_TYPE)NULL;
  switch (nar) {
  case 1:
    h[0]= r;
    heval (h[0], h);

  {
     init_rule(h[0]);
      return (CLR_TYPE) TRUE;
  }
  case 2:
    h[0]= r;
    heval (h[0], h);

  {
     init_rule(h[0]);
      return (CLR_TYPE) TRUE;
  }
  case 3:
    h[0]= r;
    heval (h[0], h);

  {
     init_rule(h[0]);
      return (CLR_TYPE) TRUE;
  }
  case 4:
    h[0]= r;
    heval (h[0], h);

  {
     init_rule(h[0]);
      return (CLR_TYPE) TRUE;
  }
  case 5:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
     }
  return (CLR_TYPE)NULL;
}






PUBLIC void
visit (r)
	TNODE*	r;
{
	TNODE*	h[33];
	int	nar;

  if (r == NULL) return;
  nar= *(grnl->data[(int)(r->value0)]);
  switch (nar) {

   case _template_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE *nodep;
	 for (nodep= gt_fs(h[0]); nodep != NULL; nodep= gt_rb(nodep))
	 visit(nodep);
	}
	break;

   case _initial_rule_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 apply_rule(h[0]);
	}
	break;

   case _final_rule_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 apply_rule(h[0]);
	}
	break;

   case _sort_rule_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE *nodep;
	 for (nodep= gt_fs(h[0]); nodep != NULL; nodep= gt_rb(nodep))
	 visit(nodep);
	}
	break;

   case _sort_rule_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 apply_rule(h[0]);
	}
	break;

   case _operation_rule_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE *nodep;
	 for (nodep= gt_fs(h[0]); nodep != NULL; nodep= gt_rb(nodep))
	 visit(nodep);
	}
	break;

   case _operation_rule_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 apply_rule(h[0]);
	}
	break;
  }
}

PUBLIC void
rag (r)
    TNODE* r;
{
  PROCESINI (r);
  if (ragerrors == 0)
    todo (r);
} /* end of rag */
