/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: ecuaciones.h,v $
 * Revision 1.4  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.3  1992/09/02  15:44:40  lotos
 * new option to remove externa annotations
 * new option to print and label the equations
 * new debugging options: save modified CAST
 * overall debugging and improvements
 *
 * Revision 1.2  92/01/14  15:25:02  lotos
 * distribution issues
 * 
 * Revision 1.1  91/02/06  20:11:48  lotos
 * Initial revision
 * 
 ***********************************/

/***********************************************************************

     "ecuaciones.h": cabecera de "ecuaciones.o".

***********************************************************************/

#ifndef ECUACIONES_H
#define ECUACIONES_H


TNODE *OpRaizMEc();
/* Devuelve un puntero a la operacion raiz de un miembro de una ec. */

/* Dice si una operacion (o variable) no esta en una ecuacion. */
#define NoEstaEnEc(IdOp)				\
	  ((IdOp) == NULL ||				\
	   (IdOp)->type != tvalue_expression ||		\
	   t_root(IdOp))

int NumArgOp();
/* Devuelve el numero de argumentos de una operacion. */

TNODE *PrimArgOp();
/* Devuelve un puntero al primer argumento de una operacion. */

TNODE *UltArgOp();
/* Devuelve un puntero al ultimo argumento de una operacin. */

TNODE *SigArgOp();
/* Devuelve un puntero al siguiente argumento de una operacion. */

TNODE *AntArgOp();
/* Devuelve un puntero al anterior argumento de una operacion. */

TNODE *OpArg();
/* Devuelve un puntero a la operacion con el argumento indicado. */

/* Dice si un arbol no es una expresion. */
#define NoEsExp(Exp)					\
	  ((Exp) == NULL ||				\
	   (Exp)->type != tvalue_expression)

TNODE *RaizExp();
/* Devuelve el nodo raiz de una expresion. */

TNODE *CreaIdVar();
/* Crea un nodo identificador de variable a partir de una operacion. */

void ModIdVar();
/* Modifica un nodo identificador de variable para que esta sea otra. */

TNODE *CreaExpVar();
/* Crea una expresion con una variable. */

TNODE *SustExp();
/* Sustituye una expresion dentro de una ecuacion por otra. */

TNODE *CreaPrem();
/* Crea una premisa a partir de sus miembros. */

void InsLisPremEc();
/* Inserta una lista de premisas en una ecuacion (en primer lugar). */

#endif
