/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: errores.h,v $
 * Revision 1.9  1993/03/29  18:09:10  lotos
 * add constructor verification/s
 *
 * Revision 1.8  1993/03/24  17:51:24  lotos
 * remove unnecessary messages (now in glad)
 *
 * Revision 1.7  1993/01/18  18:12:15  lotos
 * distribution issues
 *
 * Revision 1.6  1992/12/02  10:55:41  lotos
 * remove error message: unnamed sort
 * a warning moved into an error: unnamed operation
 *
 * Revision 1.5  1992/01/14  15:25:04  lotos
 * distribution issues
 *
 * Revision 1.4  91/11/20  13:05:39  lotos
 * new error messages about draw and parse annotations
 *
 * Revision 1.3  91/11/14  20:14:18  lotos
 * some new messages for annotation preprocessing
 *
 * Revision 1.2  91/04/11  18:28:42  lotos
 * new and/or better error messages
 *
 * Revision 1.1  91/02/06  20:12:12  lotos
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

/***********************************************************************

     "errores.h": cabecera de "errores.o".

***********************************************************************/

#ifndef ERRORES_H
#define ERRORES_H


typedef enum
{ ERR_COND_ANORMAL,
  ERR_NO_HAY_MEM,
  ERR_FUN_NO_IMPLEM,
  ERR_OPC_DESCON,
  ERR_NO_ABR_FICH,
  ERR_MIEM_IZ_VAR,
  ERR_MIEM_DCHO_INCOR,
  ERR_PREMISA_INCOR,
  ERR_MIEM_IZ_EXPEXT,
  ERR_MIEM_IZ_NOCONS,
  ERR_NOCONS_NOEC,
  ERR_COMPIL_ABORT
} CodErr; 	/* Codigos de error. */

void Error(CodErr IdErr, ...);
/* Escribe un mensaje de error con formato variable. */

/* Si se cumple la condicion, escribe un mensaje y aborta. */
/*      (Se activa definiendo la macro "DESARROLLO").      */
#ifdef DESARROLLO
#  define aborta_si(cond)					\
	  {							\
	    if (cond)						\
	      Error(ERR_COND_ANORMAL, __FILE__, __LINE__);	\
	  }
#else
#  define aborta_si(cond)
#endif

/* Evalua una expresion si se cumple una condicion, si no aborta. */
/*          (Se activa definiendo la macro "DESARROLLO").         */
#ifdef DESARROLLO
#  ifndef lint
#  define eval_si(cond, exp)					    \
	    (((cond)? NULL					    \
		    : (Error(ERR_COND_ANORMAL, __FILE__, __LINE__), \
		       NULL)),					    \
	     (exp))
#  else
#  define eval_si(cond, exp)					    \
	    (((cond)? (exp)					    \
		    : (Error(ERR_COND_ANORMAL, __FILE__, __LINE__), \
		       (exp))))
#  endif
#else
#  define eval_si(cond, exp)	(exp)
#endif

#endif
