/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: ildic.spe,v $
 Revision 2.10  1994/11/14  11:33:49  lotos
 avoid name collisions

 Revision 2.9  1994/11/08  16:53:06  lotos
 rename rename into xrename for portability

 Revision 2.8  1994/07/19  12:34:16  lotos
 adapted to revised ldi naming

 Revision 2.7  1994/07/18  18:33:31  lotos
  segregated LDI library (interpreter)

 Revision 2.6  1993/10/19  19:35:05  lotos
 intkaos.hh becomes public

 Revision 2.5  1993/10/19  18:33:23  lotos
 ported to BSD/386

 Revision 2.4  1993/09/20  12:39:05  lotos
 synchronized with kaos development
 adpated to kdatum
 udatum are not expected to be used
 reduce number of reserved words: new user lexicon

 Revision 2.3  1993/06/29  10:55:35  lotos
 fix rewriting of expressions in IF clauses

 Revision 2.2  1993/06/22  08:49:38  lotos
 fix variable redeclaration
 fix standard input reading (batch mode)

 Revision 2.1  1993/06/10  13:37:30  lotos
 completely remade

 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: ildic.spe,v 2.10 1994/11/14 11:33:49 lotos Exp $";
#endif
# include "rag.hh"
# include "nodes.h"
# include "grc.h"

IAT* grnl= NULL;

#include "swbus.h"
#include "ldi.hh"
#include "dtok.hh"

/* KJT 20/01/23: added function prototypes */
PUBLIC void xrename (char* old, char* new);
PUBLIC void displayrename ();

PRIVATE void
PROCESINI (r)
    TNODE* r;
{
  TNODE* h[33];
  /* KJT 20/01/23: added "int" type */
  register int i;
  int nr;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
     nr= grl[i];
     switch (nr) {
      case _rewrite_1:
	 adclr (-c_ffath, h[1], 1);
	 break;
      case _check_1:
	 adclr (-c_ffath, h[1], 2);
	 adclr (-c_ffath, h[2], 3);
	 break;
      case _let_1:
	 adclr (-c_ffath, h[2], 4);
	 adclr (-c_sort, h[1], 5);
	 adclr (-c_sort, h[2], 6);
	 break;
      case _identifier_declaration_1:
	 adclr (-c_sort, h[2], 7);
	 adclr (-c_sort, h[1], 8);
	 break;
      case _xfree_1:
	 if (h[2] != NULL)
	  adclr (-c_sort, h[2], 9);
	 if (h[1] != NULL)
	  adclr (-c_sort, h[1], 10);
	 break;
      case _resetvar_1:
	 if (h[2] != NULL)
	  adclr (-c_sort, h[2], 12);
	 if (h[1] != NULL)
	  adclr (-c_sort, h[1], 13);
	 break;
      case _if_1:
	 adclr (-c_ffath, h[1], 15);
	 adclr (-c_ffath, h[2], 16);
	 break;
      case _if_2:
	 adclr (-c_ffath, h[1], 17);
	 adclr (-c_ffath, h[2], 18);
	 break;
      case _value_expression_1:
	 if (h[2] != NULL)
	  adclr (-c_sort, h[2], 19);
	 if (h[1] != NULL)
	  adclr (-c_sort, h[1], 20);
	 if (h[1] != NULL)
	  adclr (-c_ffath, h[1], 21);
	 if (h[0] != NULL)
	  adclr (-c_onode, h[0], 22);
	 if (h[0] != NULL)
	  adclr (-c_rposs, h[0], 23);
	 break;
      case _value_expression_2:
	 if (h[4] != NULL)
	  adclr (-c_sort, h[4], 25);
	 if (h[2] != NULL)
	  adclr (-c_sort, h[2], 26);
	 if (h[2] != NULL)
	  adclr (-c_poss, h[2], 27);
	 if (h[2] != NULL)
	  adclr (-c_rposs, h[2], 28);
	 if (h[0] != NULL)
	  adclr (-c_rposs, h[0], 29);
	 if (h[1] != NULL)
	  adclr (-c_ffath, h[1], 30);
	 if (h[3] != NULL)
	  adclr (-c_ffath, h[3], 31);
	 if (h[3] != NULL)
	  adclr (-c_sort, h[3], 32);
	 if (h[2] != NULL)
	  adclr (-c_opid, h[2], 33);
	 if (h[2] != NULL)
	  adclr (-c_onode, h[2], 34);
	 if (h[0] != NULL)
	  adclr (-c_onode, h[0], 35);
	 break;
      case _term_expression_1:
	 if (h[1] != NULL)
	  adclr (-c_poss, h[1], 37);
	 if (h[1] != NULL)
	  adclr (-c_rposs, h[1], 38);
	 if (h[0] != NULL)
	  adclr (-c_rposs, h[0], 39);
	 if (h[2] != NULL)
	  adclr (-c_opid, h[2], 40);
	 if (h[1] != NULL)
	  adclr (-c_opid, h[1], 41);
	 if (h[1] != NULL)
	  adclr (-c_onode, h[1], 42);
	 if (h[0] != NULL)
	  adclr (-c_onode, h[0], 43);
	 break;
      case _term_expression_2:
	 adclr (-c_sort, h[1], 44);
	 adclr (-c_ffath, h[1], 45);
	 adclr (-c_onode, h[0], 46);
	 adclr (-c_rposs, h[0], 47);
	 break;
      case _value_expression_list_1:
	 if (h[0] != NULL)
	  adclr (-c_nar, h[0], 48);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_ffath, h[3], 49);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_snode, h[0], 50);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_snode, h[3], 51);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case item_1:
	 adclr (-c_item, h[0], 52);
	 break;
      case item_2:
	 adclr (-c_item, h[0], 53);
	 break;
      case item_3:
	 adclr (-c_item, h[0], 54);
	 break;
      case item_4:
	 adclr (-c_item, h[0], 55);
	 break;
      case _operation_identifier_1:
	 break;
      case _operation_identifier_2:
	 break;
      case _sort_identifier_1:
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCESINI */

PRIVATE void
PROCES0 (r)
    TNODE* r;
{
  TNODE* h[33];
  int nr;
  /* KJT 20/01/23: added "int" type */
  register int i;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
      nr= grl[i];
      switch (nr) {
      case _xfree_1:
	(void) eval (11, r);
	 break;
      case _resetvar_1:
	(void) eval (14, r);
	 break;
      case _value_expression_1:
	(void) eval (24, r);
	 break;
      case _value_expression_2:
	(void) eval (36, r);
	 break;
      case _operation_identifier_1:
	(void) eval (56, r);
	 break;
      case _operation_identifier_2:
	(void) eval (57, r);
	 break;
      case _sort_identifier_1:
	(void) eval (58, r);
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCES0 */

PUBLIC CLR_TYPE
eval (nar, r)
    int nar;
    TNODE* r;
{
  TNODE* h[33];

  if (r == NULL) return (CLR_TYPE)NULL;
  switch (nar) {
  case 1:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 2:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 3:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 4:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 5:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lkvsort ((int)fdclr (c_lexv,h[1], nar));
  case 6:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sort,h[1], nar);
  case 7:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lksort ((int)fdclr (c_lexv,h[2], nar));
  case 8:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sort,h[2], nar);
  case 9:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lksort ((int)fdclr (c_lexv,h[2], nar));
  case 10:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
			  if (h[2] == NULL)
			     return (CLR_TYPE) 0;
			   else
			     return (CLR_TYPE) fdclr (c_sort,h[2], nar);
  }
  case 11:
    h[0]= r;
    heval (h[0], h);
    if ( !( ((h[2] == NULL) || ((int)fdclr (c_sort,h[2], nar) != -1))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "sort mismatch at \"FREE _identifier_free_list ':' _sort_identifier\"\n"
	   );
  }
  return NULL;
  case 12:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lksort ((int)fdclr (c_lexv,h[2], nar));
  case 13:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
			  if (h[2] == NULL)
			     return (CLR_TYPE) 0;
			   else
			     return (CLR_TYPE) fdclr (c_sort,h[2], nar);
  }
  case 14:
    h[0]= r;
    heval (h[0], h);
    if ( !( ((h[2] == NULL) || ((int)fdclr (c_sort,h[2], nar) != -1))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "sort mismatch at \"TOFREE _identifier_reset_list ':' _sort_identifier\"\n"
	   );
  }
  return NULL;
  case 15:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 16:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 17:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 18:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) (INTlist) NULL;
  case 19:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lksort ((int)fdclr (c_lexv,h[2], nar));
  case 20:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     TATTR*	attr;
     int		sort;
     if(((attr=find_attr (c_sort,h[0])) != NULL)||
	((attr=find_attr (-c_sort,h[0]))!= NULL))
       sort = (int)fdclr(c_sort,h[0],1000+__LINE__);
     if (h[2] == NULL) {
       if (attr == NULL)
	  return (CLR_TYPE) 0;
       else
	 return (CLR_TYPE) sort;
     } else {
       if ((attr == NULL) || (sort == 0))
	  return (CLR_TYPE) fdclr (c_sort,h[2], nar);
       else {
	 if ((int)fdclr (c_sort,h[2], nar) == sort)
	    return (CLR_TYPE) sort;
	 else
	    return (CLR_TYPE) -1;
       }
     }
  }
  case 21:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ffath,h[0], nar);
  case 22:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_onode,h[1], nar);
  case 23:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_rposs,h[1], nar);
  case 24:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ((int)fdclr (c_sort,h[1], nar) != -1)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "sort mismatch at \"OF\"\n"
	   );
  }
  return NULL;
  case 25:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) lksort ((int)fdclr (c_lexv,h[4], nar));
  case 26:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     TATTR*      attr;
     int		sort;
     if(((attr=find_attr (c_sort,h[0])) != NULL)||
	((attr=find_attr (-c_sort,h[0]))!= NULL))
       sort = (int)fdclr(c_sort,h[0],1000+__LINE__);
      if (h[4] == NULL){
       if (attr == NULL)
	 sort = 0;
       else
	 sort = sort;
     } else {
       if (attr == NULL)
	 sort = (int) fdclr (c_sort,h[4], nar);
       else{
	 if ((int) fdclr (c_sort,h[4], nar) == sort)
	   sort = sort;
	 else
	   sort = -1;
       }
     }
      return (CLR_TYPE) sort;
  }
  case 27:
    h[0]= gt_ft (r);
    heval (h[0], h);

      return (CLR_TYPE) getposs ((int)fdclr (c_lexv,h[2], nar),
		     infix,
		     2,
		     (int)fdclr (c_sort,h[2], nar),
		    (TNODE*)h[2]);
  case 28:
    h[0]= gt_ft (r);
    heval (h[0], h);

      return (CLR_TYPE) getrpos ((INTlist)fdclr (c_poss,h[2], nar));
  case 29:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_rposs,h[2], nar);
  case 30:
    h[0]= gt_ft (r);
    heval (h[0], h);

	    return (CLR_TYPE) getnf ((int)fdclr (c_opid,h[2], nar), 1);
  case 31:
    h[0]= gt_ft (r);
    heval (h[0], h);

	    return (CLR_TYPE) getnf ((int)fdclr (c_opid,h[2], nar), 2);
  case 32:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
  case 33:
    h[0]= gt_ft (r);
    heval (h[0], h);

		 return (CLR_TYPE) getoid ((INTlist)fdclr (c_poss,h[2], nar),
			       (INTlist)fdclr (c_ffath,h[0], nar));
  case 34:
    h[0]= gt_ft (r);
    heval (h[0], h);

	  return (CLR_TYPE) mknode ((int)fdclr (c_opid,h[2], nar));
  case 35:
    h[0]= r;
    heval (h[0], h);

	  return (CLR_TYPE) kd_rw_node (mkinfix ((kdatum)fdclr (c_onode,h[2], nar),
				     (kdatum)fdclr (c_onode,h[1], nar),
				     (kdatum)fdclr (c_onode,h[3], nar)));
  case 36:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ((int)fdclr (c_sort,h[2], nar) != -1)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "sort mismatch at \"OF\"\n"
	   );
  }
  return NULL;
  case 37:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     if (h[2] == NULL) {
	return (CLR_TYPE) getposs ((int)fdclr (c_lexv,h[1], nar),
		      prefix,
		      0,
		      (int) fdclr (c_sort,h[0], nar),
		      (TNODE*)h[1]);
     } else {
	return (CLR_TYPE) getposs ((int)fdclr (c_lexv,h[1], nar),
		      prefix,
		      (int) fdclr (c_nar,h[2], nar),
		      (int) fdclr (c_sort,h[0], nar),
		      (TNODE*)h[1]);
     }
  }
  case 38:
    h[0]= gt_ft (r);
    heval (h[0], h);

       return (CLR_TYPE) getrpos ((INTlist)fdclr (c_poss,h[1], nar));
  case 39:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_rposs,h[1], nar);
  case 40:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_opid,h[1], nar);
  case 41:
    h[0]= gt_ft (r);
    heval (h[0], h);

		 return (CLR_TYPE) getoid ((INTlist)fdclr (c_poss,h[1], nar),
			       (INTlist)fdclr (c_ffath,h[0], nar));
  case 42:
    h[0]= gt_ft (r);
    heval (h[0], h);

		 return (CLR_TYPE) mknode ((int)fdclr (c_opid,h[1], nar));
  case 43:
    h[0]= r;
    heval (h[0], h);
  {
       if (h[2] == NULL)
	 return (CLR_TYPE) kd_rw_node (mkprefix ((kdatum)fdclr (c_onode,h[1], nar),
				     (klink)NULL, FALSE));
       else
	 return (CLR_TYPE) kd_rw_node (mkprefix ((kdatum)fdclr (c_onode,h[1], nar),
				     (klink)fdclr (c_snode,h[2], nar),
				     TRUE));
  }
  case 44:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sort,h[0], nar);
  case 45:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ffath,h[0], nar);
  case 46:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_onode,h[1], nar);
  case 47:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_rposs,h[1], nar);
  case 48:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

		  return (CLR_TYPE) getnar ((TNODE*)h[0]);
  case 49:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

		  return (CLR_TYPE) getnf ((int)fdclr (c_opid,h[0], nar),
			       nson (h[3]));
  case 50:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_snode,h[1], nar);
  case 51:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  {
	       if (h[4] == NULL)
		   return (CLR_TYPE) lnsnode ((kdatum)fdclr (c_onode,h[3], nar),
				  (klink)NULL,FALSE);
	      else
		   return (CLR_TYPE) lnsnode ((kdatum)fdclr (c_onode,h[3], nar),
				  (klink)fdclr (c_snode,h[4], nar),TRUE);
  }
  case 52:
    h[0]= r;
   return (CLR_TYPE) DSORTS;
  case 53:
    h[0]= r;
   return (CLR_TYPE) DOPNS;
  case 54:
    h[0]= r;
   return (CLR_TYPE) DEQNS;
  case 55:
    h[0]= r;
   return (CLR_TYPE) DVARS;
  case 56:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (int)fdclr (c_opid,h[0], nar) != 0
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "operation identifier \"%s\" not defined \n",
  SymbolTable->data[(int)fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 57:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (int)fdclr (c_opid,h[0], nar) != 0
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "operation identifier \"%s\" not defined \n",
  SymbolTable->data[(int)fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 58:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (int)fdclr (c_sort,h[0], nar) > 0
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "sort identifier \"%s\" not defined \n",
  SymbolTable->data[(int)fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
     }
  return (CLR_TYPE)NULL;
}






PUBLIC void
visit (r)
	TNODE*	r;
{
	TNODE*	h[33];
	int	nar;

  if (r == NULL) return;
  nar= *(grnl->data[(int)(r->value0)]);
  switch (nar) {

   case _cmdl_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux = gt_rb(aux)){
	 visit (aux);
	 }
	}
	break;

   case _quit_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) fprintf (stderr,"_quit\n");
	 quit = TRUE;
	}
	break;

   case _load_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 char* file;
	 if (ildidebug)
	 (void) fprintf (stderr,"load\n");
	 file = SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)];
	 if ( 0 != cload(file))
	 errorcount++;
	}
	break;

   case _rewrite_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 kdatum rw;
	 kdatum exp;
	 if (ildidebug)
	 (void) printf ("rewrite\n");
	 exp = (kdatum)fdclr (c_onode,h[1], nar);
	 if ((rw = kd_rw_node (exp)) != NULL){
	 if (usrb == TRUE){
	 (void) printf ("------->>>>>> %s >>>>\n",kd_draw(rw));
	 } else {
	 (void) printf ("------->>>>>> %s\n",kd_draw(rw));
	 }
	 } else {
	 (void) printf ("ildi: unable to rewrite expression\n");
	 }
	 usrb = FALSE;
	}
	break;

   case _check_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("check\n");
	 switch (ldiequal((kdatum)fdclr (c_onode,h[1], nar),(kdatum)fdclr (c_onode,h[2], nar))){
	 case EQ: (void) printf ("CHECK: OK\n"); break;
	 case NEQ: (void) printf ("CHECK: NOK\n"); break;
	 case UNDEF:(void) printf ("CHECK: UNDEF\n"); break;
	 }
	 usrb = FALSE;
	}
	break;

   case _var_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_var\n");
	 visit (h[1]);
	}
	break;

   case _let_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 int vid;
	 if (ildidebug)
	 (void) printf ("_let\n");
	 if (0 == (vid = get_var_id (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)],
	 (int)fdclr (c_sort,h[1], nar))))
	 (void) printf ("ildi: variable \"%s\" not declared previously\n",
	 SymbolTable->data[(int)(int)fdclr (c_lexv,h[1], nar)]);
	 else
	 if (0 == let_var ( vid, (kdatum)fdclr (c_onode,h[2], nar)))
	 (void) printf ("ildi: unable to initialice %s variable\n",
	 SymbolTable->data[(int)(int)fdclr (c_lexv,h[1], nar)]);
	}
	break;

   case _variable_declaration_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 if (ildidebug)
	 (void) printf ("_variable_declaration\n");
	 for (aux = h[1]; aux != NULL; aux = aux->brothers){
	 visit (aux);
	 }
	}
	break;

   case _identifier_declaration_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	}
	break;

   case _identifier_declaration_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 char* name;
	 int sort;
	 int vid;
	 if (ildidebug)
	 (void) printf ("_identifier_declaration\n");
	 for (aux = h[1]; aux != NULL; aux = aux->brothers){
	 name = SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)];
	 sort = (int) fdclr (c_sort,h[0], nar);
	 if (0 == (vid = dec_var (name, sort)))
	 (void) printf ("ildi: unable to declare \"%s\" variable\n",
	 SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)]);
	 }
	}
	break;

   case _xfree_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_free\n");
	 visit (h[1]);
	}
	break;

   case _identifier_free_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 char* name;
	 int sort;
	 int vid;
	 if (ildidebug)
	 (void) printf ("_identifier_free_list\n");
	 for (aux = h[1]; aux != NULL; aux = aux->brothers){
	 name = SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)];
	 sort = (int) fdclr (c_sort,h[0], nar);
	 if (0 == (vid = get_var_id (name, sort))){
	 (void) printf ("ildi: variable not found \"%s\" variable\n",
	 SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)]);
	 } else {
	 if (0 != free_var (vid, sort)){
	 (void) printf ("ildi: unable to free \"%s\" variable\n",
	 SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)]);
	 }
	 }
	 }
	}
	break;

   case _resetvar_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_reset\n");
	 visit (h[1]);
	}
	break;

   case _identifier_reset_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 char* name;
	 int sort;
	 int vid;
	 if (ildidebug)
	 (void) printf ("_identifier_reset_list\n");
	 for (aux = h[1]; aux != NULL; aux = aux->brothers){
	 name = SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)];
	 sort = (int) fdclr (c_sort,h[0], nar);
	 if (0 == (vid = get_var_id (name, sort))){
	 (void) printf ("ildi: variable not found \"%s\" variable\n",
	 SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)]);
	 } else {
	 if (0 != reset_var (vid)){
	 (void) printf ("ildi: unable to reset \"%s\" variable\n",
	 SymbolTable->data[(int)fdclr (c_lexv, aux,1000+__LINE__)]);
	 }
	 }
	 }
	}
	break;

   case _if_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("comando if-then\n");
	 if (TRUE == ldiequal ((kdatum)fdclr (c_onode,h[1], nar),
	 (kdatum)fdclr (c_onode,h[2], nar))){
	 visit (h[3]);
	 }
	}
	break;

   case _if_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("comando if-then-else\n");
	 if (TRUE == ldiequal ((kdatum)fdclr (c_onode,h[1], nar),
	 (kdatum)fdclr (c_onode,h[2], nar))){
	 visit (h[3]);
	 } else {
	 visit (h[4]);
	 }
	}
	break;

   case _display_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("comando display\n");
	 if (h[1] != NULL){
	 display ((int) fdclr (c_item,h[1], nar));
	 } else {
	 display (DSORTS);
	 display (DOPNS);
	 display (DEQNS);
	 display (DVARS);
	 }
	}
	break;

   case _setdeb_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_setdeb\n");
	 if (h[1] != NULL)
	 setdeb (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	 else
	 showdeb ();
	}
	break;

   case _stat_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("comando stat\n");
	 ldistat (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	}
	break;

   case _write_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_write\n");
	 cwrite (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	}
	break;

   case _reset_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_reset\n");
	 reset ();
	}
	break;

   case _exec_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_exec\n");
	 (void) exec (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	}
	break;

   case _help_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_help\n");
	 if (h[1] == 0)
	 chelp ("");
	 else
	 chelp (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	}
	break;

   case _rename_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_rename\n");
	 (void) xrename (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)],
	 SymbolTable->data[(int)fdclr (c_lexv,h[2], nar)]);
	}
	break;

   case _rename_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_rename\n");
	 displayrename ();
	}
	break;

   case _trace_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (ildidebug)
	 (void) printf ("_trace\n");
	 if (h[1] != NULL)
	 settrace (SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]);
	 else
	 showtrace ();
	}
	break;
  }
}

PUBLIC void
rag (r)
    TNODE* r;
{
  PROCESINI (r);
  PROCES0 (r);
  if (ragerrors == 0)
    todo (r);
} /* end of rag */
