/******************************************************
 *      basic.c: LBM Interpreter auxiliary functions
 ******************************************************/
/***********************************
   (C) Copyright 1992-1994; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: basic.c,v $
 * Revision 1.3  1994/10/17  16:40:25  lotos
 * cosmetics
 *
 * Revision 1.2  1994/01/26  19:19:47  lotos
 * PC does not support filenames stating with aux, prn, etc.
 * son aux.c has been renamed into basic.c
 *
 * Revision 1.1  1993/10/16  10:51:35  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: basic.c,v 1.3 1994/10/17 16:40:25 lotos Exp $";
#endif

# include "swbus.h"

/* hasta que arreglen el cast */
PUBLIC INTlist
myINTappend (L1, L2)
     INTlist L1, L2;
{
  INTlist start, this, prev, slot;

  if (L1 == NULL) {
    if (L2 != NULL)
      L2->cnt++;
    return L2;
  }
  if (L2 == NULL) {
    L1->cnt++;
    return L1;
  }
  prev= NULL;
  for (this= L1; this != NULL; this= this->next) {
    slot= INTcons (INThead (this), (INTlist)NULL);
    if (prev != NULL) {
      prev->next= slot;
      slot->cnt++;
    }
    else
      start= slot;
    prev= slot;
  }
  if (prev != NULL) {
    prev->next= L2;
    L2->cnt++;
    }
  return start;
}

PUBLIC int
id2ui (S, idx)
  spe      S;
  CLR_TYPE idx;
{
  if ((S->ATable->data[(int)idx].value0 == (CLR_TYPE)TSORT) ||
      (S->ATable->data[(int)idx].value0 == (CLR_TYPE)TOPN))
    return (int)ATfind (S->ATable, (int)idx, c_cui)->value;
  return (int)ATfind (S->ATable, (int)idx, c_ui)->value;
}

PUBLIC int
id2sort (S, idx)
  spe      S;
  CLR_TYPE idx;
{
  return (int)ATfind (S->ATable,(int)idx, c_sort)->value;
}

PUBLIC int
id2uisort (S, idx)
  spe      S;
  CLR_TYPE idx;
{
  return (int)ATfind (S->ATable,
		      (int)(ATfind (S->ATable,(int)(idx),c_sort)->value),
		      c_cui)->value;
}

PUBLIC int
lbm_node_type (S, r)
  spe   S;
  TNODE *r;
{
  return *(S->grnl->data[(int)(r->value0)]);
}

PUBLIC FILE*
efopen (filename, mode)
  char* filename, *mode;
{
  FILE* fp;

  if ((fp= fopen (filename, mode)) == NULL) {
    (void) fprintf (stderr, "cannot open file %s mode %s\n",
                    filename, mode);
    exit (1);
  }
  return fp;
}

PUBLIC void
fatal_error (error, nfile, nline)
  char *error, *nfile;
  int  nline;
{
  (void)fprintf (stderr, "%s in file %s at line %d\n",
		 error, nfile, nline);
  exit (1);
}
