/******************************************************
 *      swbus.h: LBM Interpreter swbus
 ******************************************************/
/***********************************
     (C) Copyright 1992-1994; dit/upm
     Distributed under the conditions stated in the
     TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: swbus.h,v $
 * Revision 1.3  1994/10/17  16:42:10  lotos
 * cosmetics
 *
 * Revision 1.2  1993/10/18  17:48:10  lotos
 * cleanup interface
 *
 * Revision 1.1  1993/10/16  10:56:09  lotos
 * Initial revision
 *
 ************************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# include "cast.hh"
# include "omnodes.h"
# include "omgrc.h"
# include "omcolours.h"
# include "intercolours.h"

#define l2s(S, idx) (char*)((S)->SymbolTable->data[(int)((S)->ATable->data[(int)(idx)].value1)])

# define idclass(S, idx)   (int)((S)->ATable->data[(int)(idx)].value0)

# define takeclr(clr, nd)       (find_attr(clr, nd)->value)

# define IsInfix(nd)       (find_attr(c_infix, nd) != NULL)

/*+++++ +++++*/
# define TSPEC  1
# define TTYPE  2
# define TSORT  3
# define TOPN   4
# define TPROC  5
# define TGATE  6
# define TVAL   7
/*+++++ +++++*/

#define MAX_TNODES 33 /* magic number from rag */

# include "inter.hh"

# include "ifldi.h"

/* -------------------- CONSTANTS --------------------------*/

/* --------------------   TYPES   --------------------------*/

/* -------------------- VARIABLES --------------------------*/

/* -------------------- FUNCTIONS --------------------------*/

#define INTdup(l) ((INTlist)cIL((CLR_TYPE)l))

/* From "basic.c" */
INTlist  myINTappend ();
int      id2ui ();
int      id2sort ();
int      id2uisort ();
int      lbm_node_type ();
FILE     *efopen ();
void     fatal_error ();

/* From "cond.c" */
#include "cond.h"

/* From "drawkrnlt.c" */
void     fdraw_kt ();
void     draw_kt ();

/* From "memo.c" */
#include "memo.h"

/* From "myheval.c" */
void     myheval();

/* From "offers.c" */
#include "offers.h"

/* From "offerset.c" */
#include "offerset.h"

/* From "rlbset.c" */
#include "rlbset.h"

/* From "transform.c" */
int      do_transform ();

/* From "tree.c" */
#include "tree.h"

