/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: lsa.cia,v $
 Revision 1.13  1993/04/29  09:24:20  lotos
 tratamiento de nuevas anotaciones
 generacion de numero de linea en la ATable

 Revision 1.12  1993/01/18  18:09:04  lotos
 distribution issues

 Revision 1.11  1992/11/04  16:14:37  lotos
 option -C to compact sorts and operations unique identifiers
 when a data type in incorrectly declared, it is assumed to have to formal component

 Revision 1.10  1992/08/31  17:49:21  lotos
 non-formal entities cannot be referenced in the formal section of an ADT
 minimal binding of value expressions

 Revision 1.9  92/02/21  17:13:08  lotos
 optimization of lists of operations, for speed up

 Revision 1.8  92/02/20  19:22:09  lotos
 adjust scope passed to local definitions: gates and values

 Revision 1.7  92/01/30  18:08:10  lotos
 outmost scope fixed
 fix data types traversing for flattening

 Revision 1.6  92/01/30  14:58:30  lotos
 semiflattening functions: completed

 Revision 1.5  92/01/22  19:59:45  lotos
 fixed bug w.r.t. [semi]flattening functions

 Revision 1.4  92/01/14  15:23:25  lotos

 distribution issues

 Revision 1.3  92/01/14  10:01:36  lotos
 ophuscation details

 Revision 1.2  92/01/13  16:26:00  lotos
 thousands of small bugs

 Revision 1.1  92/01/07  16:05:11  lotos
 Initial revision

 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: lsa.cia,v 1.13 1993/04/29 09:24:20 lotos Exp $";
#endif
# include "rag.hh"
# include "nodes.h"
# include "grc.h"

IAT* grnl= NULL;

# include "swbus.h"

/* KJT 20/01/23: added function prototypes */
PUBLIC int isformal (TNODE* type);
PUBLIC int timp (int lexv, TNODE* llib, TNODE* node);
PUBLIC int sfnover (INTlist fslist, INTlist slist);
PUBLIC int applyg (INTlist g, int value);
PUBLIC int opfnover (INTlist opflist, INTlist oplist);
PUBLIC int getpos (TNODE* node);
PUBLIC int gdef (INTlist gsop);

PRIVATE void
PROCESINI (r)
    TNODE* r;
{
  TNODE* h[33];
  /* KJT 20/01/23: added "int" type */
  register int i;
  int nr;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
     nr= grl[i];
     switch (nr) {
      case module_2:
	 adclr (-c_scp, h[0], 1);
	 break;
      case _specification_1:
	 adclr (-c_scp, h[0], 2);
	 adclr (-c_gates, h[5], 3);
	 adclr (-c_vals, h[5], 4);
	 adclr (-c_scp, h[5], 5);
	 adclr (-c_scp, h[2], 6);
	 adclr (-c_scp, h[4], 7);
	 adclr (-c_iddec, h[1], 8);
	 break;
      case _definition_block_1:
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 10);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 11);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 12);
	 break;
      case _local_definitions_1:
	 if (h[0] != NULL)
	  adclr (-c_types, h[0], 13);
	 if (h[0] != NULL)
	  adclr (-c_procs, h[0], 14);
	 if (h[0] != NULL)
	  adclr (-c_locals, h[0], 15);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_locals, h[3], 16);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 17);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_ltypes, h[3], 18);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_lprocs, h[3], 19);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _data_type_definitions_1:
	 if (h[0] != NULL)
	  adclr (-c_types, h[0], 24);
	 if (h[0] != NULL)
	  adclr (-c_locals, h[0], 25);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 26);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_ltypes, h[3], 27);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _library_declaration_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_idref, h[3], 31);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_types, h[0], 32);
	 if (h[0] != NULL)
	  adclr (-c_procs, h[0], 33);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_exp, h[3], 34);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_sorts, h[3], 35);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_opns, h[3], 36);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_sorts, h[0], 37);
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 38);
	 break;
      case _type_definition_1:
	 adclr (-c_tline, h[2], 39);
	 adclr (-c_iddec, h[1], 40);
	 adclr (-c_tiddec, h[2], 41);
	 adclr (-c_procs, h[0], 42);
	 adclr (-c_types, h[0], 43);
	 adclr (-c_sorts, h[0], 44);
	 adclr (-c_opns, h[0], 45);
	 adclr (-c_scp, h[2], 46);
	 adclr (-c_exp, h[0], 47);
	 break;
      case _p_expression_1:
	 if (h[0] != NULL)
	  adclr (-c_formal, h[0], 54);
	 if (h[1] != NULL)
	  adclr (-c_tiddec, h[1], 55);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 56);
	 if (h[0] != NULL)
	  adclr (-c_sorts, h[0], 57);
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 58);
	 if (h[0] != NULL)
	  adclr (-c_fsorts, h[0], 59);
	 if (h[0] != NULL)
	  adclr (-c_fopns, h[0], 60);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 61);
	 if (h[0] != NULL)
	  adclr (-c_exp, h[0], 62);
	 break;
      case _p_expression_2:
	 adclr (-c_tiddec, h[2], 63);
	 adclr (-c_actren, h[3], 64);
	 adclr (-c_idref, h[1], 65);
	 adclr (-c_oldexp, h[0], 66);
	 adclr (-c_scp, h[2], 67);
	 adclr (-c_F1, h[1], 68);
	 adclr (-c_S_F1, h[1], 69);
	 adclr (-c_FOP1, h[1], 70);
	 adclr (-c_OP_FOP1, h[1], 71);
	 adclr (-c_F2, h[1], 72);
	 adclr (-c_S_F2, h[1], 73);
	 adclr (-c_FOP2, h[1], 74);
	 adclr (-c_OP_FOP2, h[1], 75);
	 adclr (-c_gs, h[0], 76);
	 adclr (-c_go, h[0], 77);
	 adclr (-c_sorts, h[0], 78);
	 adclr (-c_opns, h[0], 79);
	 adclr (-c_fsorts, h[0], 80);
	 adclr (-c_fopns, h[0], 81);
	 adclr (-c_exp, h[0], 82);
	 adclr (-c_S1, h[3], 83);
	 adclr (-c_OP1, h[3], 84);
	 break;
      case _p_expression_3:
	 adclr (-c_actren, h[2], 91);
	 adclr (-c_idref, h[1], 92);
	 adclr (-c_oldexp, h[0], 93);
	 adclr (-c_gs, h[0], 94);
	 adclr (-c_go, h[0], 95);
	 adclr (-c_sorts, h[0], 96);
	 adclr (-c_opns, h[0], 97);
	 adclr (-c_fsorts, h[0], 98);
	 adclr (-c_fopns, h[0], 99);
	 adclr (-c_exp, h[0], 100);
	 adclr (-c_S1, h[2], 101);
	 adclr (-c_OP1, h[2], 102);
	 break;
      case _type_union_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_idref, h[3], 107);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_exp, h[3], 108);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_exp, h[0], 109);
	 if (h[0] != NULL)
	  adclr (-c_fsorts, h[0], 110);
	 if (h[0] != NULL)
	  adclr (-c_fopns, h[0], 111);
	 if (h[0] != NULL)
	  adclr (-c_sorts, h[0], 112);
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 113);
	 break;
      case _p_specification_1:
	 if (h[0] != NULL)
	  adclr (-c_formal, h[0], 114);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 115);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 116);
	 if (h[5] != NULL)
	  adclr (-c_scp, h[5], 117);
	 if (h[3] != NULL)
	  adclr (-c_scp, h[3], 118);
	 if (h[6] != NULL)
	  adclr (-c_scp, h[6], 119);
	 if (h[0] != NULL)
	  adclr (-c_sorts, h[0], 120);
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 121);
	 if (h[0] != NULL)
	  adclr (-c_fsorts, h[0], 122);
	 if (h[0] != NULL)
	  adclr (-c_fopns, h[0], 123);
	 if (h[0] != NULL)
	  adclr (-c_exp, h[0], 124);
	 break;
      case _replacement_1:
	 if (h[0] != NULL)
	  adclr (-c_repsorts, h[0], 125);
	 if (h[0] != NULL)
	  adclr (-c_repopns, h[0], 126);
	 if (h[1] != NULL)
	  adclr (-c_S1, h[1], 127);
	 if (h[2] != NULL)
	  adclr (-c_OP1, h[2], 128);
	 break;
      case _sort_pair_list_1:
	 if (h[0] != NULL)
	  adclr (-c_repsorts, h[0], 129);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_S1, h[3], 130);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _operation_pair_list_1:
	 if (h[0] != NULL)
	  adclr (-c_repopns, h[0], 131);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_OP1, h[3], 132);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _sort_pair_1:
	 adclr (-c_repsorts, h[0], 133);
	 adclr (-c_esid, h[2], 134);
	 break;
      case _operation_pair_1:
	 adclr (-c_repopns, h[0], 136);
	 adclr (-c_esid, h[2], 137);
	 break;
      case _formal_sorts_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_iddec, h[3], 139);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_fsorts, h[0], 140);
	 break;
      case _formal_operations_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 141);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_fopns, h[0], 142);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 143);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 144);
	 break;
      case _formal_equations_1:
	 if (h[1] != NULL)
	  adclr (-c_class, h[1], 145);
	 if (h[2] != NULL)
	  adclr (-c_class, h[2], 146);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 147);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 148);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 149);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 150);
	 break;
      case _sorts_1:
	 if (h[0] != NULL)
	  adclr (-c_sorts, h[0], 151);
	 break;
      case _sort_id_comm_1:
	 adclr (-c_iddec, h[1], 152);
	 adclr (-c_sorts, h[0], 153);
	 break;
      case _operations_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 154);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 155);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 156);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 157);
	 break;
      case _operation_1:
	 if (h[3] != NULL)
	  adclr (-c_idref, h[3], 158);
	 if (h[2] != NULL)
	  adclr (-c_class, h[2], 159);
	 if (h[1] != NULL)
	  adclr (-c_class, h[1], 160);
	 if (h[1] != NULL)
	  adclr (-c_sort, h[1], 161);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 162);
	 if (h[1] != NULL)
	  adclr (-c_argl, h[1], 163);
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 164);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 165);
	 break;
      case _descriptor_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_sort, h[3], 166);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_argl, h[3], 167);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 168);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_opns, h[0], 169);
	 break;
      case _operation_descriptor_1:
	 adclr (-c_iddec, h[1], 170);
	 adclr (-c_opns, h[0], 171);
	 break;
      case _operation_descriptor_2:
	 adclr (-c_iddec, h[1], 172);
	 adclr (-c_opns, h[0], 173);
	 break;
      case _argument_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_idref, h[3], 175);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_argl, h[0], 176);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 177);
	 break;
      case _equations_1:
	 if (h[1] != NULL)
	  adclr (-c_class, h[1], 178);
	 if (h[2] != NULL)
	  adclr (-c_class, h[2], 179);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 180);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 181);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 182);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 183);
	 break;
      case _equation_lists_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 184);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 185);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 186);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 187);
	 break;
      case _equation_list_1:
	 if (h[2] != NULL)
	  adclr (-c_class, h[2], 188);
	 if (h[3] != NULL)
	  adclr (-c_class, h[3], 189);
	 if (h[1] != NULL)
	  adclr (-c_idref, h[1], 190);
	 if (h[3] != NULL)
	  adclr (-c_inher, h[3], 191);
	 if (h[3] != NULL)
	  adclr (-c_scp, h[3], 192);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 193);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 194);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 195);
	 break;
      case _eqn_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 196);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 197);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_inher, h[3], 198);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 199);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 200);
	 break;
      case _equation_1:
	 adclr (-c_class, h[1], 201);
	 adclr (-c_scp, h[1], 202);
	 adclr (-c_inher, h[1], 203);
	 adclr (-c_rsorts, h[0], 204);
	 adclr (-c_ropns, h[0], 205);
	 break;
      case _equation_2:
	 adclr (-c_class, h[2], 206);
	 adclr (-c_class, h[1], 207);
	 adclr (-c_scp, h[1], 208);
	 adclr (-c_inher, h[1], 209);
	 adclr (-c_scp, h[2], 210);
	 adclr (-c_inher, h[2], 211);
	 adclr (-c_rsorts, h[0], 212);
	 adclr (-c_ropns, h[0], 213);
	 break;
      case _premisses_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 214);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 215);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_inher, h[3], 216);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 217);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 218);
	 break;
      case _simple_equation_1:
	 adclr (-c_class, h[1], 219);
	 adclr (-c_class, h[2], 220);
	 adclr (-c_scp, h[1], 221);
	 adclr (-c_scp, h[2], 222);
	 adclr (-c_inher, h[1], 223);
	 adclr (-c_inher, h[2], 224);
	 adclr (-c_rsorts, h[0], 225);
	 adclr (-c_ropns, h[0], 226);
	 break;
      case _process_definition_1:
	 adclr (-c_types, h[0], 230);
	 adclr (-c_procs, h[0], 231);
	 adclr (-c_iddec, h[1], 232);
	 adclr (-c_scp, h[2], 233);
	 adclr (-c_gates, h[3], 234);
	 adclr (-c_vals, h[3], 235);
	 adclr (-c_scp, h[3], 236);
	 break;
      case _formal_parameter_list_1:
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 238);
	 if (h[3] != NULL)
	  adclr (-c_scp, h[3], 239);
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 240);
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 241);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 242);
	 break;
      case _gate_parameter_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 245);
	 break;
      case _value_parameter_list_1:
	 adclr (-c_scp, h[1], 246);
	 adclr (-c_vals, h[0], 247);
	 adclr (-c_class, h[1], 248);
	 break;
      case _functionality_list_1:
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 249);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 250);
	 break;
      case _functionality_list_2:
	 adclr (-c_func, h[0], 251);
	 break;
      case _exit_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_idref, h[3], 252);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 253);
	 break;
      case _local_definition_expression_1:
	 adclr (-c_scp, h[1], 254);
	 adclr (-c_scp, h[2], 255);
	 adclr (-c_func, h[0], 256);
	 break;
      case _identifier_equations_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 257);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 258);
	 break;
      case _identifier_equation_1:
	 adclr (-c_class, h[1], 260);
	 adclr (-c_scp, h[1], 261);
	 adclr (-c_scp, h[2], 262);
	 adclr (-c_class, h[2], 263);
	 adclr (-c_inher, h[2], 264);
	 adclr (-c_vals, h[0], 265);
	 break;
      case _sum_expression_1:
	 adclr (-c_scp, h[1], 266);
	 adclr (-c_scp, h[2], 267);
	 adclr (-c_func, h[0], 268);
	 break;
      case sum_domain_expression_1:
	 adclr (-c_class, h[0], 269);
	 break;
      case _par_expression_1:
	 adclr (-c_scp, h[1], 270);
	 adclr (-c_scp, h[2], 271);
	 adclr (-c_scp, h[3], 272);
	 adclr (-c_func, h[0], 273);
	 break;
      case _parallel_operator_3:
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 274);
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 275);
	 break;
      case _hiding_expression_1:
	 adclr (-c_scp, h[2], 276);
	 adclr (-c_func, h[0], 277);
	 break;
      case _enable_expression_1:
	 adclr (-c_scp, h[1], 279);
	 adclr (-c_scp, h[2], 280);
	 adclr (-c_scp, h[3], 281);
	 adclr (-c_func, h[0], 282);
	 break;
      case _enable_operator_1:
	 if (h[1] != NULL)
	  adclr (-c_class, h[1], 284);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 285);
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 286);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 287);
	 break;
      case _disable_expression_1:
	 adclr (-c_scp, h[1], 288);
	 adclr (-c_scp, h[2], 289);
	 adclr (-c_func, h[0], 290);
	 break;
      case _parallel_expression_1:
	 adclr (-c_scp, h[1], 292);
	 adclr (-c_scp, h[2], 293);
	 adclr (-c_scp, h[3], 294);
	 adclr (-c_func, h[0], 295);
	 break;
      case _choice_expression_1:
	 adclr (-c_scp, h[1], 297);
	 adclr (-c_scp, h[2], 298);
	 adclr (-c_func, h[0], 299);
	 break;
      case _guarded_expression_1:
	 adclr (-c_scp, h[1], 301);
	 adclr (-c_scp, h[2], 302);
	 adclr (-c_inher, h[1], 303);
	 adclr (-c_func, h[0], 304);
	 break;
      case guard_1:
	 if (h[0] != NULL)
	  adclr (-c_class, h[0], 305);
	 break;
      case _action_prefix_expression_1:
	 adclr (-c_scp, h[2], 306);
	 adclr (-c_scp, h[3], 307);
	 adclr (-c_func, h[0], 308);
	 break;
      case _action_denotation_1:
	 adclr (-c_idref, h[1], 309);
	 adclr (-c_question, h[0], 310);
	 adclr (-c_iddec, h[0], 311);
	 break;
      case _action_denotation_2:
	 adclr (-c_idref, h[1], 312);
	 adclr (-c_scp, h[2], 313);
	 adclr (-c_scp, h[3], 314);
	 adclr (-c_vals, h[0], 315);
	 adclr (-c_question, h[0], 316);
	 adclr (-c_iddec, h[0], 317);
	 break;
      case _action_denotation_3:
	 adclr (-c_vals, h[0], 318);
	 adclr (-c_question, h[0], 319);
	 adclr (-c_iddec, h[0], 320);
	 break;
      case _experiment_offer_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 321);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 322);
	 if (h[0] != NULL)
	  adclr (-c_question, h[0], 323);
	 break;
      case _experiment_offer_1:
	 adclr (-c_gate, h[1], 325);
	 adclr (-c_question, h[0], 326);
	 adclr (-c_idref, h[2], 327);
	 adclr (-c_sort, h[1], 328);
	 adclr (-c_scp, h[1], 329);
	 adclr (-c_vals, h[0], 330);
	 break;
      case _experiment_offer_2:
	 adclr (-c_class, h[1], 331);
	 adclr (-c_question, h[0], 332);
	 adclr (-c_inher, h[1], 333);
	 adclr (-c_scp, h[1], 334);
	 adclr (-c_vals, h[0], 335);
	 break;
      case _identifier_declaration_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_gate, h[3], 336);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_iddec, h[3], 337);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 338);
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 339);
	 break;
      case _selection_predicate_1:
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 340);
	 if (h[1] != NULL)
	  adclr (-c_inher, h[1], 341);
	 break;
      case _atomic_expression_1:
	 adclr (-c_func, h[0], 342);
	 break;
      case _atomic_expression_2:
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 343);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 344);
	 break;
      case _atomic_expression_3:
	 adclr (-c_scp, h[2], 345);
	 adclr (-c_func, h[0], 346);
	 break;
      case _exit_entry_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 347);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 348);
	 break;
      case exit_entry_1:
	 adclr (-c_class, h[0], 349);
	 adclr (-c_inher, h[0], 350);
	 adclr (-c_func, h[0], 351);
	 break;
      case exit_entry_2:
	 adclr (-c_idref, h[0], 352);
	 adclr (-c_func, h[0], 353);
	 break;
      case _process_instantiation_1:
	 if (h[2] != NULL)
	  adclr (-c_idref, h[2], 354);
	 if (h[3] != NULL)
	  adclr (-c_scp, h[3], 355);
	 if (h[4] != NULL)
	  adclr (-c_scp, h[4], 356);
	 if (h[0] != NULL)
	  adclr (-c_func, h[0], 357);
	 break;
      case _actual_gate_list_1:
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 362);
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 363);
	 break;
      case _value_expression_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 364);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_sidref, h[0], 365);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 366);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_poss, h[0], 367);
	 if (h[0] != NULL)
	  adclr (-c_rposs, h[0], 368);
	 if (h[0] != NULL)
	  adclr (-c_idref, h[0], 369);
	 if (h[0] != NULL)
	  adclr (-c_sort, h[0], 370);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 371);
	 if (h[0] != NULL)
	  adclr (-c_ropns, h[0], 372);
	 break;
      case _value_expression_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 378);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 379);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 380);
	 break;
      case _identifier_declarations_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_class, h[3], 381);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 382);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_vals, h[0], 383);
	 if (h[0] != NULL)
	  adclr (-c_rsorts, h[0], 384);
	 break;
      case _identifier_declaration_1:
	 adclr (-c_gate, h[1], 386);
	 adclr (-c_idref, h[2], 387);
	 adclr (-c_sort, h[1], 388);
	 adclr (-c_vals, h[0], 389);
	 adclr (-c_sort, h[0], 390);
	 break;
      case _gate_declarations_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_scp, h[3], 391);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 392);
	 break;
      case _gate_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 394);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_idref, h[3], 395);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _gate_declaration_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 396);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_iddec, h[3], 397);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _gate_declaration_1:
	 if (h[1] != NULL)
	  adclr (-c_gate, h[1], 398);
	 if (h[0] != NULL)
	  adclr (-c_gates, h[0], 399);
	 if (h[1] != NULL)
	  adclr (-c_scp, h[1], 400);
	 if (h[2] != NULL)
	  adclr (-c_scp, h[2], 401);
	 break;
      case _operation_identifier_1:
	 break;
      case _operation_identifier_2:
	 break;
      case _type_identifier_1:
	 break;
      case _gate_identifier_1:
	 break;
      case _sort_identifier_1:
	 break;
      case _identifier_1:
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCESINI */

PRIVATE void
PROCES0 (r)
    TNODE* r;
{
  TNODE* h[33];
  int nr;
  /* KJT 20/01/23: added "int" type */
  register int i;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
      nr= grl[i];
      switch (nr) {
      case _specification_1:
	(void) eval (9, r);
	 break;
      case _local_definitions_1:
	(void) eval (20, r);
	(void) eval (21, r);
	(void) eval (22, r);
	(void) eval (23, r);
	 break;
      case _data_type_definitions_1:
	(void) eval (28, r);
	(void) eval (29, r);
	(void) eval (30, r);
	 break;
      case _type_definition_1:
	(void) eval (48, r);
	(void) eval (49, r);
	(void) eval (50, r);
	(void) eval (51, r);
	(void) eval (52, r);
	(void) eval (53, r);
	 break;
      case _p_expression_2:
	(void) eval (85, r);
	(void) eval (86, r);
	(void) eval (87, r);
	(void) eval (88, r);
	(void) eval (89, r);
	(void) eval (90, r);
	 break;
      case _p_expression_3:
	(void) eval (103, r);
	(void) eval (104, r);
	(void) eval (105, r);
	(void) eval (106, r);
	 break;
      case _sort_pair_1:
	(void) eval (135, r);
	 break;
      case _operation_pair_1:
	(void) eval (138, r);
	 break;
      case _operation_descriptor_2:
	(void) eval (174, r);
	 break;
      case _simple_equation_1:
	(void) eval (227, r);
	(void) eval (228, r);
	(void) eval (229, r);
	 break;
      case _process_definition_1:
	(void) eval (237, r);
	 break;
      case _formal_parameter_list_1:
	(void) eval (243, r);
	(void) eval (244, r);
	 break;
      case _identifier_equations_1:
	(void) eval (259, r);
	 break;
      case _hiding_expression_1:
	(void) eval (278, r);
	 break;
      case _enable_expression_1:
	(void) eval (283, r);
	 break;
      case _disable_expression_1:
	(void) eval (291, r);
	 break;
      case _parallel_expression_1:
	(void) eval (296, r);
	 break;
      case _choice_expression_1:
	(void) eval (300, r);
	 break;
      case _experiment_offer_list_1:
	(void) eval (324, r);
	 break;
      case _process_instantiation_1:
	(void) eval (358, r);
	(void) eval (359, r);
	(void) eval (360, r);
	(void) eval (361, r);
	 break;
      case _value_expression_1:
	(void) eval (373, r);
	(void) eval (374, r);
	(void) eval (375, r);
	(void) eval (376, r);
	(void) eval (377, r);
	 break;
      case _identifier_declarations_1:
	(void) eval (385, r);
	 break;
      case _gate_declarations_1:
	(void) eval (393, r);
	 break;
      case _operation_identifier_1:
	(void) eval (402, r);
	(void) eval (403, r);
	 break;
      case _operation_identifier_2:
	(void) eval (404, r);
	(void) eval (405, r);
	 break;
      case _type_identifier_1:
	(void) eval (406, r);
	(void) eval (407, r);
	 break;
      case _gate_identifier_1:
	(void) eval (408, r);
	(void) eval (409, r);
	 break;
      case _sort_identifier_1:
	(void) eval (410, r);
	(void) eval (411, r);
	 break;
      case _identifier_1:
	(void) eval (412, r);
	(void) eval (413, r);
	(void) eval (414, r);
	(void) eval (415, r);
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCES0 */

PUBLIC CLR_TYPE
eval (nar, r)
    int nar;
    TNODE* r;
{
  TNODE* h[33];

  if (r == NULL) return (CLR_TYPE)NULL;
  switch (nar) {
  case 1:
    h[0]= r;
   return (CLR_TYPE) newscp ();
  case 2:
    h[0]= r;
    heval (h[0], h);
  {
       TNscp*    scpnode;
       scpnode = newscp ();
       (void)addentries(scpnode,TSORT,(TNscp*)fdclr (c_locals,h[4], nar));
       (void)addentries(scpnode,TOPN, (TNscp*)fdclr (c_locals,h[4], nar));
	return (CLR_TYPE) scpnode;
  }
  case 3:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_gates,h[2], nar);
  case 4:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[2], nar);
  case 5:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
       TNscp*    scpnode;
       scpnode = newscp ();
       (void)addentry  (scpnode,TTYPE,(INTlist)fdclr (c_types,h[4], nar));
	return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 6:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     TNscp*        scpnode;
     scpnode = newscp ();
      return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 7:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     TNscp*        scpnode;
     scpnode = newscp ();
      return (CLR_TYPE) scpnode;
  }
  case 8:
    h[0]= gt_ft (r);
    heval (h[0], h);

		     return (CLR_TYPE) spdec ((int)fdclr (c_lexv,h[1], nar),
				  (INTlist)fdclr (c_gates,h[2], nar),
				  (INTlist)fdclr (c_vals,h[2], nar),
				  (INTlist)fdclr (c_func,h[2], nar));
  case 9:
    h[0]= r;
    heval (h[0], h);
    if ( !(   INTcmp ((INTlist) fdclr (c_func,h[2], nar),
	  (INTlist) fdclr (c_func,h[5], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: functionality does not match\n"
	   );
  }
  return NULL;
  case 10:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	 TNscp*        scpnode;
	 scpnode = newscp ();
	 (void) addentry (scpnode,TGATE,(INTlist)fdclr (c_gates,h[0], nar));
	 (void) addentry (scpnode,TVAL, (INTlist)fdclr (c_vals,h[0], nar));
	 if (h[2] != NULL){
	   (void)addentry   (scpnode, TPROC,(INTlist)fdclr (c_procs,h[2], nar));
	   (void)addentries (scpnode, TSORT,(TNscp*)fdclr (c_locals,h[2], nar));
	   (void)addentries (scpnode, TOPN, (TNscp*)fdclr (c_locals,h[2], nar));
	 }
	  return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 11:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 12:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[1], nar);
  case 13:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_types, h[1]);
  case 14:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_procs, h[1]);
  case 15:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
	     TNODE*      aux;
	     TNODE*      aux1;
	     INTlist     lsorts=NULL;
	     INTlist     lopns=NULL;
	     TNscp*      scpnode;
	     scpnode = newscp ();
	     for (aux = h[1]; aux != NULL; aux = aux->brothers){
	       if (aux->type == tlibrary_declaration){
		 for (aux1 = gt_fs(aux); aux1 != NULL; aux1 = gt_rb(aux1))
		   if (!isformal (aux1)){
		     lsorts= pilist(lsorts,(INTlist)fdclr(c_sorts,aux,1000+__LINE__)) ;
		     lopns=pilist(lopns,(INTlist)fdclr(c_opns,aux,1000+__LINE__));
		   }
	       }
	       if((aux->type==ttype_definition)&&(!isformal(aux))){
		 lsorts= pilist(lsorts,(INTlist)fdclr(c_sorts,aux,1000+__LINE__));
		 lopns=pilist(lopns,(INTlist)fdclr(c_opns,aux,1000+__LINE__));
	       }
	     }
	     (void) addentry (scpnode, TSORT, lsorts);
	     (void) addentry (scpnode, TOPN,  lopns);
	      return (CLR_TYPE) scpnode;
  }
  case 16:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_locals,h[0], nar);
  case 17:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  {
       if ((int)h[3]->type == tprocess_definition){
       TNscp*    scpnode;
       scpnode = newscp ();
       (void)addentries(scpnode, TOPN,(TNscp*)fdclr (c_locals,h[0], nar));
       (void)addentries(scpnode, TSORT,(TNscp*)fdclr (c_locals,h[0], nar));
       (void)linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	return (CLR_TYPE) scpnode;
       } else
	  return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  }
  case 18:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_types,h[0], nar);
  case 19:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_procs,h[0], nar);
  case 20:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(  cprocs ((INTlist) fdclr (c_procs,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: process name collision: %s\n", pcollision
	   );
  }
  return NULL;
  case 21:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   tdif ((INTlist) fdclr (c_types,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared types: %s\n", trdecs
	   );
  }
  return NULL;
  case 22:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   sdif ((TNscp*) fdclr (c_locals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared sorts in data-presentation: %s\n", srdecs
	   );
  }
  return NULL;
  case 23:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   odif ((TNscp*) fdclr (c_locals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared operations in data-presentation: %s\n", ordecs
	   );
  }
  return NULL;
  case 24:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

			     return (CLR_TYPE) cintlist (c_types, h[1]);
  case 25:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE*      aux;
     TNODE*      aux1;
     INTlist     lsorts=NULL;
     INTlist     lopns=NULL;
     TNscp*      scpnode;
     scpnode = newscp ();
     for (aux = h[1]; aux != NULL; aux = aux->brothers){
       if (aux->type == tlibrary_declaration){
	 for (aux1 = gt_fs(aux); aux1 != NULL; aux1 = gt_rb(aux1))
	 if (!isformal (aux1)){
	   lsorts=pilist(lsorts,(INTlist)fdclr(c_sorts,aux,1000+__LINE__));
	   lopns=pilist(lopns,(INTlist)fdclr(c_opns,aux,1000+__LINE__));
	 }
       }
       if ((aux->type==ttype_definition)&&(!isformal(aux))){
	 lsorts=pilist(lsorts,(INTlist)fdclr(c_sorts,aux,1000+__LINE__));
	 lopns=pilist(lopns,(INTlist)fdclr(c_opns,aux,1000+__LINE__));
       }
     }
     (void) addentry (scpnode, TSORT, lsorts);
     (void) addentry (scpnode,  TOPN,  lopns);
      return (CLR_TYPE) scpnode;
  }
  case 26:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 27:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_types,h[0], nar);
  case 28:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   tdif ((INTlist) fdclr (c_types,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared types: %s\n", trdecs
	   );
  }
  return NULL;
  case 29:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   sdif ((TNscp*) fdclr (c_locals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared sorts in data-presentation: %s\n", srdecs
	   );
  }
  return NULL;
  case 30:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   odif ((TNscp*) fdclr (c_locals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared operations in data-presentation: %s\n", ordecs
	   );
  }
  return NULL;
  case 31:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

		       return (CLR_TYPE) timp ((int)fdclr (c_lexv,h[3], nar), lib,h[3]);
  case 32:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cint (c_idref, h[1]);
  case 33:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) NULL;
  case 34:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

		  return (CLR_TYPE) getexp((int)fdclr (c_idref,h[3], nar),-3);
  case 35:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  {
		   if (isformal (h[3]))
		      return (CLR_TYPE) NULL;
		   else
		      return (CLR_TYPE) gdecs((TNexp*)fdclr (c_exp,h[3], nar), TSORT);
  }
  case 36:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  {
		   if (isformal (h[3]))
		      return (CLR_TYPE) NULL;
		   else
		       return (CLR_TYPE) gdecs((TNexp*)fdclr (c_exp,h[3], nar), TOPN);
  }
  case 37:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_sorts,h[1]);
  case 38:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_opns,h[1]);
  case 39:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_line,h[1], nar);
  case 40:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) tdec ((int)fdclr (c_lexv,h[1], nar),h[0]);
  case 41:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_iddec,h[1], nar);
  case 42:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 43:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTcons ((int)fdclr (c_iddec,h[1], nar),
					       (INTlist) NULL);
  case 44:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sorts,h[2], nar);
  case 45:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_opns,h[2], nar);
  case 46:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	    TNscp* scpnode;
	    scpnode = newscp();
	    (void) addentry (scpnode,TTYPE, (INTlist)fdclr (c_ltypes,h[0], nar));
	     return (CLR_TYPE) linkscp (scpnode,(TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 47:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_exp,h[2], nar);
  case 48:
    h[0]= r;
    heval (h[0], h);
    if ( !(   snover ((INTlist)fdclr (c_sorts,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared sorts in type: %s\n", ssnover
	   );
  }
  return NULL;
  case 49:
    h[0]= r;
    heval (h[0], h);
    if ( !(   snover ((INTlist)fdclr (c_fsorts,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared formal sorts in type: %s\n", sopnover
	   );
  }
  return NULL;
  case 50:
    h[0]= r;
    heval (h[0], h);
    if ( !(   opnover ((INTlist)fdclr (c_opns,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared operations in type: %s\n", sopnover
	   );
  }
  return NULL;
  case 51:
    h[0]= r;
    heval (h[0], h);
    if ( !(   opnover ((INTlist)fdclr (c_fopns,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: redeclared formal operations in type: %s\n", sopnover
	   );
  }
  return NULL;
  case 52:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (sfnover((INTlist)fdclr (c_fsorts,h[2], nar),(INTlist)fdclr (c_sorts,h[2], nar)))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sorts and formal sorts collision: %s\n", ssnover
	   );
  }
  return NULL;
  case 53:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (opfnover((INTlist)fdclr (c_fopns,h[2], nar),(INTlist)fdclr (c_opns,h[2], nar)))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: operations and formal operations collision: %s\n", sopnover
	   );
  }
  return NULL;
  case 54:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_formal,h[2], nar);
  case 55:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_tiddec,h[0], nar);
  case 56:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 57:
    h[0]= r;
    heval (h[0], h);
  {
		   if ( h[1] != NULL)
		      return (CLR_TYPE) INTappend ((INTlist)fdclr (c_sorts,h[2], nar),
				       (INTlist)fdclr (c_sorts,h[1], nar));
		   else
		      return (CLR_TYPE) fdclr (c_sorts,h[2], nar);
  }
  case 58:
    h[0]= r;
    heval (h[0], h);
  {
		   if ( h[1] != NULL)
		      return (CLR_TYPE) INTappend ((INTlist)fdclr (c_opns,h[2], nar),
				       (INTlist)fdclr (c_opns,h[1], nar));
		   else
		      return (CLR_TYPE) fdclr (c_opns,h[2], nar);
  }
  case 59:
    h[0]= r;
    heval (h[0], h);
  {
		   if ( h[1] != NULL)
		      return (CLR_TYPE) INTappend ((INTlist)fdclr (c_fsorts,h[2], nar),
				       (INTlist)fdclr (c_fsorts,h[1], nar));
		   else
		      return (CLR_TYPE) fdclr (c_fsorts,h[2], nar);
  }
  case 60:
    h[0]= r;
    heval (h[0], h);
  {
		   if ( h[1] != NULL)
		      return (CLR_TYPE) INTappend ((INTlist)fdclr (c_fopns,h[2], nar),
				       (INTlist)fdclr (c_fopns,h[1], nar));
		   else
		      return (CLR_TYPE) fdclr (c_fopns,h[2], nar);
  }
  case 61:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	TNscp*   scpnode;
	scpnode = newscp();
	if (h[1] != NULL){
	  (void) addentry (scpnode,TFSORT, (INTlist)fdclr (c_fsorts,h[1], nar));
	  (void) addentry (scpnode,TFOPN, (INTlist)fdclr (c_fopns,h[1], nar));
	  (void) addentry (scpnode,TSORT, (INTlist)fdclr (c_sorts,h[1], nar));
	  (void) addentry (scpnode,TOPN, (INTlist)fdclr (c_opns,h[1], nar));
	}
	 return (CLR_TYPE) scpnode;
  }
  case 62:
    h[0]= r;
    heval (h[0], h);
  {
      if (h[1] == NULL)
	 return (CLR_TYPE) fdclr (c_exp,h[2], nar);
      else
	 return (CLR_TYPE) expappend ((TNexp*)fdclr (c_exp,h[1], nar),
			  (TNexp*)fdclr (c_exp,h[2], nar),
			  FALSE);
  }
  case 63:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_tiddec,h[0], nar);
  case 64:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) ACT;
  case 65:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) tref ((int)fdclr (c_lexv,h[1], nar),
					       (TNscp*)fdclr (c_scp,h[0], nar));
  case 66:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getexp ((int)fdclr (c_idref,h[1], nar),
						(int)fdclr (c_tiddec,h[0], nar));
  case 67:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 68:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),
					       TFSORT);
  case 69:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),
						TSORT);
  case 70:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),
					       TFOPN);
  case 71:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),
						TOPN);
  case 72:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_fsorts,h[2], nar);
  case 73:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sorts,h[2], nar);
  case 74:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_fopns,h[2], nar);
  case 75:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_opns,h[2], nar);
  case 76:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getactgs ((int)fdclr (c_idref,h[1], nar),
					  (INTlist)fdclr (c_repsorts,h[3], nar),
					  (INTlist)fdclr (c_F1,h[1], nar),
					  (INTlist)fdclr (c_S_F1,h[1], nar),
					  (INTlist)fdclr (c_F2,h[1], nar),
					  (INTlist)fdclr (c_S_F2,h[1], nar),
					  (int*)fdclr (c_tline,h[0], nar));
  case 77:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getactgop ((int)fdclr (c_idref,h[1], nar),
					  (INTlist)fdclr (c_repopns,h[3], nar),
					  (INTlist)fdclr (c_gs,h[0], nar),
					  (INTlist)fdclr (c_FOP1,h[1], nar),
					  (INTlist)fdclr (c_OP_FOP1,h[1], nar),
					  (INTlist)fdclr (c_FOP2,h[1], nar),
					  (INTlist)fdclr (c_OP_FOP2,h[1], nar),
					  (int*)fdclr (c_tline,h[0], nar));
  case 78:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_gs,h[0], nar),TSORT);
  case 79:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_go,h[0], nar),TOPN);
  case 80:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_gs,h[0], nar),TFSORT);
  case 81:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_go,h[0], nar),TFOPN);
  case 82:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) actgsop ((TNexp*)fdclr (c_oldexp,h[0], nar),
					  (TNexp*)fdclr (c_exp,h[2], nar),
					  (INTlist)fdclr (c_gs,h[0], nar),
					  (INTlist)fdclr (c_go,h[0], nar));
  case 83:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) INTappend ((INTlist)fdclr (c_S_F1,h[1], nar),
					  (INTlist)fdclr (c_F1,h[1], nar));
  case 84:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) INTappend ((INTlist)fdclr (c_OP_FOP1,h[1], nar),
					  (INTlist)fdclr (c_FOP1,h[1], nar));
  case 85:
    h[0]= r;
    heval (h[0], h);
    if ( !(   srdif ((INTlist)fdclr (c_repsorts,h[3], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sort collision in actualization replacement: %s\n", srep
	   );
  }
  return NULL;
  case 86:
    h[0]= r;
    heval (h[0], h);
    if ( !(   srdif ((INTlist)fdclr (c_repopns,h[3], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: operation collision in actualization replacement: %s\n", srep
	   );
  }
  return NULL;
  case 87:
    h[0]= r;
    heval (h[0], h);
    if ( !(   gdef ((INTlist)fdclr (c_gs,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined actualization for sorts: %s\n", sgdef
	   );
  }
  return NULL;
  case 88:
    h[0]= r;
    heval (h[0], h);
    if ( !(   gdef ((INTlist)fdclr (c_go,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined actualization for operations: %s\n", sgdef
	   );
  }
  return NULL;
  case 89:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ginjact ((INTlist)fdclr (c_repsorts,h[3], nar),
	   (INTlist)(INTlist)fdclr (c_S_F1,h[1], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: non injective actualization for sorts: %s\n", sginj
	   );
  }
  return NULL;
  case 90:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ginjact ((INTlist)fdclr (c_repopns,h[3], nar),
	   (INTlist)(INTlist)fdclr (c_OP_FOP1,h[1], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: non injective actualization for operations: %s\n", sginj
	   );
  }
  return NULL;
  case 91:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) REN;
  case 92:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) tref ((int)fdclr (c_lexv,h[1], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar));
  case 93:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getexp((int)fdclr (c_idref,h[1], nar),
					   (int)fdclr (c_tiddec,h[0], nar));
  case 94:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getrengs ((INTlist)fdclr (c_repsorts,h[2], nar),
					  (TNexp*)fdclr (c_oldexp,h[0], nar),
					  (int*)fdclr (c_tline,h[0], nar));
  case 95:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getrengop((INTlist)fdclr (c_repopns,h[2], nar),
					   (TNexp*)fdclr (c_oldexp,h[0], nar),
					   (INTlist) fdclr (c_gs,h[0], nar),
					   (int*)fdclr (c_tline,h[0], nar));
  case 96:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_gs,h[0], nar),TSORT);
  case 97:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs ((INTlist)fdclr (c_go,h[0], nar),TOPN);
  case 98:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs((INTlist)fdclr (c_gs,h[0], nar),TFSORT);
  case 99:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) getdecs((INTlist)fdclr (c_go,h[0], nar),TFOPN);
  case 100:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) rengsop ((TNexp*) fdclr (c_oldexp,h[0], nar),
					    (INTlist)fdclr (c_gs,h[0], nar),
					    (INTlist)fdclr (c_go,h[0], nar));
  case 101:
    h[0]= gt_ft (r);
    heval (h[0], h);

	   return (CLR_TYPE) INTappend (gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),TSORT),
			    gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),TFSORT));
  case 102:
    h[0]= gt_ft (r);
    heval (h[0], h);

	   return (CLR_TYPE) INTappend (gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),TOPN),
			    gdecs ((TNexp*)fdclr (c_oldexp,h[0], nar),TFOPN));
  case 103:
    h[0]= r;
    heval (h[0], h);
    if ( !(   srdif ((INTlist)fdclr (c_repsorts,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sort collision in renaming replacement: %s\n", srep
	   );
  }
  return NULL;
  case 104:
    h[0]= r;
    heval (h[0], h);
    if ( !(   srdif ((INTlist)fdclr (c_repopns,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: operation collision in renaming replacement: %s\n", srep
	   );
  }
  return NULL;
  case 105:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ginj ((INTlist)fdclr (c_repsorts,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: non injective renaming for sorts: %s\n", sginj
	   );
  }
  return NULL;
  case 106:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ginj ((INTlist)fdclr (c_repopns,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: non injective renaming for operations: %s\n", sginj
	   );
  }
  return NULL;
  case 107:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) tref ((int)fdclr (c_lexv,h[3], nar),
						   (TNscp*)fdclr (c_scp,h[0], nar));
  case 108:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

		  return (CLR_TYPE) getexp((int)fdclr (c_idref,h[3], nar),
			       (int)fdclr (c_tiddec,h[0], nar));
  case 109:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
       TNODE* aux;
       TNexp* exp;
       exp = NULL;
       for (aux = h[1]; aux != NULL; aux = gt_rb(aux))
	 exp = expappend (exp, (TNexp*)fdclr(c_exp,aux,1000+__LINE__),TRUE);
	return (CLR_TYPE) exp;
  }
  case 110:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_exp,h[0], nar), TFSORT);
  case 111:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_exp,h[0], nar), TFOPN);
  case 112:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_exp,h[0], nar), TSORT);
  case 113:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gdecs ((TNexp*)fdclr (c_exp,h[0], nar), TOPN);
  case 114:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) ((h[1] != NULL)||(h[2] != NULL)||(h[3]!=NULL));
  case 115:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) linkscp (newscp (),
					   (TNscp*) fdclr (c_scp,h[0], nar));
  case 116:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   TNscp*        scpnode;
	   scpnode = newscp ();
	   if (h[1] != NULL)
	     (void) addentry (scpnode, TFSORT, (INTlist)fdclr (c_fsorts,h[1], nar));
	   (void) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	    return (CLR_TYPE) scpnode;
  }
  case 117:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   TNscp*        scpnode;
	   scpnode = newscp ();
	   if (h[1] != NULL)
	     (void) addentry (scpnode, TFSORT, (INTlist)fdclr (c_fsorts,h[1], nar));
	   if (h[4] != NULL)
	     (void) addentry (scpnode, TSORT, (INTlist)fdclr (c_sorts,h[4], nar));
	   (void) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	    return (CLR_TYPE) scpnode;
  }
  case 118:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   TNscp*        scpnode;
	   scpnode = newscp ();
	   if (h[1] != NULL)
	     (void) addentry (scpnode, TFSORT, (INTlist)fdclr (c_fsorts,h[1], nar));
	   if (h[2] != NULL)
	     (void) addentry (scpnode, TFOPN, (INTlist)fdclr (c_fopns,h[2], nar));
	   (void) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	    return (CLR_TYPE) scpnode;
  }
  case 119:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   TNscp*        scpnode;
	   scpnode = newscp ();
	   if (h[1] != NULL)
	     (void) addentry (scpnode, TFSORT, (INTlist)fdclr (c_fsorts,h[1], nar));
	   if (h[2] != NULL)
	     (void) addentry (scpnode, TFOPN, (INTlist)fdclr (c_fopns,h[2], nar));
	   if (h[4] != NULL)
	     (void) addentry (scpnode, TSORT, (INTlist)fdclr (c_sorts,h[4], nar));
	   if (h[5] != NULL)
	     (void) addentry (scpnode, TOPN, (INTlist)fdclr (c_opns,h[5], nar));
	   (void) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	    return (CLR_TYPE) scpnode;
  }
  case 120:
    h[0]= r;
    heval (h[0], h);
  {
		      if (h[4] != NULL)
			 return (CLR_TYPE) fdclr (c_sorts,h[4], nar);
		      else
			 return (CLR_TYPE) NULL;
  }
  case 121:
    h[0]= r;
    heval (h[0], h);
  {
		      if (h[5] != NULL)
			 return (CLR_TYPE) fdclr (c_opns,h[5], nar);
		      else
			 return (CLR_TYPE) NULL;
  }
  case 122:
    h[0]= r;
    heval (h[0], h);
  {
		      if (h[1] != NULL)
			 return (CLR_TYPE) fdclr (c_fsorts,h[1], nar);
		      else
			 return (CLR_TYPE) NULL;
  }
  case 123:
    h[0]= r;
    heval (h[0], h);
  {
		      if (h[2] != NULL)
			 return (CLR_TYPE) fdclr (c_fopns,h[2], nar);
		      else
			 return (CLR_TYPE) NULL;
  }
  case 124:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) mkexp (h[0]);
  case 125:
    h[0]= r;
    heval (h[0], h);
  {
		  if (h[1] != NULL)
		     return (CLR_TYPE) fdclr (c_repsorts,h[1], nar);
		  else
		     return (CLR_TYPE) NULL;
  }
  case 126:
    h[0]= r;
    heval (h[0], h);
  {
		  if (h[2] != NULL)
		     return (CLR_TYPE) fdclr (c_repopns,h[2], nar);
		  else
		     return (CLR_TYPE) NULL;
  }
  case 127:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_S1,h[0], nar);
  case 128:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_OP1,h[0], nar);
  case 129:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_repsorts, h[1]);
  case 130:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_S1,h[0], nar);
  case 131:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_repopns, h[1]);
  case 132:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_OP1,h[0], nar);
  case 133:
    h[0]= r;
    heval (h[0], h);

		 return (CLR_TYPE) INTcons ((int)fdclr (c_lexv,h[2], nar),
				INTcons ((int) fdclr (c_lexv,h[1], nar),
					 (INTlist)NULL));
  case 134:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) getsid ((int)fdclr (c_lexv,h[2], nar),
					      (INTlist)fdclr (c_S1,h[0], nar));
  case 135:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (fdclr (c_esid,h[2], nar) != 0)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: no sort for name \"%s\" in replacement\n",
	   SymbolTable->data[(int)fdclr (c_lexv,h[2], nar)]
	   );
  }
  return NULL;
  case 136:
    h[0]= r;
    heval (h[0], h);

		 return (CLR_TYPE) INTcons ((int)fdclr (c_lexv,h[2], nar),
				INTcons ((int)fdclr (c_lexv,h[1], nar),
					 (INTlist)NULL));
  case 137:
    h[0]= gt_ft (r);
    heval (h[0], h);

		 return (CLR_TYPE) getsid ((int)fdclr (c_lexv,h[2], nar),
			       (INTlist)fdclr (c_OP1,h[0], nar));
  case 138:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (fdclr (c_esid,h[2], nar) != 0)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: no operation for name \"%s\" in replacement\n",
	   SymbolTable->data[(int)fdclr (c_lexv,h[2], nar)]
	   );
  }
  return NULL;
  case 139:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  return (CLR_TYPE) sdec((int)fdclr (c_lexv,h[3], nar),
						 formal,
						 (int*)fdclr (c_line,h[3], nar));
  case 140:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cint (c_iddec, h[1]);
  case 141:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 142:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_opns, h[1]);
  case 143:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) formal;
  case 144:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_rsorts, h[1]);
  case 145:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) formal;
  case 146:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) formal;
  case 147:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 148:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	    if (h[1] != NULL )
	       return (CLR_TYPE) linkscp (addentry(newscp (), TVAL,
				       (INTlist)fdclr (c_vals,h[1], nar)),
			      (TNscp*)fdclr (c_scp,h[0], nar));
	    else
	       return (CLR_TYPE) linkscp (newscp (), (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 149:
    h[0]= r;
    heval (h[0], h);
  {
	   if (h[1] != NULL )
	      return (CLR_TYPE) INTunion ((INTlist)fdclr (c_rsorts,h[1], nar),
			       (INTlist)fdclr (c_rsorts,h[2], nar));
	   else
	      return (CLR_TYPE) fdclr (c_rsorts,h[2], nar);
  }
  case 150:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ropns,h[2], nar);
  case 151:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_sorts, h[1]);
  case 152:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     int sid;
     sid = sdec ((int)fdclr (c_lexv,h[1], nar),
		 nformal,
		 (int*)fdclr (c_line,h[1], nar));
     if (find_attr (c_lexical, h[1]))
      ATset(ATable,sid,c_lexical,find_attr(c_lexical,h[1])->value);
     if (find_attr (c_name, h[1]))
       ATset (ATable,sid, c_name, find_attr (c_name, h[1])->value);
     if (find_attr (c_draw, h[1]))
       ATset (ATable,sid, c_draw, find_attr (c_draw, h[1])->value);
     if (find_attr (c_parse, h[1]))
       ATset (ATable,sid,c_parse,find_attr (c_parse, h[1])->value);
     if (find_attr (c_equal, h[1]))
       ATset (ATable,sid,c_equal,find_attr (c_equal, h[1])->value);
     if (find_attr (c_extern, h[1]))
       ATset (ATable,sid,c_extern,find_attr(c_extern,h[1])->value);
     if (find_attr (c_free, h[1]))
       ATset (ATable,sid, c_free,find_attr (c_free, h[1])->value);
     if (find_attr (c_copy, h[1]))
       ATset (ATable,sid, c_copy,find_attr (c_copy, h[1])->value);
     if (find_attr (c_type, h[1]))
       ATset (ATable,sid, c_type,find_attr (c_type, h[1])->value);
     if (find_attr (c_nocopy, h[1]))
       ATset (ATable,sid,c_nocopy,find_attr(c_nocopy,h[1])->value);
     if (find_attr (c_nofree, h[1]))
       ATset (ATable,sid,c_nofree,find_attr(c_nofree,h[1])->value);
     if (find_attr (c_nodraw, h[1]))
       ATset (ATable,sid,c_nodraw,find_attr(c_nodraw,h[1])->value);
     if (find_attr (c_noparse, h[1]))
       ATset (ATable,sid,c_noparse,find_attr(c_noparse,h[1])->value);
      return (CLR_TYPE) sid;
  }
  case 153:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTcons ((int)fdclr (c_iddec,h[1], nar),
					    (INTlist)NULL);
  case 154:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 155:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) nformal;
  case 156:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_opns, h[1]);
  case 157:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_rsorts, h[1]);
  case 158:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[3], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar),
					    (int)fdclr (c_class,h[0], nar));
  case 159:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 160:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 161:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_idref,h[3], nar);
  case 162:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 163:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
		      if (h[2] != NULL)
			 return (CLR_TYPE) fdclr (c_argl,h[2], nar);
		      else
			 return (CLR_TYPE) NULL;
  }
  case 164:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_opns,h[1], nar);
  case 165:
    h[0]= r;
    heval (h[0], h);
  {
	 if (h[2] != NULL)
	   if (!isinlist ((int)fdclr (c_sort,h[1], nar),
			  (INTlist)fdclr (c_rsorts,h[2], nar)))
	      return (CLR_TYPE) INTcons ((int)fdclr (c_sort,h[1], nar),
			     (INTlist)fdclr (c_rsorts,h[2], nar));
	   else
	      return (CLR_TYPE) fdclr (c_rsorts,h[2], nar);
	 else
	    return (CLR_TYPE) INTcons((int)fdclr (c_sort,h[1], nar),(INTlist)NULL);
  }
  case 166:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_sort,h[0], nar);
  case 167:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_argl,h[0], nar);
  case 168:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 169:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_opns, h[1]);
  case 170:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     int oid;
     oid = odec ((int)fdclr (c_lexv,h[1], nar),
		 (INTlist)fdclr (c_argl,h[0], nar),
		 (int)fdclr (c_sort,h[0], nar),
		 prefix,
		 (int)fdclr (c_class,h[0], nar),
		 (int*)fdclr (c_line,h[1], nar));
     if (find_attr (c_call, h[1]))
       ATset(ATable,oid,c_call,find_attr(c_call,h[1])->value);
     if (find_attr (c_lexical, h[1]))
       ATset(ATable,oid,c_lexical,
	     find_attr(c_lexical,h[1])->value);
     if (find_attr (c_lexicalifpossible, h[1]))
       ATset(ATable,oid,c_lexicalifpossible,
	     find_attr(c_lexicalifpossible,h[1])->value);
     if (find_attr (c_internal, h[1]))
       ATset(ATable,oid,c_internal,
	     find_attr(c_internal,h[1])->value);
     if (find_attr (c_using, h[1]))
       ATset(ATable,oid,c_using,
	     find_attr(c_using,h[1])->value);
     if (find_attr (c_usingsort, h[1]))
       ATset(ATable,oid,c_usingsort,
	     find_attr(c_usingsort,h[1])->value);
     if (find_attr (c_constructor, h[1]))
       ATset(ATable,oid,c_constructor,
	     find_attr(c_constructor,h[1])->value);
     if (find_attr (c_nonconstructor, h[1]))
       ATset(ATable,oid,c_nonconstructor,
	     find_attr(c_nonconstructor,h[1])->value);
     if (find_attr (c_name, h[1]))
       ATset(ATable,oid,c_name,find_attr(c_name,h[1])->value);
     if (find_attr (c_extern, h[1]))
       ATset(ATable,oid, c_extern,
	     find_attr(c_extern,h[1])->value);
     if (find_attr (c_partial, h[1]))
       ATset(ATable,oid,c_partial,
	     find_attr(c_partial,h[1])->value);
      return (CLR_TYPE) oid;
  }
  case 171:
    h[0]= r;
    heval (h[0], h);

		return (CLR_TYPE) INTcons ((int)fdclr (c_iddec,h[1], nar),
			       (INTlist)NULL);
  case 172:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     int oid;
     oid = odec ((int)fdclr (c_lexv,h[1], nar),
		 (INTlist)fdclr (c_argl,h[0], nar),
		 (int)fdclr (c_sort,h[0], nar),
		 infix,
		 (int)fdclr (c_class,h[0], nar),
		 (int*)fdclr (c_line,h[1], nar));
     if (find_attr (c_call, h[1]))
       ATset(ATable,oid,c_call,find_attr(c_call,h[1])->value);
     if (find_attr (c_lexical, h[1]))
       ATset(ATable,oid,c_lexical,
	     find_attr(c_lexical,h[1])->value);
     if (find_attr (c_lexicalifpossible, h[1]))
       ATset(ATable,oid,c_lexicalifpossible,
	     find_attr(c_lexicalifpossible,h[1])->value);
     if (find_attr (c_internal, h[1]))
       ATset(ATable,oid,c_internal,
	     find_attr(c_internal,h[1])->value);
     if (find_attr (c_using, h[1]))
       ATset(ATable,oid,c_using,
	     find_attr(c_using,h[1])->value);
     if (find_attr (c_usingsort, h[1]))
       ATset(ATable,oid,c_usingsort,
	     find_attr(c_usingsort,h[1])->value);
     if (find_attr (c_constructor, h[1]))
       ATset(ATable,oid,c_constructor,
	     find_attr(c_constructor,h[1])->value);
     if (find_attr (c_nonconstructor, h[1]))
       ATset(ATable,oid,c_nonconstructor,
	     find_attr(c_nonconstructor,h[1])->value);
     if (find_attr (c_name, h[1]))
       ATset(ATable,oid,c_name,find_attr(c_name,h[1])->value);
     if (find_attr (c_extern, h[1]))
       ATset(ATable,oid, c_extern,
	     find_attr(c_extern,h[1])->value);
     if (find_attr (c_partial, h[1]))
       ATset(ATable,oid,c_partial,
	     find_attr(c_partial,h[1])->value);
      return (CLR_TYPE) oid;
  }
  case 173:
    h[0]= r;
    heval (h[0], h);

		return (CLR_TYPE) INTcons ((int)fdclr (c_iddec,h[1], nar),
			       (INTlist) NULL);
  case 174:
    h[0]= r;
    heval (h[0], h);
    if ( !(   (INTlength ((INTlist)fdclr (c_argl,h[0], nar)) == 2)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: infix operation \"%s\" has not two arguments\n",
	 SymbolTable->data[(int)fdclr (c_lexv,h[1], nar)]
	   );
  }
  return NULL;
  case 175:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) sref((int)fdclr (c_lexv,h[3], nar),
						  (TNscp*)fdclr (c_scp,h[0], nar),
						  (int)fdclr (c_class,h[0], nar));
  case 176:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) INTrev(cint (c_idref, h[1]));
  case 177:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_argl,h[0], nar);
  case 178:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 179:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 180:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 181:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   if (h[1] != NULL )
	      return (CLR_TYPE) linkscp (addentry(newscp (), TVAL,
				      (INTlist)fdclr (c_vals,h[1], nar)),
			     (TNscp*)fdclr (c_scp,h[0], nar));
	   else
	      return (CLR_TYPE) linkscp (newscp (), (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 182:
    h[0]= r;
    heval (h[0], h);
  {
	   if (h[1] != NULL )
	      return (CLR_TYPE) INTunion ((INTlist)fdclr (c_rsorts,h[1], nar),
			       (INTlist)fdclr (c_rsorts,h[2], nar));
	   else
	      return (CLR_TYPE) fdclr (c_rsorts,h[2], nar);
  }
  case 183:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ropns,h[2], nar);
  case 184:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 185:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 186:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_rsorts, h[1]);
  case 187:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_ropns, h[1]);
  case 188:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 189:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 190:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[1], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar),
					    (int)fdclr (c_class,h[0], nar));
  case 191:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_idref,h[1], nar);
  case 192:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	   if (h[2] != NULL)
	      return (CLR_TYPE) linkscp (addentry(newscp (), TVAL,
				      (INTlist)fdclr (c_vals,h[2], nar)),
				     (TNscp*)fdclr (c_scp,h[0], nar));
	   else
	      return (CLR_TYPE) linkscp (newscp (), (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 193:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 194:
    h[0]= r;
    heval (h[0], h);
  {
      INTlist auxl;
      int     aux;
      aux = (int)fdclr (c_idref,h[1], nar);
      if (h[2] != NULL){
	auxl = INTunion((INTlist)fdclr (c_rsorts,h[2], nar),
			(INTlist)fdclr (c_rsorts,h[3], nar));
	if (!isinlist (aux,auxl))
	   return (CLR_TYPE) INTcons(aux, auxl);
	else
	   return (CLR_TYPE) auxl;
      } else {
	if (!isinlist (aux,(INTlist)fdclr (c_rsorts,h[3], nar)))
	   return (CLR_TYPE) INTcons(aux, (INTlist)fdclr (c_rsorts,h[3], nar));
	else
	   return (CLR_TYPE) fdclr (c_rsorts,h[3], nar);
      }
  }
  case 195:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ropns,h[3], nar);
  case 196:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 197:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 198:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  case 199:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_rsorts,h[1]);
  case 200:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_ropns,h[1]);
  case 201:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 202:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 203:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  case 204:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_rsorts,h[1], nar);
  case 205:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_ropns,h[1], nar);
  case 206:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 207:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 208:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 209:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
  case 210:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 211:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  case 212:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTunion((INTlist)fdclr (c_rsorts,h[1], nar),
					 (INTlist)fdclr (c_rsorts,h[2], nar));
  case 213:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTunion((INTlist)fdclr (c_ropns,h[1], nar),
					(INTlist)fdclr (c_ropns,h[2], nar));
  case 214:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 215:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 216:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  case 217:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_rsorts,h[1]);
  case 218:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) addintlist (c_ropns,h[1]);
  case 219:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 220:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 221:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 222:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 223:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  case 224:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	    if (find_attr (c_impt, h[2]) != NULL)
	       return (CLR_TYPE) fdclr (c_sort,h[1], nar);
	    else
	       return (CLR_TYPE) fdclr (c_inher,h[0], nar);
  }
  case 225:
    h[0]= r;
    heval (h[0], h);

	      return (CLR_TYPE) INTunion ((INTlist)fdclr (c_rsorts,h[1], nar),
			      (INTlist)fdclr (c_rsorts,h[2], nar));
  case 226:
    h[0]= r;
    heval (h[0], h);

	      return (CLR_TYPE) INTunion ((INTlist)fdclr (c_ropns,h[1], nar),
			      (INTlist)fdclr (c_ropns,h[2], nar));
  case 227:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ((int)fdclr (c_sort,h[1], nar) != 0)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sort of value expression not defined\n"
	   );
  }
  return NULL;
  case 228:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ((int)fdclr (c_sort,h[2], nar) != 0)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sort of value expression not defined\n"
	   );
  }
  return NULL;
  case 229:
    h[0]= r;
    heval (h[0], h);
    if ( !(   ((int)fdclr (c_sort,h[1], nar) == (int)fdclr (c_sort,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sorts of value expressions are different\n"
	   );
  }
  return NULL;
  case 230:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 231:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTcons((int)fdclr (c_iddec,h[1], nar),
					      (INTlist) NULL);
  case 232:
    h[0]= gt_ft (r);
    heval (h[0], h);

		      return (CLR_TYPE) pdec ((int)fdclr (c_lexv,h[1], nar),
				  (INTlist)fdclr (c_gates,h[2], nar),
				  gsorts((INTlist)fdclr (c_vals,h[2], nar)),
				  (INTlist)fdclr (c_func,h[2], nar));
  case 233:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	 TNscp*        scpnode;
	 scpnode = newscp ();
	 (void)addentries(scpnode, TSORT, (TNscp*)fdclr (c_locals,h[0], nar));
	  return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 234:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_gates,h[2], nar);
  case 235:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[2], nar);
  case 236:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
       TNscp*        scpnode;
       scpnode = newscp ();
       (void) addentry (scpnode, TPROC,(INTlist)fdclr (c_lprocs,h[0], nar));
       (void) addentry (scpnode, TTYPE,(INTlist)fdclr (c_ltypes,h[0], nar));
       (void)linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
	return (CLR_TYPE) scpnode;
  }
  case 237:
    h[0]= r;
    heval (h[0], h);
    if ( !(   INTcmp ((INTlist) fdclr (c_func,h[2], nar),
	  (INTlist) fdclr (c_func,h[3], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: functionality does not match\n"
	   );
  }
  return NULL;
  case 238:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 239:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 240:
    h[0]= r;
    heval (h[0], h);
  {
		       if (h[1] != NULL)
			  return (CLR_TYPE) fdclr (c_gates,h[1], nar);
		       else
			  return (CLR_TYPE) NULL;
  }
  case 241:
    h[0]= r;
    heval (h[0], h);
  {
		       if (h[2] != NULL)
			  return (CLR_TYPE) fdclr (c_vals,h[2], nar);
		       else
			  return (CLR_TYPE) NULL;
  }
  case 242:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[3], nar);
  case 243:
    h[0]= r;
    heval (h[0], h);
    if ( !(  cvals ((INTlist) fdclr (c_vals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: value name collision: %s\n", vcollision
	   );
  }
  return NULL;
  case 244:
    h[0]= r;
    heval (h[0], h);
    if ( !(  cgates ((INTlist)fdclr (c_gates,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: gate names collision: %s\n", gcollision
	   );
  }
  return NULL;
  case 245:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_gates,h[1], nar);
  case 246:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 247:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[1], nar);
  case 248:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 249:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 250:
    h[0]= r;
    heval (h[0], h);
  {
			 if (h[1] != NULL)
			    return (CLR_TYPE) fdclr (c_func,h[1], nar);
			 else
			    return (CLR_TYPE) NULL;
  }
  case 251:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTcons (0, (INTlist) NULL);
  case 252:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[3], nar),
						   (TNscp*)fdclr (c_scp,h[0], nar),
						   nformal);
  case 253:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) INTrev(cint (c_idref, h[1]));
  case 254:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 255:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
		     TNscp*        scpnode;
		     scpnode = newscp ();
		     (void) addentry (scpnode, TVAL,
				      (INTlist)fdclr (c_vals,h[1], nar));
		      return (CLR_TYPE) linkscp (scpnode,
				     (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 256:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[2], nar);
  case 257:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 258:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  return (CLR_TYPE) cintlist (c_vals, h[1]);
  case 259:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(  cvals ((INTlist) fdclr (c_vals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: value name collision: %s\n", vcollision
	   );
  }
  return NULL;
  case 260:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 261:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 262:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 263:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 264:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_sort,h[1], nar);
  case 265:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[1], nar);
  case 266:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 267:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	     TNscp*        scpnode;
	     scpnode = newscp ();
	     if (h[1]->type == tgate_declarations)
	       (void) addentry (scpnode, TGATE,
				(INTlist)fdclr (c_gates,h[1], nar));
	     if (h[1]->type == tidentifier_declarations)
	       (void) addentry (scpnode, TVAL,
				(INTlist)fdclr (c_vals,h[1], nar));
	      return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 268:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[2], nar);
  case 269:
    h[0]= r;
   return (CLR_TYPE) nformal;
  case 270:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 271:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 272:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
		     TNscp*        scpnode;
		     scpnode = newscp ();
		     (void) addentry (scpnode, TGATE,
				      (INTlist) fdclr (c_gates,h[1], nar));
		      return (CLR_TYPE) linkscp (scpnode,(TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 273:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[3], nar);
  case 274:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 275:
    h[0]= r;
    heval (h[0], h);
  {
	       if (h[1] != NULL)
		  return (CLR_TYPE) fdclr (c_gates,h[1], nar);
	       else
		  return (CLR_TYPE) NULL;
  }
  case 276:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
		     TNscp*        scpnode;
		     scpnode = newscp ();
		     (void) addentry (scpnode, TGATE,
				      (INTlist)fdclr (c_gates,h[1], nar));
		      return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 277:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[2], nar);
  case 278:
    h[0]= r;
    heval (h[0], h);
    if ( !(   cgates ((INTlist)fdclr (c_gates,h[1], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: gate names collision: %s\n", gcollision
	   );
  }
  return NULL;
  case 279:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 280:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 281:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	     TNscp*        scpnode;
	     scpnode = newscp ();
	     (void) addentry (scpnode, TVAL,
			      (INTlist)fdclr (c_vals,h[2], nar));
	      return (CLR_TYPE) linkscp (scpnode, (TNscp*)fdclr (c_scp,h[0], nar));
  }
  case 282:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[3], nar);
  case 283:
    h[0]= r;
    heval (h[0], h);
    if ( !(   INTcmp ((INTlist) fdclr (c_func,h[1], nar),
	  (INTlist) fdclr (c_func,h[2], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: exit functionality does not match\n"
	   );
  }
  return NULL;
  case 284:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 285:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 286:
    h[0]= r;
    heval (h[0], h);
  {
		    if (h[1] != NULL)
		       return (CLR_TYPE) fdclr (c_vals,h[1], nar);
		    else
		       return (CLR_TYPE) NULL;
  }
  case 287:
    h[0]= r;
    heval (h[0], h);

	 if ( h[1] == NULL)
	       return (CLR_TYPE) (INTlist) NULL;
	 else  return (CLR_TYPE) gsorts((INTlist)fdclr (c_vals,h[1], nar));
  case 288:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 289:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 290:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) maxfunc((INTlist)fdclr (c_func,h[1], nar),
						(INTlist)fdclr (c_func,h[2], nar));
  case 291:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (fdclr (c_func,h[0], nar) == NULL) ||
 (0 <= INThead ((INTlist)fdclr (c_func,h[0], nar)))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined functionality\n"
	   );
  }
  return NULL;
  case 292:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 293:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 294:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 295:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) minfunc ((INTlist)fdclr (c_func,h[1], nar),
						  (INTlist)fdclr (c_func,h[3], nar));
  case 296:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (fdclr (c_func,h[0], nar) == NULL) ||
 (0 <= INThead ((INTlist)fdclr (c_func,h[0], nar)))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined functionality\n"
	   );
  }
  return NULL;
  case 297:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 298:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 299:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) maxfunc ((INTlist)fdclr (c_func,h[1], nar),
						(INTlist)fdclr (c_func,h[2], nar));
  case 300:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (fdclr (c_func,h[0], nar) == NULL) ||
 (0 <= INThead ((INTlist) fdclr (c_func,h[0], nar)))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined functionality\n"
	   );
  }
  return NULL;
  case 301:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 302:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 303:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
  case 304:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[2], nar);
  case 305:
    h[0]= r;
   return (CLR_TYPE) nformal;
  case 306:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 307:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	     if ((int) fdclr (c_question,h[2], nar) == TRUE)
		return (CLR_TYPE) linkscp (addentry (newscp(), TVAL,
					 (INTlist)fdclr (c_vals,h[2], nar)),
			       (TNscp*)fdclr (c_scp,h[0], nar));
	     else
		return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  }
  case 308:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[3], nar);
  case 309:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gref ((int)fdclr (c_lexv,h[1], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar));
  case 310:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 311:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) act_unique++;
  case 312:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) gref ((int)fdclr (c_lexv,h[1], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar));
  case 313:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 314:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
	  TNscp*        scpnode;
	  scpnode = newscp ();
	  if ((int)fdclr (c_question,h[2], nar)== TRUE){
	    (void)addentry (scpnode,TVAL,(INTlist)fdclr (c_vals,h[2], nar));
	     return (CLR_TYPE) linkscp (scpnode, (TNscp*) fdclr (c_scp,h[0], nar));
	  } else   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  }
  case 315:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[2], nar);
  case 316:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_question,h[2], nar);
  case 317:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) act_unique++;
  case 318:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 319:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 320:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) act_unique++;
  case 321:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 322:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist(c_vals,h[1]);
  case 323:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
		  TNODE* aux;
		  for (aux = h[1]; aux != NULL; aux = gt_rb(aux)){
		    if (TRUE == (int)fdclr(c_question, aux,1000+__LINE__))
		       return (CLR_TYPE) TRUE;
		  }
		   return (CLR_TYPE) FALSE;
  }
  case 324:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(  cvals ((INTlist) fdclr (c_vals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: value name collision: %s\n", vcollision
	   );
  }
  return NULL;
  case 325:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 326:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) TRUE;
  case 327:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[2], nar),
					    (TNscp*)fdclr (c_scp,h[0], nar),
					    nformal);
  case 328:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_idref,h[2], nar);
  case 329:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 330:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[1], nar);
  case 331:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) nformal;
  case 332:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 333:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
  case 334:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 335:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 336:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_gate,h[0], nar);
  case 337:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
  {
			if ((int)fdclr (c_gate,h[0], nar) == TRUE)
			   return (CLR_TYPE) gdec ((int)fdclr (c_lexv,h[3], nar));
			else
			   return (CLR_TYPE) vdec ((int)fdclr (c_lexv,h[3], nar),
				       (int)fdclr (c_sort,h[0], nar));
  }
  case 338:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
		    if ((int)fdclr (c_gate,h[0], nar) == TRUE)
		       return (CLR_TYPE) INTrev(cint (c_iddec, h[1]));
		    else
		       return (CLR_TYPE) NULL;
  }
  case 339:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
		    if ((int)fdclr (c_gate,h[0], nar) == TRUE)
		       return (CLR_TYPE) NULL;
		    else
		       return (CLR_TYPE) INTrev(cint (c_iddec, h[1]));
  }
  case 340:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 341:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) 0;
  case 342:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTcons (0, (INTlist) NULL);
  case 343:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 344:
    h[0]= r;
    heval (h[0], h);
  {
			if (h[2] != NULL)
			   return (CLR_TYPE) fdclr (c_func,h[2], nar);
			else
			   return (CLR_TYPE) NULL;
  }
  case 345:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 346:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_func,h[2], nar);
  case 347:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 348:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_func, h[1]);
  case 349:
    h[0]= r;
   return (CLR_TYPE) nformal;
  case 350:
    h[0]= r;
   return (CLR_TYPE) 0;
  case 351:
    h[0]= r;
  {
       if ((int)fdclr (c_idref,h[0], nar) <= 0)
	  return (CLR_TYPE) INTcons (0, (INTlist) NULL);
       else
	  return (CLR_TYPE) INTcons ((int)ATfind (ATable, (int)fdclr (c_idref,h[0], nar), c_sort)->value,                         (INTlist) NULL);
  }
  case 352:
    h[0]= r;
   return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[0], nar),
				      (TNscp*)fdclr (c_scp,h[0], nar),
				      nformal);
  case 353:
    h[0]= r;
   return (CLR_TYPE) INTcons ((int)fdclr (c_idref,h[0], nar),(INTlist)NULL);
  case 354:
    h[0]= gt_ft (r);
    heval (h[0], h);

			  return (CLR_TYPE) pref ((int)fdclr (c_lexv,h[2], nar),
				      (TNscp*)fdclr (c_scp,h[0], nar));
  case 355:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 356:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 357:
    h[0]= r;
    heval (h[0], h);
  {
       if ((int)fdclr (c_idref,h[2], nar) <= 0)
	  return (CLR_TYPE) INTcons (0, (INTlist) NULL);
       else
	return (CLR_TYPE) ATfind (ATable,(int)fdclr (c_idref,h[2], nar),c_func)->value;
  }
  case 358:
    h[0]= r;
    heval (h[0], h);
    if ( !(  ((int) fdclr (c_idref,h[2], nar) != UNDEC)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined process: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[2], nar)]
	   );
  }
  return NULL;
  case 359:
    h[0]= r;
    heval (h[0], h);
    if ( !(  ((int) fdclr (c_idref,h[2], nar) != UNRES)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved process: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[2], nar)]
	   );
  }
  return NULL;
  case 360:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((int) fdclr (c_idref,h[2], nar) < 0) ||
 ((h[3]==NULL)&&(0==ngts((int)fdclr (c_idref,h[2], nar))))||
 ((h[3]!=NULL)&&(ngts((int)fdclr (c_idref,h[2], nar))==INTlength((INTlist)fdclr (c_gates,h[3], nar)))))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: gate number does not match\n"
	   );
  }
  return NULL;
  case 361:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((int) fdclr (c_idref,h[2], nar) < 0) ||
 ((h[4]==NULL)&&( 0==gfs((int)fdclr (c_idref,h[2], nar))))||
 ((h[4]!=NULL)&&(INTcmp(gfs((int)fdclr (c_idref,h[2], nar)),gsorts((INTlist)fdclr (c_vals,h[4], nar))))))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: actual sorts do not match\n"
	   );
  }
  return NULL;
  case 362:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 363:
    h[0]= r;
    heval (h[0], h);
    return (CLR_TYPE) fdclr (c_gates,h[1], nar);
  case 364:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 365:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
		       if ((find_attr(c_ofsort, h[0]) == NULL)&&
			   (find_attr(-c_ofsort, h[0]) == NULL))
			  return (CLR_TYPE) 0;
		       else
			  return (CLR_TYPE) sref ((int)fdclr (c_ofsort,h[0], nar),
				     (TNscp*)fdclr (c_scp,h[0], nar),
				     (int)fdclr (c_class,h[0], nar));
  }
  case 366:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 367:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

			return (CLR_TYPE) getposs (h[0],
				       (int)fdclr (c_lexv,h[0], nar),
				       getpos(h[0]),
				       getnar(h[0]),
				       getinher(h[0]),
				       (TNscp*)fdclr (c_scp,h[0], nar),
				       (int)fdclr (c_class,h[0], nar));
  case 368:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

		return (CLR_TYPE) getrpos ((INTlist)fdclr (c_poss,h[0], nar));
  case 369:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

		   return (CLR_TYPE) getoid(h[0],
				(int)fdclr (c_lexv,h[0], nar),
				(TNscp*)fdclr (c_scp,h[0], nar),
				(INTlist)fdclr (c_poss,h[0], nar));
  case 370:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
	  if ((int) fdclr (c_idref,h[0], nar) <= 0)
	     return (CLR_TYPE) UNDEF;
	  else
	     return (CLR_TYPE) ATfind (ATable,(int)fdclr (c_idref,h[0], nar),c_sort)->value;
  }
  case 371:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
      INTlist auxl;
       auxl = addintlist (c_rsorts,h[1]);
       if (!isinlist( (int)fdclr (c_sort,h[0], nar), auxl))
	  return (CLR_TYPE) INTcons ((int)fdclr (c_sort,h[0], nar), auxl);
       else
	  return (CLR_TYPE) auxl;
  }
  case 372:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
      INTlist auxl;
      if((int)ATable->data[(int)fdclr(c_idref,h[0],1000+__LINE__)].value0 == TVAL)
	 return (CLR_TYPE) addintlist (c_ropns,h[1]);
      else{
	auxl = addintlist (c_ropns,h[1]);
	if (!isinlist((int) fdclr (c_idref,h[0], nar), auxl))
	   return (CLR_TYPE) INTcons ((int) fdclr (c_idref,h[0], nar), auxl);
	else
	   return (CLR_TYPE) auxl;
      }
  }
  case 373:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   ((int) fdclr (c_idref,h[0], nar) != UNRES)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved evaluation of operation: %s\n",
	  SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 374:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(   ((int) fdclr (c_idref,h[0], nar) != UNDEC)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined operation: %s\n",
	  SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 375:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !( ((find_attr(c_ofsort, h[0])==NULL) && (find_attr(-c_ofsort, h[0]) == NULL)) ||
 (((int)fdclr (c_sort,h[0], nar)==(int)fdclr (c_sidref,h[0], nar))
 && (getinher (h[0]) != 0))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: sort mismatch at \"OF %s\"\n",
	  SymbolTable->data[(int) fdclr (c_ofsort,h[0], nar)]
	   );
  }
  return NULL;
  case 376:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !( ((int) fdclr (c_sidref,h[0], nar) != UNRES)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved evaluation of sort: %s\n",
   SymbolTable->data[(int) fdclr (c_ofsort,h[0], nar)]
	   );
  }
  return NULL;
  case 377:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !( ((int) fdclr (c_sidref,h[0], nar) != UNDEC)
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined sort: %s\n",
   SymbolTable->data[(int) fdclr (c_ofsort,h[0], nar)]
	   );
  }
  return NULL;
  case 378:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) nformal;
  case 379:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 380:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
		 TNODE*    aux;
		 int       index;
		 INTlist   idlist=NULL;
		 for (aux = h[1]; aux != NULL; aux = gt_rb(aux)){
		   index = (int)fdclr(c_idref,aux,1000+__LINE__);
		   idlist = INTcons (index, idlist);
		 }
		  return (CLR_TYPE) INTrev(idlist);
  }
  case 381:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

			 return (CLR_TYPE) fdclr (c_class,h[0], nar);
  case 382:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

			 return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 383:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

		     return (CLR_TYPE) cintlist (c_vals, h[1]);
  case 384:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

		     return (CLR_TYPE) addint (c_sort,h[1]);
  case 385:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(  cvals ((INTlist) fdclr (c_vals,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: value name collision: %s\n", vcollision
	   );
  }
  return NULL;
  case 386:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 387:
    h[0]= gt_ft (r);
    heval (h[0], h);

		       return (CLR_TYPE) sref ((int)fdclr (c_lexv,h[2], nar),
				   (TNscp*)fdclr (c_scp,h[0], nar),
				   (int)fdclr (c_class,h[0], nar));
  case 388:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_idref,h[2], nar);
  case 389:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_vals,h[1], nar);
  case 390:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_idref,h[2], nar);
  case 391:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 392:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cintlist (c_gates, h[1]);
  case 393:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
    if ( !(  cgates ((INTlist) fdclr (c_gates,h[0], nar))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: gate name collision: %s\n", gcollision
	   );
  }
  return NULL;
  case 394:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cint (c_idref, h[1]);
  case 395:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gref ((int)fdclr (c_lexv,h[3], nar),
						   (TNscp*)fdclr (c_scp,h[0], nar));
  case 396:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) cint (c_iddec, h[1]);
  case 397:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);
   return (CLR_TYPE) gdec ((int)fdclr (c_lexv,h[3], nar));
  case 398:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) TRUE;
  case 399:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_gates,h[1], nar) ;
  case 400:
    h[0]= gt_ft (r);
    heval (h[0], h);

		 return (CLR_TYPE) addentry (newscp(), TGATE, (INTlist) fdclr (c_gates,h[2], nar));
  case 401:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_scp,h[0], nar);
  case 402:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined operation: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 403:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((find_attr (c_idref, h[0]) == NULL)&&
 (find_attr (-c_idref, h[0]) == NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved operation: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 404:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined operation: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 405:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved operation: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 406:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((find_attr (c_idref,h[0])== NULL) &&
  (find_attr (-c_idref, h[0]) == NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined type: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 407:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((find_attr (c_idref, h[0]) == NULL)&&
 (find_attr (-c_idref, h[0]) == NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved type: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 408:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined gate: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 409:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved gate: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 410:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined sort: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 411:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((find_attr (c_idref, h[0]) == NULL)&&
  (find_attr (-c_idref, h[0]) == NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved sort: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 412:
    h[0]= r;
    heval (h[0], h);
    if ( !(  (((int)fdclr (c_gate,h[0], nar) == TRUE)||
  ((find_attr (c_idref, h[0])==NULL)&&(find_attr (-c_idref, h[0])==NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined gate: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 413:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((int)fdclr (c_gate,h[0], nar) == TRUE)||
  ((find_attr (c_idref, h[0])==NULL)&&(find_attr (-c_idref, h[0])==NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved gate: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 414:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((int)fdclr (c_gate,h[0], nar) != TRUE)||
  ((find_attr (c_idref, h[0])==NULL)&&(find_attr (-c_idref, h[0])==NULL))||
  ((int) fdclr (c_idref,h[0], nar) != UNDEC))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: undefined value: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
  case 415:
    h[0]= r;
    heval (h[0], h);
    if ( !( (((int)fdclr (c_gate,h[0], nar) != TRUE)||
  ((find_attr (c_idref, h[0])==NULL)&&(find_attr (-c_idref, h[0])==NULL))||
 ((int) fdclr (c_idref,h[0], nar) != UNRES))
	)) {
     report (r, c_line);
     (void) fprintf (stderr, "lsa: unresolved value: %s\n",
	 SymbolTable->data[(int) fdclr (c_lexv,h[0], nar)]
	   );
  }
  return NULL;
     }
  return (CLR_TYPE)NULL;
}






PUBLIC void
visit (r)
	TNODE*	r;
{
	TNODE*	h[33];
	int	nar;

  if (r == NULL) return;
  nar= *(grnl->data[(int)(r->value0)]);
  switch (nar) {

   case _sorts_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 visit (aux);
	}
	break;

   case _sort_id_comm_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 find_attr (c_iddec,h[1])->value =
	 (CLR_TYPE)applyg (gsf,(int)find_attr (c_iddec,h[1])->value);
	}
	break;

   case _operations_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 visit (aux);
	}
	break;

   case _operation_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 if (h[2] != NULL)
	 visit (h[2]);
	 find_attr (c_idref,h[3])->value =
	 (CLR_TYPE)applyg (gsf,(int)find_attr(c_idref,h[3])->value);
	}
	break;

   case _descriptor_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 visit (aux);
	}
	break;

   case _operation_descriptor_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 find_attr (c_iddec,h[1])->value =
	 (CLR_TYPE)applyg(gof,(int)find_attr(c_iddec,h[1])->value);
	}
	break;

   case _operation_descriptor_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 find_attr (c_iddec,h[1])->value =
	 (CLR_TYPE)applyg(gof,(int)find_attr(c_iddec,h[1])->value);
	}
	break;

   case _argument_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 find_attr (c_idref,aux)->value =
	 (CLR_TYPE)applyg (gsf,(int)find_attr(c_idref,aux)->value);
	}
	break;

   case _equations_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 if (h[1] != NULL)
	 visit (h[1]);
	 visit (h[2]);
	}
	break;

   case _equation_lists_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 visit (aux);
	}
	break;

   case _equation_list_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 find_attr (c_idref,h[1])->value =
	 (CLR_TYPE)applyg(gsf,(int)find_attr(c_idref,h[1])->value);
	 if (h[2] != NULL)
	 visit (h[2]);
	 visit (h[3]);
	}
	break;

   case _eqn_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux= gt_rb(aux))
	 visit (aux);
	}
	break;

   case _equation_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	}
	break;

   case _equation_2 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 visit (h[2]);
	}
	break;

   case _premisses_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux = gt_rb(aux))
	 visit (aux);
	}
	break;

   case _simple_equation_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit(h[1]);
	 visit(h[2]);
	}
	break;

   case _identifier_declaration_list_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 int nsort;
	 if ((int)fdclr (c_gate,h[0], nar) == FALSE)
	 for (aux = gt_fs(h[0]);aux != NULL; aux = gt_rb(aux)){
	 nsort = applyg (gsf,(int)fdclr (c_sort,h[0], nar));
	 if (nsort != (int)fdclr (c_sort,h[0], nar)){
	 int org;
	 org= (int)find_attr (c_iddec,aux)->value;
	 find_attr (c_iddec,aux)->value =
	 (CLR_TYPE) vdec ((int)find_attr (c_lexv,aux)->value, nsort);
	 gvf= INTcons(org,INTcons ((int)find_attr (c_iddec,aux)->value,gvf));
	 }
	 }
	}
	break;

   case _value_expression_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 {
	 int sort, sdes, org, dest;
	 sort = (int)find_attr(c_sort,h[0])->value;
	 sdes = applyg(gsf,sort);
	 find_attr (c_sort,h[0])->value = (CLR_TYPE)sdes;
	 if ((int)ATable->data[(int)find_attr(c_idref,h[0])->value].value0 == TVAL)
	 {
	 if (sort != sdes){
	 org= (int)find_attr(c_idref,h[0])->value;
	 dest = applyg (gvf, org);
	 if ((dest > 0) && (dest != org))
	 find_attr (c_idref,h[0])->value = (CLR_TYPE) dest;
	 }
	 } else {
	 find_attr (c_idref,h[0])->value =
	 (CLR_TYPE)applyg(gof,(int)find_attr(c_idref,h[0])->value);
	 }
	 if ((int)find_attr(c_sidref, h[0])->value != 0)
	 find_attr (c_sidref,h[0])->value =
	 (CLR_TYPE)applyg(gsf,(int)find_attr(c_sidref,h[0])->value);
	 }
	 {
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux = gt_rb(aux)){
	 visit (aux);
	 }
	 }
	}
	break;

   case _identifier_declarations_1 :
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
	{
	 TNODE* aux;
	 for (aux = h[1]; aux != NULL; aux = gt_rb (aux))
	 visit (aux);
	}
	break;

   case _identifier_declaration_1 :
    h[0]= r;
    heval (h[0], h);
	{
	 visit (h[1]);
	 find_attr (c_idref,h[2])->value =
	 (CLR_TYPE)applyg (gsf,(int)find_attr(c_idref,h[2])->value);
	}
	break;
  }
}

PUBLIC void
rag (r)
    TNODE* r;
{
  PROCESINI (r);
  PROCES0 (r);
  if (ragerrors == 0)
    todo (r);
} /* end of rag */
