/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
 ***********************************
  $Log: swbus.h,v $
 * Revision 1.15  1993/04/29  09:24:20  lotos
 * cosmetica
 *
 * Revision 1.14  1993/01/18  18:09:04  lotos
 * distribution issues
 *
 * Revision 1.13  1993/01/12  20:19:30  lotos
 * portability issues
 *
 * Revision 1.12  1993/01/12  14:11:28  lotos
 * use conf.h for portability
 * remove tbil.hh
 *
 * Revision 1.11  1992/12/17  11:21:31  lotos
 * portability to PC
 *
 * Revision 1.10  1992/11/04  16:17:53  lotos
 * option -C to compact sorts and operations unique identifiers
 *
 * Revision 1.9  1992/09/11  15:11:45  lotos
 * remove shared colours (into the colours.{h,c})
 *
 * Revision 1.8  1992/08/31  17:51:07  lotos
 * non-formal entities cannot be referenced in the formal section of an ADT
 * minimal binding of value expressions
 *
 * Revision 1.7  92/05/06  17:35:40  lotos
 * new colour,
 * shut up lint complaints about exit()
 * 
 * Revision 1.6  92/02/21  17:13:37  lotos
 * optimization of lists of operations, for speed up
 * 
 * Revision 1.5  92/01/22  20:00:09  lotos
 * fixed bug w.r.t. [semi]flattening functions
 * 
 * Revision 1.4  92/01/14  15:23:39  lotos
 * distribution issues
 * 
 * Revision 1.3  92/01/14  10:02:58  lotos
 * for ophuscation
 * 
 * Revision 1.2  92/01/13  16:26:42  lotos
 * thousands of small bugs
 * 
 * Revision 1.1  92/01/07  16:06:03  lotos
 * Initial revision
 * 
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# include "cast.hh"
# include "rag.hh"
# include "nodes.h"

SHARED int spec_unique  ;
SHARED int type_unique  ;
SHARED int proc_unique  ;
SHARED int sort_unique  ;
SHARED int fsort_unique ;
SHARED int opns_unique  ;
SHARED int fopns_unique ;
SHARED int gate_unique  ;
SHARED int vals_unique  ;
SHARED int act_unique  ;

SHARED INTlist gvf;
SHARED INTlist gof;
SHARED INTlist gsf;

SHARED int    flagd;
SHARED int    flags;
SHARED int    flagf;
SHARED int    flagi;
SHARED int    flagC;

SHARED INTlist clex;

SHARED ST*     LSTable;
SHARED IAT*    Lgrnl  ;
SHARED AT*     LATable;


SHARED char*  trdecs;
SHARED char*  srdecs;
SHARED char*  ordecs;
SHARED char*  prdecs;
SHARED char*  srep;
SHARED char*  sgdef;
SHARED char*  sginj;
SHARED char*  ssnover;
SHARED char*  sopnover;
SHARED char*  vcollision;
SHARED char*  pcollision;
SHARED char*  gcollision;

SHARED AT*      ATable;
SHARED TNODE*   lib;

# include "colours.h"

# define c_scp      102
# define c_replace  103
# define c_vals     104
# define c_types    105
# define c_procs    106
# define c_locals   107
# define c_opns     108
# define c_sorts    109
# define c_fsorts   110
# define c_fopns    111
# define c_gs       112
# define c_go       113
# define c_repsorts 114
# define c_repopns  115
# define c_argl     116
# define c_gates    117
# define c_func     118
# define c_inher    119
# define c_poss     120
# define c_rposs    121
# define c_question 122
# define c_gate     123
# define c_nar      124
# define c_varsort  125
# define c_nsorts   126
# define c_nopns    127
# define c_exp      128
# define c_addr     129
# define c_class    130
# define c_nfsorts  131
# define c_nfopns   132
# define c_F1       133
# define c_S_F1     134
# define c_FOP1     135
# define c_OP_FOP1  136
# define c_F2       137
# define c_S_F2     138
# define c_FOP2     139
# define c_OP_FOP2  140
# define c_oldexp   141
# define c_tiddec   142
# define c_tidref   143
# define c_deps     144
# define c_actren   145
# define c_S1       146
# define c_OP1      147
# define c_esid     148
# define c_eoid     149
# define c_lprocs   150
# define c_ltypes   151
# define c_formal   162
# define c_oformal  163
# define c_ot       164
# define c_rsorts   165
# define c_ropns    166
# define c_isformal 167
# define c_tline    168

/*+++++ +++++*/
# define UNRES	-1
# define UNDEC	-2
# define UNDEF	-3

/*+++++ +++++*/
# define TSPEC  1
# define TTYPE  2
# define TSORT  3
# define TOPN   4
# define TPROC  5
# define TGATE  6
# define TVAL   7

# define NONE	0
# define TFSORT	8
# define TFOPN	9
/*+++++ +++++*/
# define formal 1
# define nformal 2
/*+++++ +++++*/

# define ACT 0
# define REN 1
/*+++++ +++++*/

# define prefix         1
# define infix          2

/*+++++ +++++*/

# define LDCBEGIN 0
# define LDCEND   1
# define LDCINIT  2

/*****  exported types  *****/
					  

	/**** entry  nodes ***/
typedef struct Tentry {
	struct Tentry*	next;
	int		class;
	INTlist		decs;
	} TNentry;

	/**** scp  nodes ***/
typedef struct Tscp {
	struct Tscp*	father;
	TNentry*	next;
	} TNscp;
	
	/**** expression  nodes ***/
typedef struct expr{
	int          make;
	TNODE*	     type;
	int	     complete;
	TNODE*	     sorts;
	TNODE*	     opns;
	TNODE*	     eqns;
	TNODE*	     fsorts;
	TNODE*	     fopns;
	TNODE*	     feqns;
	INTlist	     gs;
	INTlist	     go;
	} Texpr;

typedef struct nexp{
	struct nexp* next;
	Texpr*        exp;
	} TNexp;

/*****  exported functions  *****/

PUBLIC	TNscp*	newscp	  ();
PUBLIC	TNscp*	addentry  ();
PUBLIC  TNscp*  addentries();
PUBLIC	TNentry*newentry  ();
PUBLIC	void	putscp	  ();
PUBLIC	void	putexp	  ();
PUBLIC	CLR_TYPE	readexp	  ();
PUBLIC	int	odec	  ();
PUBLIC	int	sdec	  ();
PUBLIC	int	gdec	  ();
PUBLIC	int	tdec	  ();
PUBLIC	int	pdec	  ();
PUBLIC	int	spdec	  ();
PUBLIC	int	vdec	  ();

PUBLIC	int	sref	  ();
PUBLIC	int	tref	  ();
PUBLIC	int	pref	  ();
PUBLIC	int	gref	  ();

PUBLIC	int	getinher  ();
PUBLIC	int	getoid	  ();
PUBLIC	int	getnar	  ();
PUBLIC	INTlist	getrpos	  ();
PUBLIC	INTlist	getposs	  ();

PUBLIC TNexp*	mkexp	  ();
PUBLIC TNexp*	newnexp	  ();
PUBLIC Texpr*	newexpr	  ();
PUBLIC TNexp*	cpnexp	  ();
PUBLIC Texpr*	cpexpr	  ();
PUBLIC INTlist	getrengop ();
PUBLIC INTlist	getrengs  ();
PUBLIC INTlist	getactgop ();
PUBLIC INTlist	getactgs  ();
PUBLIC TNexp*	rnexp	  ();
PUBLIC INTlist	getsorts  ();
PUBLIC INTlist	getopns   ();
PUBLIC TNexp*	actexp	  ();
PUBLIC TNexp*	expappend ();
PUBLIC INTlist	getdecs   ();
PUBLIC TNexp*   rengsop   ();
PUBLIC TNexp*   actgsop   ();
PUBLIC INTlist	getactgop ();
PUBLIC INTlist	getactgs  ();

PUBLIC INTlist	maxfunc   ();
PUBLIC INTlist	minfunc   ();

PUBLIC int	opnover   ();
PUBLIC int	opnfover  ();
PUBLIC int	snover    ();
PUBLIC int	snfover   ();

PUBLIC int	tdif	  ();
PUBLIC int	sdif	  ();
PUBLIC int	odif	  ();
PUBLIC int	pdif	  ();

PUBLIC int	srdif	  ();
PUBLIC int	getsid	  ();
PUBLIC int	ginj	  ();
PUBLIC int	ginjact	  ();

PUBLIC int	cvals	  ();
PUBLIC int	cprocs	  ();
PUBLIC int	cgates	  ();

PUBLIC int	ngts      ();
PUBLIC INTlist	gfs       ();

PUBLIC TNODE*   mktype ();
PUBLIC INTlist	gsorts ();

PUBLIC INTlist	gdecs 	  ();
PUBLIC TNscp*	linkscp	  ();
PUBLIC INTlist	addintlist();
PUBLIC INTlist	addint    ();
PUBLIC INTlist	cintlist  ();
PUBLIC INTlist	cint      ();
PUBLIC INTlist	INTunion  ();
PUBLIC TNexp*	getexp	  ();

PUBLIC INTlist	pilist    ();
PUBLIC int	isinlist  ();

PUBLIC int	compact	  ();
PUBLIC void	fataler	  ();
